/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.lothrazar.playerbosses.EntityPlayerBoss;
import eaglemixins.config.ForgeConfigHandler;
import eaglemixins.handlers.util.AbyssalRiftSpawn;
import eaglemixins.util.Ref;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AbyssalRiftHandler {
    private static final UUID atkUUID = UUID.fromString("b1880265-48be-4681-84b2-bf99bc3e16e1");
    private static final UUID hpUUID = UUID.fromString("0629ce1b-fdcf-4432-a9c0-1f51c588c615");
    private static final UUID armorUUID = UUID.fromString("34407975-a8dc-479c-8dcc-70cc914418dc");
    private static final AttributeModifier dmgMod = new AttributeModifier(atkUUID, "AbyssalDmg", (double)(ForgeConfigHandler.abyssal.abyssalDmgModifier - 1.0f), 1);
    private static final AttributeModifier hpMod = new AttributeModifier(hpUUID, "AbyssalHP", (double)(ForgeConfigHandler.abyssal.abyssalHPModifier - 1.0f), 1);
    private static final AttributeModifier armorMod = new AttributeModifier(armorUUID, "AbyssalArmor", (double)(ForgeConfigHandler.abyssal.abyssalArmorModifier - 1.0f), 1);

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityParasiteBase)) {
            return;
        }
        EntityParasiteBase parasite = (EntityParasiteBase)event.getEntity();
        if (parasite.field_70170_p.field_72995_K) {
            return;
        }
        if (Ref.entityIsInAbyssalRift((Entity)parasite)) {
            if (!parasite.func_110148_a(SharedMonsterAttributes.field_111264_e).func_180374_a(dmgMod)) {
                parasite.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(dmgMod);
            }
            if (!parasite.func_110148_a(SharedMonsterAttributes.field_111267_a).func_180374_a(hpMod)) {
                parasite.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(hpMod);
            }
            if (!parasite.func_110148_a(SharedMonsterAttributes.field_188791_g).func_180374_a(armorMod)) {
                parasite.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(armorMod);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDrops(LivingDropsEvent event) {
        if (event.getDrops().isEmpty()) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_71093_bK != 0) {
            return;
        }
        if (entity instanceof EntityPlayerBoss && AbyssalRiftSpawn.isAbyssalRiftSpawn((Entity)entity)) {
            event.setCanceled(true);
            return;
        }
        if (!Ref.entityIsInAbyssalRift((Entity)entity)) {
            return;
        }
        if (entity.getEntityData().func_74764_b("InfernalMobsMod")) {
            return;
        }
        ArrayList<EntityItem> itemsToRemove = new ArrayList<EntityItem>();
        for (EntityItem drop : event.getDrops()) {
            if (!drop.func_92059_d().func_77973_b().equals(Items.field_151134_bR) || !(entity.func_70681_au().nextFloat() < ForgeConfigHandler.abyssal.chanceEnchants)) continue;
            itemsToRemove.add(drop);
        }
        event.getDrops().removeAll(itemsToRemove);
    }
}

