/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.config.folders;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.Config;

public class SRParasiteConfig {
    @Config.Comment(value={"Treat the allowed biomes list as whitelist. Set to false to treat as blacklist"})
    @Config.Name(value="SRParasites allowed biomes is whitelist")
    public boolean biomeListIsWhitelist = true;
    @Config.Comment(value={"List of biome IDs to whitelist or blacklist depending on biomeListIsWhitelist.\nThis list supports the * wildcard, example: biomesoplenty:* would whitelist all biomesoplenty biomes."})
    @Config.Name(value="SRParasites allowed biomes")
    public String[] biomeList = new String[]{"biomesoplenty:heath", "biomesoplenty:steppe", "biomesoplenty:wasteland", "openterraingenerator:overworld_abyssal_rift", "srparasites:biome_parasite", "openterraingenerator:overworld_lair_of_the_thing", "openterraingenerator:overworld_nuclear_ruins", "openterraingenerator:overworld_ruins_of_blight"};
    @Config.Comment(value={"Parasite display names that are allowed to always drop loot (even outside allowed biomes).\nThis matches the entity's *custom display name*, not its ID.\nIt's enough if the custom name contains any of these listed strings for it to be always allowed to drop loot."})
    @Config.Name(value="Parasite full loot-drop enabler")
    public String[] keepLootNames = new String[]{"Sentient Horror", "Degrading Overseer", "Malformed Observer", "Shivaxi", "Corrupted Carrier", "Necrotic Blight"};
    @Config.Comment(value={"All Beckons near one beckon will be killed"})
    @Config.Name(value="Kill Beckon nearby")
    public boolean killNearbyBeckon = true;
    @Config.Comment(value={"Range in radius blocks searched around the beckon for nearby beckons"})
    @Config.Name(value="Kill Beckon nearby range")
    public int killNearbyBeckonRange = 32;
    @Config.Comment(value={"All SRParasites outside of the allowed biomes in the allowed biome whitelist will automatically be killed"})
    @Config.Name(value="Kill Parasites outside alllowed biomes")
    public boolean killEscapedParasites = true;
    @Config.Comment(value={"Parasite drops in the overworld have a chance to instead drop as corrupted ashes. This is the chance for that to happen."})
    @Config.Name(value="Corrupted Ashes chance")
    public float chanceCorruptedAshes = 0.375f;
    List<String> allowedBiomeList = null;
    List<String> allowedParasiteNamesLoot = null;

    public List<String> getAllowedBiomeList() {
        if (this.allowedBiomeList == null) {
            this.allowedBiomeList = Arrays.asList(this.biomeList);
        }
        return this.allowedBiomeList;
    }

    public List<String> getAllowedParasiteNamesLoot() {
        if (this.allowedParasiteNamesLoot == null) {
            this.allowedParasiteNamesLoot = Arrays.asList(this.keepLootNames);
        }
        return this.allowedParasiteNamesLoot;
    }

    public void reset() {
        this.allowedBiomeList = null;
        this.allowedParasiteNamesLoot = null;
    }
}

