/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.config.folders;

import eaglemixins.EagleMixins;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class BerianConfig {
    @Config.Comment(value={"Chance of a librarian being converted to a Sussyberian on generation"})
    @Config.Name(value="Sussyberian Chance")
    @Config.RangeDouble(min=0.0, max=1.0)
    public double sussyberianChance = 0.05;
    @Config.Comment(value={"Chance of a librarian being converted to a Mentalberian on generation"})
    @Config.Name(value="Mentalberian Chance")
    @Config.RangeDouble(min=0.0, max=1.0)
    public double mentalberianChance = 0.05;
    @Config.Comment(value={"List of potion effects that sussyberians will give"})
    @Config.Name(value="Sussyberian Random Effect List")
    public String[] sussyberianEffects = new String[]{"potioncore:lightning", "potioncore:explode", "potioncore:explode", "potioncore:explode", "potioncore:explode", "potioncore:explode", "potioncore:explode", "potioncore:launch", "potioncore:launch", "potioncore:launch", "potioncore:launch", "potioncore:launch", "potioncore:launch"};
    @Config.Comment(value={"List of potion effects that mentalberians will randomly give"})
    @Config.Name(value="Mentalberian Random Effect List")
    public String[] mentalberianEffects = new String[]{"minecraft:nausea", "minecraft:mining_fatigue", "minecraft:blindness", "minecraft:unluck", "lycanitesmobs:paralysis", "lycanitesmobs:insomnia", "lycanitesmobs:fear", "lycanitesmobs:aphagia", "potioncore:klutz", "potioncore:spin", "potioncore:disorganization", "rustic:tipsy", "elenaidodge:sluggish", "srparasites:fear"};
    @Config.Comment(value={"Effect that clicking on berians will always give"})
    @Config.Name(value="Berian Constant Effect")
    public String berianConstantEffect = "mod_lavacow:soiled";
    private List<Potion> sussyberianEffectList = null;
    private List<Potion> mentalberianEffectList = null;
    private Potion berianConstantEffectPotion = null;

    public List<Potion> getSussyberianEffects() {
        if (this.sussyberianEffectList == null) {
            this.sussyberianEffectList = new ArrayList<Potion>();
            for (String name : this.sussyberianEffects) {
                if (name.trim().isEmpty()) continue;
                Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(name.trim()));
                if (potion == null) {
                    EagleMixins.LOGGER.log(Level.WARN, "Unable to find potion effect: " + name);
                    continue;
                }
                this.sussyberianEffectList.add(potion);
            }
        }
        return this.sussyberianEffectList;
    }

    public List<Potion> getMentalberianEffects() {
        if (this.mentalberianEffectList == null) {
            this.mentalberianEffectList = new ArrayList<Potion>();
            for (String name : this.mentalberianEffects) {
                if (name.trim().isEmpty()) continue;
                Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(name.trim()));
                if (potion == null) {
                    EagleMixins.LOGGER.log(Level.WARN, "Unable to find potion effect: " + name);
                    continue;
                }
                this.mentalberianEffectList.add(potion);
            }
        }
        return this.mentalberianEffectList;
    }

    public Potion getBerianConstantEffect() {
        if (this.berianConstantEffectPotion == null) {
            String name = this.berianConstantEffect.trim();
            Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(name));
            if (potion == null) {
                EagleMixins.LOGGER.log(Level.WARN, "Unable to find potion effect: " + name);
                this.berianConstantEffectPotion = MobEffects.field_76431_k;
            } else {
                this.berianConstantEffectPotion = potion;
            }
        }
        return this.berianConstantEffectPotion;
    }

    public void reset() {
        this.mentalberianEffects = null;
        this.sussyberianEffects = null;
        this.berianConstantEffect = null;
    }
}

