/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.config;

import eaglemixins.EagleMixins;
import eaglemixins.client.particles.ParticleRule;
import eaglemixins.client.particles.ParticlesClientRunner;
import eaglemixins.client.particles.ParticlesRuleParser;
import eaglemixins.config.folders.AbyssalConfig;
import eaglemixins.config.folders.BerianConfig;
import eaglemixins.config.folders.ConductivityConfig;
import eaglemixins.config.folders.IrradiatedConfig;
import eaglemixins.config.folders.MixinToggleConfig;
import eaglemixins.config.folders.NuclearConfig;
import eaglemixins.config.folders.SRParasiteConfig;
import eaglemixins.config.folders.TippedArrowConfig;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="eaglemixins")
public class ForgeConfigHandler {
    @Config.Comment(value={"Server-Side Options"})
    @Config.Name(value="Server Options")
    public static final ServerConfig server = new ServerConfig();
    @Config.Comment(value={"Client-Side Options"})
    @Config.Name(value="Client Options")
    public static final ClientConfig client = new ClientConfig();
    @Config.Comment(value={"Abyssal Rift Options"})
    @Config.Name(value="Abyssal Rift Options")
    public static final AbyssalConfig abyssal = new AbyssalConfig();
    @Config.Comment(value={"Irradiated Options"})
    @Config.Name(value="Irradiated Options")
    public static final IrradiatedConfig irradiated = new IrradiatedConfig();
    @Config.Comment(value={"Conductivity Options"})
    @Config.Name(value="Conductivity Options")
    public static final ConductivityConfig conductivity = new ConductivityConfig();
    @Config.Comment(value={"Tipped Arrow Options"})
    @Config.Name(value="Tipped Arrow Options")
    public static final TippedArrowConfig tippedarrows = new TippedArrowConfig();
    @Config.Comment(value={"Berian Options"})
    @Config.Name(value="Berian Options")
    public static final BerianConfig berian = new BerianConfig();
    @Config.Comment(value={"SRParasites Options"})
    @Config.Name(value="SRParasites Options")
    public static final SRParasiteConfig srparasites = new SRParasiteConfig();
    @Config.Comment(value={"Disable to not modify any code"})
    @Config.Name(value="Mixin Toggles")
    public static final MixinToggleConfig mixintoggles = new MixinToggleConfig();
    @Config.Comment(value={"NuclearCraft Options"})
    @Config.Name(value="NuclearCraft Options")
    public static final NuclearConfig nuclear = new NuclearConfig();
    @Config.Ignore
    public static final Set<String> cachedDrinkableBlocks = new HashSet<String>();

    public static void refreshDrinkableBlockCache() {
        cachedDrinkableBlocks.clear();
        cachedDrinkableBlocks.addAll(Arrays.asList(ForgeConfigHandler.server.waterblockListdrinkables));
    }

    public static void loadParticleRulesFromConfig() {
        String[] lines = ForgeConfigHandler.client.ambientparticlespawnlist;
        List<ParticleRule> rules = ParticlesRuleParser.parse(lines);
        ParticlesClientRunner.install(rules);
        EagleMixins.LOGGER.info("[Particles] Installed {} rules", (Object)rules.size());
    }

    @Mod.EventBusSubscriber(modid="eaglemixins")
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("eaglemixins")) {
                ConfigManager.sync((String)"eaglemixins", (Config.Type)Config.Type.INSTANCE);
                tippedarrows.reset();
                berian.reset();
                conductivity.reset();
                irradiated.reset();
                srparasites.reset();
                abyssal.reset();
                ForgeConfigHandler.refreshDrinkableBlockCache();
                if (FMLCommonHandler.instance().getSide().isClient()) {
                    ForgeConfigHandler.loadParticleRulesFromConfig();
                }
            }
        }
    }

    public static class ClientConfig {
        @Config.Comment(value={"How many seconds to display each loadingscreen picture"})
        @Config.Name(value="LoadingScreens: Frequency")
        public int frequency = 10;
        @Config.Comment(value={"Whether the loadingscreen pictures are displayed in set order or randomised order"})
        @Config.Name(value="LoadingScreens: Display in Random Order")
        public boolean randomOrder = true;
        @Config.Comment(value={"Whether there should be only one loadingscreen picture displayed per loading, no cycling during load. Will always display first picture in list if random order config is off"})
        @Config.Name(value="LoadingScreens: Don't Cycle")
        public boolean disableCycling = false;
        @Config.Comment(value={"Adds Particles to biomes", "Syntax: <dimension>,<biomeid>,[<blockid>|SOLID|<another block id>|<leave empty for all blocks>],[<particle>@color|<particle additional>@color|<randomly selected>],<ticksbetweenruns>,<maxperrun>,<chance>,<yoffset>,<add random y block>,<rise>,<range>,<canseesky|true|false>,<miny>,<maxy>,[thunder|rain|clear|leave empty for all],<optional biomedictionarytag overrules biomeid>", "Particles accept optional color via '@': REDSTONE@#RRGGBB, SPELL_MOB@r,g,b (0..1 or 0..255), NOTE@hue(0..1).", "Example: all, all, [], [SPELL_MOB@121,189,101], 3, 8, 1.0, 0.0, 0.01, 20, true, 0, 256, [], NUCLEAR", "Example: 0, minecraft:plains, [minecraft:grass|minecraft:tallgrass], [VILLAGER_HAPPY@121,189,101|TOWN_AURA@121,189,101], 3, 8, 1.0, 0.0, 0.01, 20, true, 0, 256, [], NUCLEAR", "Particle List: use /particle"})
        @Config.Name(value="Particle Spawn System")
        public String[] ambientparticlespawnlist = new String[]{"0, all, [], [SPELL_MOB], 3, 8, 1.0, 0.0, 0.01, 20, true, 0, 256, [], NUCLEAR", "0, minecraft:plains, [minecraft:grass|minecraft:tallgrass], [VILLAGER_HAPPY|TOWN_AURA], 3, 8, 1.0, 0.0, 0.01, 20, true, 0, 256, [thunder|rain|clear], NUCLEAR"};
    }

    public static class ServerConfig {
        @Config.Comment(value={"Chance of teleporting player to Underneath for exotic teleportation (through the concrete teleporters)"})
        @Config.Name(value="Teleportation Underneath chance 0 to 100")
        @Config.RangeInt(min=0, max=100)
        public int teleportation_chance = 1;
        @Config.Comment(value={"Add Blocks you can drink from, will be treated like water blocks"})
        @Config.Name(value="Additional Water Blocks:")
        public String[] waterblockListdrinkables = new String[]{"cookingforblockheads:sink"};
        @Config.Comment(value={"Give Dismounting entities the ability to dismount players when they target a player in Abyssal Rift or Parasite biomes"})
        @Config.Name(value="Dismount on target:")
        public boolean dismounterTarget = true;
        @Config.Comment(value={"Cannot rename any mob with or to these names"})
        @Config.Name(value="Blacklisted Name Change Any Mob")
        public String[] blackListEntitiesNameChangeAny = new String[]{"Dismounting", "Dismounter", "Dispel", "Sarevok", "IHaveNoClue", "Jester"};
        @Config.Comment(value={"Cannot rename Player Bosses with or to these names"})
        @Config.Name(value="Blacklisted Name Change Player Bosses")
        public String[] blackListEntitiesNameChangePlayerbosses = new String[]{"Blighted Shivaxi"};
        @Config.Comment(value={"Cannot rename parasites with or to these names"})
        @Config.Name(value="Blacklisted Name Change Parasite")
        public String[] blackListEntitiesNameChangeParasite = new String[]{"Sentient Horror", "Degrading Overseer", "Malformed Observer", "Shivaxi", "Corrupted Carrier", "Necrotic Blight"};
        @Config.Comment(value={"Health multiplier for Blighted Shivaxi"})
        @Config.Name(value="Blighted Shivaxi Health Multiplier")
        public float blightedShivaxiHealthModifier = 0.5f;
        @Config.Comment(value={"Armor multiplier for Blighted Shivaxi"})
        @Config.Name(value="Blighted Shivaxi Armor Multiplier")
        public float blightedShivaxiArmorModifier = 1.0f;
        @Config.Comment(value={"Damage multiplier for Blighted Shivaxi"})
        @Config.Name(value="Blighted Shivaxi Damage Multiplier")
        public float blightedShivaxiDamageModifier = 3.0f;
        @Config.Comment(value={"Chance of an underground un-looted chest becoming a mimic"})
        @Config.Name(value="Underground Mimic Chance")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double undergroundMimicChance = 0.05;
        @Config.Comment(value={"List of dimension IDs in which underground chests will have a chance to become mimics"})
        @Config.Name(value="Underground Mimic Dimensions")
        @Config.RequiresMcRestart
        public Integer[] undergroundMimicDimensions = new Integer[]{0};
        @Config.Comment(value={"Removes old item attributes (atk dmg and atk speed) from 1.0.4"})
        @Config.Name(value="Remove old Attribute Modifiers")
        public boolean removeOldAttributes = true;
        @Config.Name(value="Fix Biomes O Plenty Door Duplication")
        @Config.Comment(value={"Prevents Biomes O Plenty doors from dropping twice when broken"})
        public boolean fixBOPDoorDupe = true;
    }
}

