/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.client.sounds;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="eaglemixins", value={Side.CLIENT})
public class DeepslateSoundTuner {
    private static final ResourceLocation TARGET_BLOCK_ID = new ResourceLocation("eaglemixins", "deepslate");
    private static Block TARGET;

    private static Block target() {
        if (TARGET == null) {
            TARGET = (Block)ForgeRegistries.BLOCKS.getValue(TARGET_BLOCK_ID);
        }
        return TARGET;
    }

    @SubscribeEvent
    public static void onPlaySound(PlaySoundEvent event) {
        ISound s = event.getSound();
        if (s == null) {
            return;
        }
        if (s.func_184365_d() != SoundCategory.BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        BlockPos pos = new BlockPos(MathHelper.func_76141_d((float)s.func_147649_g()), MathHelper.func_76141_d((float)s.func_147654_h()), MathHelper.func_76141_d((float)s.func_147651_i()));
        if (!mc.field_71441_e.func_175667_e(pos)) {
            return;
        }
        Block at = mc.field_71441_e.func_180495_p(pos).func_177230_c();
        if (at != DeepslateSoundTuner.target() && (at = mc.field_71441_e.func_180495_p(pos.func_177977_b()).func_177230_c()) != DeepslateSoundTuner.target()) {
            return;
        }
        event.setResultSound(DeepslateSoundTuner.wrapWithPitch(s));
    }

    private static ISound wrapWithPitch(final ISound original) {
        return new ISound(){

            @Nonnull
            public ResourceLocation func_147650_b() {
                return original.func_147650_b();
            }

            @Nullable
            public SoundEventAccessor func_184366_a(@Nonnull SoundHandler handler) {
                return original.func_184366_a(handler);
            }

            @Nonnull
            public Sound func_184364_b() {
                return original.func_184364_b();
            }

            @Nonnull
            public SoundCategory func_184365_d() {
                return original.func_184365_d();
            }

            public boolean func_147657_c() {
                return original.func_147657_c();
            }

            public int func_147652_d() {
                return original.func_147652_d();
            }

            public float func_147653_e() {
                return original.func_147653_e();
            }

            public float func_147655_f() {
                try {
                    float out = original.func_147655_f() * 0.85f;
                    return MathHelper.func_76131_a((float)out, (float)0.5f, (float)2.0f);
                }
                catch (Throwable t) {
                    return MathHelper.func_76131_a((float)0.85f, (float)0.5f, (float)2.0f);
                }
            }

            public float func_147649_g() {
                return original.func_147649_g();
            }

            public float func_147654_h() {
                return original.func_147654_h();
            }

            public float func_147651_i() {
                return original.func_147651_i();
            }

            @Nonnull
            public ISound.AttenuationType func_147656_j() {
                return original.func_147656_j();
            }
        };
    }
}

