/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.client.particles;

import eaglemixins.client.particles.ParticleRule;
import eaglemixins.client.particles.ParticlesFactories;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ParticlesRuleParser {
    private ParticlesRuleParser() {
    }

    public static ParticleRule.ParticleSpec parseParticleSpec(String token) {
        String name = token;
        String arg = null;
        int at = token.indexOf(64);
        if (at >= 0) {
            name = token.substring(0, at).trim();
            arg = token.substring(at + 1).trim();
        }
        ParticleRule.ParticleSpec spec = new ParticleRule.ParticleSpec();
        spec.type = ParticlesRuleParser.resolveParticle(name);
        if (arg != null && !arg.isEmpty()) {
            if (spec.type == EnumParticleTypes.NOTE) {
                try {
                    spec.noteHue = Float.valueOf(ParticlesRuleParser.clamp01(Float.parseFloat(arg)));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (spec.type == EnumParticleTypes.REDSTONE || spec.type == EnumParticleTypes.SPELL_MOB || spec.type == EnumParticleTypes.SPELL_MOB_AMBIENT) {
                float[] rgb = ParticlesRuleParser.parseColor(arg);
                spec.hasColor = true;
                spec.r = rgb[0];
                spec.g = rgb[1];
                spec.b = rgb[2];
                if (spec.type == EnumParticleTypes.REDSTONE && spec.r <= 0.0f) {
                    spec.r = 0.001f;
                }
            }
        }
        return spec;
    }

    public static List<ParticleRule> parse(String[] lines) {
        ArrayList<ParticleRule> out = new ArrayList<ParticleRule>();
        if (lines == null) {
            return out;
        }
        int ln = 0;
        for (String raw : lines) {
            String line;
            ++ln;
            if (raw == null || (line = raw.trim()).isEmpty() || line.startsWith("#")) continue;
            try {
                out.add(ParticlesRuleParser.parseOne(line));
            }
            catch (Exception ex) {
                FMLLog.log.warn("[EagleMixins][Particles] Bad rule line {}: {}", (Object)ln, (Object)line, (Object)ex);
            }
        }
        return out;
    }

    private static ParticleRule parseOne(String s) {
        Object tag;
        String tt;
        List<String> we;
        String sky;
        Collection<Object> group;
        String fid;
        List<String> blocks;
        ResourceLocation rl;
        Biome b;
        List<String> f = ParticlesRuleParser.splitTopCSV(s);
        if (f.size() != 15 && f.size() != 16) {
            throw new IllegalArgumentException("Expected 15 or 16 fields, got " + f.size());
        }
        boolean hasYRand = f.size() == 16;
        ParticleRule r = new ParticleRule();
        String dim = f.get(0).trim();
        r.dimension = dim.equalsIgnoreCase("all") ? Integer.MIN_VALUE : Integer.parseInt(dim);
        String biomeId = f.get(1).trim();
        if (!biomeId.equalsIgnoreCase("all") && (b = (Biome)ForgeRegistries.BIOMES.getValue(rl = new ResourceLocation(biomeId))) != null) {
            r.biomeSet = Collections.singleton(b);
        }
        if ((blocks = ParticlesRuleParser.parseArray(f.get(2))).isEmpty()) {
            r.scanBlocks = true;
            r.blocksAll = true;
            r.blockSet = null;
            r.blocksSolidAny = false;
        } else if (blocks.size() == 1 && (ParticlesRuleParser.eq(blocks.get(0), "none") || ParticlesRuleParser.eq(blocks.get(0), "-"))) {
            r.scanBlocks = false;
            r.blocksAll = false;
            r.blockSet = null;
            r.blocksSolidAny = false;
        } else {
            r.scanBlocks = true;
            if (blocks.size() == 1 && ParticlesRuleParser.eq(blocks.get(0), "all")) {
                r.blocksAll = true;
                r.blockSet = null;
                r.blocksSolidAny = false;
            } else {
                r.blocksAll = false;
                HashSet<Block> set = new HashSet<Block>();
                boolean sawSolid = false;
                for (String tok : blocks) {
                    String id = tok.trim();
                    if (ParticlesRuleParser.eq(id, "solid")) {
                        sawSolid = true;
                        continue;
                    }
                    if (id.regionMatches(true, 0, "factory#", 0, 8)) {
                        fid = id.substring(8).trim();
                        group = ParticlesFactories.getBlockSet(fid);
                        if (group == null || group.isEmpty()) {
                            FMLLog.log.warn("[EagleMixins][Particles] Unknown or empty block factory '{}'", (Object)fid);
                            continue;
                        }
                        set.addAll(group);
                        continue;
                    }
                    Block blk = Block.func_149684_b((String)id);
                    if (blk != null) {
                        set.add(blk);
                        continue;
                    }
                    FMLLog.log.warn("[EagleMixins][Particles] Unknown block id '{}'", (Object)id);
                }
                r.blockSet = set.isEmpty() ? null : set;
                r.blocksSolidAny = sawSolid;
            }
        }
        List<String> parts = ParticlesRuleParser.parseArray(f.get(3));
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("Particles array may not be empty");
        }
        ArrayList<Object> pl = new ArrayList<Object>(parts.size());
        for (String token : parts) {
            String t = token.trim();
            if (t.regionMatches(true, 0, "factory#", 0, 8)) {
                fid = t.substring(8).trim();
                group = ParticlesFactories.getParticleGroup(fid);
                if (group.isEmpty()) {
                    throw new IllegalArgumentException("Unknown or empty particle factory: " + fid);
                }
                pl.addAll(group);
                continue;
            }
            pl.add(ParticlesRuleParser.parseParticleSpec(t));
        }
        r.particles = pl.toArray(new ParticleRule.ParticleSpec[0]);
        r.ticksBetweenRuns = Math.max(1, Integer.parseInt(f.get(4).trim()));
        r.maxPerRun = Math.max(1, Integer.parseInt(f.get(5).trim()));
        r.chance = ParticlesRuleParser.clamp01(Float.parseFloat(f.get(6).trim()));
        r.yOffset = Double.parseDouble(f.get(7).trim());
        if (hasYRand) {
            r.yRandom = Math.max(0.0, Double.parseDouble(f.get(8).trim()));
            r.rise = Double.parseDouble(f.get(9).trim());
            r.range = Math.max(1, Integer.parseInt(f.get(10).trim()));
            sky = f.get(11).trim().toLowerCase();
            r.canSeeSky = "true".equals(sky) ? ParticleRule.Tri.TRUE : ("false".equals(sky) ? ParticleRule.Tri.FALSE : ParticleRule.Tri.ANY);
            r.minY = Integer.parseInt(f.get(12).trim());
            r.maxY = Integer.parseInt(f.get(13).trim());
            we = ParticlesRuleParser.parseArray(f.get(14));
            if (we.isEmpty()) {
                r.weather = EnumSet.noneOf(ParticleRule.Weather.class);
            } else {
                r.weather = EnumSet.noneOf(ParticleRule.Weather.class);
                for (String w : we) {
                    switch (tt = w.trim().toUpperCase()) {
                        case "CLEAR": {
                            r.weather.add(ParticleRule.Weather.CLEAR);
                            break;
                        }
                        case "RAIN": {
                            r.weather.add(ParticleRule.Weather.RAIN);
                            break;
                        }
                        case "THUNDER": {
                            r.weather.add(ParticleRule.Weather.THUNDER);
                        }
                    }
                }
            }
            tag = f.get(15).trim();
            if (!((String)tag).isEmpty() && !ParticlesRuleParser.eq((String)tag, "all")) {
                r.biomeTag = BiomeDictionary.Type.getType((String)((String)tag).toUpperCase(), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            }
        } else {
            r.yRandom = 0.0;
            r.rise = Double.parseDouble(f.get(8).trim());
            r.range = Math.max(1, Integer.parseInt(f.get(9).trim()));
            sky = f.get(10).trim().toLowerCase();
            r.canSeeSky = "true".equals(sky) ? ParticleRule.Tri.TRUE : ("false".equals(sky) ? ParticleRule.Tri.FALSE : ParticleRule.Tri.ANY);
            r.minY = Integer.parseInt(f.get(11).trim());
            r.maxY = Integer.parseInt(f.get(12).trim());
            we = ParticlesRuleParser.parseArray(f.get(13));
            if (we.isEmpty()) {
                r.weather = EnumSet.noneOf(ParticleRule.Weather.class);
            } else {
                r.weather = EnumSet.noneOf(ParticleRule.Weather.class);
                for (String w : we) {
                    switch (tt = w.trim().toUpperCase()) {
                        case "CLEAR": {
                            r.weather.add(ParticleRule.Weather.CLEAR);
                            break;
                        }
                        case "RAIN": {
                            r.weather.add(ParticleRule.Weather.RAIN);
                            break;
                        }
                        case "THUNDER": {
                            r.weather.add(ParticleRule.Weather.THUNDER);
                        }
                    }
                }
            }
            tag = f.get(14).trim();
            if (!((String)tag).isEmpty() && !ParticlesRuleParser.eq((String)tag, "all")) {
                r.biomeTag = BiomeDictionary.Type.getType((String)((String)tag).toUpperCase(), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            }
        }
        return r;
    }

    private static EnumParticleTypes resolveParticle(String s) {
        String want = s.trim();
        for (EnumParticleTypes t : EnumParticleTypes.values()) {
            if (!t.name().equalsIgnoreCase(want) && !t.func_179346_b().equalsIgnoreCase(want)) continue;
            return t;
        }
        throw new IllegalArgumentException("Unknown particle: " + s);
    }

    private static boolean eq(String a, String b) {
        return a.equalsIgnoreCase(b);
    }

    private static float clamp01(float v) {
        return v < 0.0f ? 0.0f : Math.min(v, 1.0f);
    }

    private static List<String> splitTopCSV(String s) {
        ArrayList<String> out = new ArrayList<String>();
        StringBuilder cur = new StringBuilder();
        int depth = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '[') {
                ++depth;
            }
            if (c == ']' && depth > 0) {
                --depth;
            }
            if (c == ',' && depth == 0) {
                out.add(cur.toString());
                cur.setLength(0);
                continue;
            }
            cur.append(c);
        }
        out.add(cur.toString());
        return out;
    }

    private static List<String> parseArray(String tok) {
        String t = tok.trim();
        if (!t.startsWith("[") || !t.endsWith("]")) {
            return Collections.emptyList();
        }
        if ((t = t.substring(1, t.length() - 1).trim()).isEmpty()) {
            return Collections.emptyList();
        }
        String[] parts = t.split("\\|");
        ArrayList<String> list = new ArrayList<String>(parts.length);
        for (String p : parts) {
            String v = p.trim();
            if (v.isEmpty()) continue;
            list.add(v);
        }
        return list;
    }

    private static float[] parseColor(String arg) {
        String hex;
        if (arg.startsWith("#") && (hex = arg.substring(1)).length() == 6) {
            int v = Integer.parseInt(hex, 16);
            float r = (float)(v >> 16 & 0xFF) / 255.0f;
            float g = (float)(v >> 8 & 0xFF) / 255.0f;
            float b = (float)(v & 0xFF) / 255.0f;
            return new float[]{r, g, b};
        }
        String[] parts = arg.split(",");
        if (parts.length == 3) {
            boolean scale255;
            float r = Float.parseFloat(parts[0].trim());
            float g = Float.parseFloat(parts[1].trim());
            float b = Float.parseFloat(parts[2].trim());
            boolean bl = scale255 = r > 1.0f || g > 1.0f || b > 1.0f;
            if (scale255) {
                r /= 255.0f;
                g /= 255.0f;
                b /= 255.0f;
            }
            return new float[]{ParticlesRuleParser.clamp01(r), ParticlesRuleParser.clamp01(g), ParticlesRuleParser.clamp01(b)};
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }
}

