/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.client.particles;

import eaglemixins.client.particles.ParticleRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;

public final class ParticlesFactories {
    private static final Map<String, Set<Block>> BLOCK_SETS = new HashMap<String, Set<Block>>();
    private static final Map<String, List<ParticleRule.ParticleSpec>> PARTICLE_GROUPS = new HashMap<String, List<ParticleRule.ParticleSpec>>();

    private ParticlesFactories() {
    }

    private static String norm(String id) {
        return id == null ? "" : id.toLowerCase(Locale.ROOT).trim();
    }

    public static Set<Block> getBlockSet(String id) {
        return BLOCK_SETS.get(ParticlesFactories.norm(id));
    }

    public static List<ParticleRule.ParticleSpec> getParticleGroup(String id) {
        List<ParticleRule.ParticleSpec> g = PARTICLE_GROUPS.get(ParticlesFactories.norm(id));
        if (g == null) {
            return Collections.emptyList();
        }
        ArrayList<ParticleRule.ParticleSpec> copy = new ArrayList<ParticleRule.ParticleSpec>(g.size());
        for (ParticleRule.ParticleSpec s : g) {
            copy.add(ParticlesFactories.copyOf(s));
        }
        return copy;
    }

    private static ParticleRule.ParticleSpec copyOf(ParticleRule.ParticleSpec s) {
        ParticleRule.ParticleSpec c = new ParticleRule.ParticleSpec();
        c.type = s.type;
        c.hasColor = s.hasColor;
        c.r = s.r;
        c.g = s.g;
        c.b = s.b;
        c.noteHue = s.noteHue == null ? null : s.noteHue;
        return c;
    }
}

