/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.client.particles;

import eaglemixins.capability.ChunkRadiationSource;
import eaglemixins.client.particles.ParticleRule;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import nc.capability.radiation.source.IRadiationSource;
import nc.radiation.RadiationHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ParticlesClientRunner {
    private static final Random RNG = new Random();
    private static List<ParticleRule> RULES = Collections.emptyList();

    public static void install(List<ParticleRule> rules) {
        RULES = rules;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        if (mc.field_71462_r instanceof GuiIngameMenu) {
            return;
        }
        WorldClient w = mc.field_71441_e;
        EntityPlayerSP p = mc.field_71439_g;
        BlockPos pos = new BlockPos(p.field_70165_t, p.field_70163_u, p.field_70161_v);
        int yPlayer = pos.func_177956_o();
        int dim = w.field_73011_w.getDimension();
        boolean isRaining = w.func_72896_J();
        boolean isThundering = w.func_72911_I();
        boolean sky = w.func_175678_i(pos);
        Biome biome = w.func_180494_b(pos);
        Chunk chunk = w.func_175726_f(pos);
        IRadiationSource chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)chunk);
        block0: for (ParticleRule r : RULES) {
            boolean rad_chunk;
            r.tickGate = (r.tickGate + 1) % r.ticksBetweenRuns;
            if (r.tickGate != 0 || r.dimension != Integer.MIN_VALUE && r.dimension != dim || yPlayer < r.minY || yPlayer > r.maxY || r.canSeeSky == ParticleRule.Tri.TRUE && !sky || r.canSeeSky == ParticleRule.Tri.FALSE && sky || chunkSource instanceof ChunkRadiationSource && !(rad_chunk = ((ChunkRadiationSource)chunkSource).hasHighRadiation(yPlayer / 16))) continue;
            if (!r.weather.isEmpty()) {
                boolean ok;
                boolean bl = ok = r.weather.contains((Object)ParticleRule.Weather.THUNDER) && isThundering;
                if (r.weather.contains((Object)ParticleRule.Weather.RAIN) && isRaining && !isThundering) {
                    ok = true;
                }
                if (r.weather.contains((Object)ParticleRule.Weather.CLEAR) && !isRaining && !isThundering) {
                    ok = true;
                }
                if (!ok) continue;
            }
            if (r.biomeTag != null ? !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)r.biomeTag) : r.biomeSet != null && !r.biomeSet.contains(biome)) continue;
            int emitted = 0;
            if (!r.scanBlocks) {
                for (int tries = 0; emitted < r.maxPerRun && tries < r.maxPerRun * 2; ++tries) {
                    if (RNG.nextFloat() > r.chance) continue;
                    ParticlesClientRunner.spawnAroundPlayer((World)w, (EntityPlayer)p, r);
                    ++emitted;
                }
                continue;
            }
            int R = r.range;
            int side = 2 * R + 1;
            int vHalf = Math.min(2, Math.max(1, R / 10));
            int volume = side * side * (2 * vHalf + 1);
            if (volume <= 4096) {
                for (int dx = -R; dx <= R; ++dx) {
                    for (int dy = -vHalf; dy <= vHalf; ++dy) {
                        for (int dz = -R; dz <= R; ++dz) {
                            BlockPos bp;
                            if (emitted >= r.maxPerRun) continue block0;
                            if (RNG.nextFloat() > r.chance || !w.func_175668_a(bp = pos.func_177982_a(dx, dy, dz), false)) continue;
                            IBlockState s = w.func_180495_p(bp);
                            Block b = s.func_177230_c();
                            if (!r.blocksAll && ParticlesClientRunner.matchesBlockFilter(r, s, b)) continue;
                            double x = (double)bp.func_177958_n() + 0.5 + (RNG.nextDouble() - 0.5) * 0.6;
                            double y0 = (double)bp.func_177956_o() + r.yOffset + (r.yRandom > 0.0 ? RNG.nextDouble() * r.yRandom : 0.0);
                            double z = (double)bp.func_177952_p() + 0.5 + (RNG.nextDouble() - 0.5) * 0.6;
                            if (y0 < (double)r.minY || y0 > (double)r.maxY) continue;
                            ParticlesClientRunner.spawnOneAt((World)w, s, x, y0, z, r);
                            ++emitted;
                        }
                    }
                }
                continue;
            }
            int attempts = Math.min(volume, Math.max(64, r.maxPerRun * 20));
            for (int i = 0; i < attempts && emitted < r.maxPerRun; ++i) {
                if (RNG.nextFloat() > r.chance) continue;
                int dx = RNG.nextInt(side) - R;
                int dz = RNG.nextInt(side) - R;
                int dy = RNG.nextInt(2 * vHalf + 1) - vHalf;
                BlockPos bp = pos.func_177982_a(dx, dy, dz);
                if (!w.func_175668_a(bp, false)) continue;
                IBlockState s = w.func_180495_p(bp);
                Block b = s.func_177230_c();
                if (!r.blocksAll && ParticlesClientRunner.matchesBlockFilter(r, s, b)) continue;
                double x = (double)bp.func_177958_n() + 0.5 + (RNG.nextDouble() - 0.5) * 0.6;
                double y0 = (double)bp.func_177956_o() + r.yOffset + (r.yRandom > 0.0 ? RNG.nextDouble() * r.yRandom : 0.0);
                double z = (double)bp.func_177952_p() + 0.5 + (RNG.nextDouble() - 0.5) * 0.6;
                if (y0 < (double)r.minY || y0 > (double)r.maxY) continue;
                ParticlesClientRunner.spawnOneAt((World)w, s, x, y0, z, r);
                ++emitted;
            }
        }
    }

    private static boolean matchesBlockFilter(ParticleRule r, IBlockState s, Block b) {
        boolean ok = false;
        if (r.blocksSolidAny && (s.func_185913_b() || s.func_185914_p())) {
            ok = true;
        }
        if (!ok && r.blockSet != null && r.blockSet.contains(b)) {
            ok = true;
        }
        return !ok;
    }

    private static void spawnAroundPlayer(World w, EntityPlayer p, ParticleRule r) {
        double x = p.field_70165_t + (RNG.nextDouble() - 0.5) * ((double)r.range * 2.0);
        double y = p.field_70163_u + r.yOffset + (r.yRandom > 0.0 ? RNG.nextDouble() * r.yRandom : 0.0);
        double z = p.field_70161_v + (RNG.nextDouble() - 0.5) * ((double)r.range * 2.0);
        ParticlesClientRunner.spawnOneAt(w, null, x, y, z, r);
    }

    private static void spawnOneAt(World w, @Nullable IBlockState s, double x, double y, double z, ParticleRule r) {
        ParticleRule.ParticleSpec spec = r.particles[RNG.nextInt(r.particles.length)];
        EnumParticleTypes type = spec.type;
        if (type == null) {
            return;
        }
        switch (type) {
            case BLOCK_DUST: 
            case BLOCK_CRACK: {
                int id = s != null ? Block.func_176210_f((IBlockState)s) : Block.func_176210_f((IBlockState)w.func_180495_p(new BlockPos(x, y - Math.max(0.0, r.yOffset), z)));
                w.func_175688_a(type, x, y, z, 0.0, r.rise, 0.0, new int[]{id});
                break;
            }
            case REDSTONE: {
                float bb;
                float rr = spec.hasColor ? spec.r : 1.0f;
                float gg = spec.hasColor ? spec.g : 0.0f;
                float f = bb = spec.hasColor ? spec.b : 0.0f;
                if (rr <= 0.0f) {
                    rr = 0.001f;
                }
                w.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, (double)rr, (double)gg, (double)bb, new int[0]);
                break;
            }
            case SPELL_MOB: 
            case SPELL_MOB_AMBIENT: {
                float rr = spec.hasColor ? spec.r : 0.6f;
                float gg = spec.hasColor ? spec.g : 0.7f;
                float bb = spec.hasColor ? spec.b : 0.4f;
                w.func_175688_a(type, x, y, z, (double)rr, (double)gg, (double)bb, new int[0]);
                break;
            }
            case NOTE: {
                double hue = spec.noteHue != null ? spec.noteHue.doubleValue() : 0.5;
                w.func_175688_a(EnumParticleTypes.NOTE, x, y, z, hue, 0.0, 0.0, new int[0]);
                break;
            }
            default: {
                w.func_175688_a(type, x, y, z, (RNG.nextDouble() - 0.5) * 0.02, r.rise, (RNG.nextDouble() - 0.5) * 0.02, new int[0]);
            }
        }
    }
}

