/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TeleportOverlayHandler {
    private static TeleportOverlayHandler INSTANCE;
    private static long startTime;
    private static final int MAX_DURATION_TICKS = 500;
    private static final int MAX_DURATION_TICKS_DIM = 200;
    private static boolean active;
    private static boolean glitchActive;

    public static void trigger(boolean glitch) {
        if (INSTANCE != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCE);
        }
        INSTANCE = new TeleportOverlayHandler();
        startTime = System.currentTimeMillis();
        active = true;
        glitchActive = glitch;
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            player.func_82142_c(true);
            player.field_71075_bZ.field_75102_a = true;
            player.field_70145_X = true;
            player.func_71016_p();
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (!active || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (!glitchActive) {
            this.drawRect(width, height);
        }
        GlStateManager.func_179098_w();
        String msg = glitchActive ? I18n.func_135052_a((String)"overlay.teleport.glitch", (Object[])new Object[0]) : I18n.func_135052_a((String)"overlay.teleport.normal", (Object[])new Object[0]);
        mc.field_71466_p.func_175063_a(msg, (float)width / 2.0f - (float)mc.field_71466_p.func_78256_a(msg) / 2.0f, (float)height / 2.0f, 0xFFFFFF);
        GlStateManager.func_179126_j();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!active || event.phase != TickEvent.Phase.END) {
            return;
        }
        long elapsed = System.currentTimeMillis() - startTime;
        Minecraft mc = Minecraft.func_71410_x();
        if (elapsed > 10000L && mc.field_71439_g.field_71093_bK == 3) {
            this.cleanup();
        } else if (elapsed > 25000L) {
            this.cleanup();
        }
    }

    private void cleanup() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            mc.field_71439_g.func_82142_c(false);
            mc.field_71439_g.field_71075_bZ.field_75102_a = false;
            mc.field_71439_g.field_70145_X = false;
            mc.field_71439_g.func_71016_p();
        }
        glitchActive = false;
        active = false;
        MinecraftForge.EVENT_BUS.unregister((Object)INSTANCE);
    }

    private void drawRect(int right, int bottom) {
        int a = 255;
        int r = 0;
        int g = 0;
        int b = 0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(0.0, (double)bottom, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)right, 0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void stop() {
        EntityPlayerSP player;
        active = false;
        if (INSTANCE != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCE);
            INSTANCE = null;
        }
        if ((player = Minecraft.func_71410_x().field_71439_g) != null) {
            player.func_82142_c(false);
            player.field_71075_bZ.field_75102_a = false;
            player.field_70145_X = false;
            player.func_71016_p();
        }
    }

    static {
        startTime = -1L;
        active = false;
        glitchActive = false;
    }
}

