/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.capability;

import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import nc.capability.radiation.source.IRadiationSource;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class NbtStackRadiation
implements IRadiationSource,
ICapabilityProvider {
    public static final String NBT_KEY = "ncRadiation";
    public static final String NBT_MIN = "ncRadiationMin";
    public static final String NBT_MAX = "ncRadiationMax";
    public static final String NBT_FINAL = "ncRadiationFinalized";
    private final ItemStack stack;

    public NbtStackRadiation(ItemStack stack) {
        this.stack = stack;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        if (capability != IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return false;
        }
        NBTTagCompound tag = this.stack.func_77978_p();
        return tag != null && (tag.func_74764_b(NBT_KEY) || tag.func_74764_b(NBT_MIN) && tag.func_74764_b(NBT_MAX));
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        return (T)(this.hasCapability(capability, facing) ? this : null);
    }

    private NBTTagCompound getOrCreateTag() {
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            this.stack.func_77982_d(tag);
        }
        return tag;
    }

    private double read() {
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag == null) {
            return 0.0;
        }
        if (tag.func_74764_b(NBT_KEY)) {
            return tag.func_74769_h(NBT_KEY);
        }
        if (tag.func_74764_b(NBT_MIN) && tag.func_74764_b(NBT_MAX)) {
            double min = tag.func_74769_h(NBT_MIN);
            double max = tag.func_74769_h(NBT_MAX);
            if (max < min) {
                double t = min;
                min = max;
                max = t;
            }
            if (min < 0.0) {
                min = 0.0;
            }
            if (max < 0.0) {
                max = 0.0;
            }
            double value = max > min ? min + ThreadLocalRandom.current().nextDouble() * (max - min) : min;
            NBTTagCompound out = this.getOrCreateTag();
            out.func_74780_a(NBT_KEY, value);
            out.func_74757_a(NBT_FINAL, true);
            return value;
        }
        return 0.0;
    }

    private void write(double v) {
        NBTTagCompound tag = this.getOrCreateTag();
        if (v < 0.0) {
            v = 0.0;
        }
        tag.func_74780_a(NBT_KEY, v);
        tag.func_74757_a(NBT_FINAL, true);
    }

    public double getRadiationLevel() {
        return this.read();
    }

    public void setRadiationLevel(double level) {
        this.write(level);
    }

    public double getRadiationBuffer() {
        return 0.0;
    }

    public void setRadiationBuffer(double buffer) {
    }

    public double getScrubbingFraction() {
        return 0.0;
    }

    public void setScrubbingFraction(double fraction) {
    }

    public double getEffectiveScrubberCount() {
        return 0.0;
    }

    public void setEffectiveScrubberCount(double count) {
    }

    public NBTTagCompound writeNBT(IRadiationSource instance, EnumFacing side, NBTTagCompound nbt) {
        return null;
    }

    public void readNBT(IRadiationSource instance, EnumFacing side, NBTTagCompound nbt) {
    }
}

