/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.capability;

import eaglemixins.EagleMixins;
import java.nio.ByteBuffer;
import java.util.Arrays;
import nc.capability.radiation.source.IRadiationSource;
import nc.capability.radiation.source.RadiationSource;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChunkRadiationSource
extends RadiationSource {
    private final float[] subchunkRadiationLevel = new float[16];
    private final float[] subchunkRadiationBuffer = new float[16];
    private final float[] subchunkScrubbingFraction = new float[16];
    private final float[] subchunkEffectiveScrubberCount = new float[16];
    @SideOnly(value=Side.CLIENT)
    private short highRadiation;
    private static final int NOT_SET = -1;
    private int currentSubchunk = -1;
    private boolean isDuringReadWrite = false;

    public ChunkRadiationSource(double startRadiation) {
        super(startRadiation);
        Arrays.fill(this.subchunkRadiationLevel, (float)startRadiation);
        Arrays.fill(this.subchunkRadiationBuffer, 0.0f);
        Arrays.fill(this.subchunkScrubbingFraction, 0.0f);
        Arrays.fill(this.subchunkEffectiveScrubberCount, 0.0f);
    }

    public void resetSubchunk() {
        this.currentSubchunk = -1;
    }

    public void setSubchunk(int idx) {
        this.currentSubchunk = idx;
    }

    public void setSubchunk(BlockPos pos) {
        this.currentSubchunk = MathHelper.func_76125_a((int)(pos.func_177956_o() >> 4), (int)0, (int)15);
    }

    public boolean subchunkIsReset() {
        return this.currentSubchunk == -1;
    }

    public float getSubchunkRadiationLevel(int subChunk) {
        return this.subchunkRadiationLevel[subChunk];
    }

    public float getSubchunkRadiationBuffer(int subChunk) {
        return this.subchunkRadiationBuffer[subChunk];
    }

    public float getSubchunkScrubbingFraction(int subChunk) {
        return this.subchunkScrubbingFraction[subChunk];
    }

    public float getSubchunkEffectiveScrubberCount(int subChunk) {
        return this.subchunkEffectiveScrubberCount[subChunk];
    }

    public void setSubchunkRadiationLevel(int subChunk, float subchunkRadiation) {
        this.subchunkRadiationLevel[subChunk] = subchunkRadiation;
    }

    public void setSubchunkRadiationBuffer(int subChunk, float subchunkRadiationBuffer) {
        this.subchunkRadiationBuffer[subChunk] = subchunkRadiationBuffer;
    }

    public void setSubchunkScrubbingFraction(int subChunk, float subchunkScrubbingFraction) {
        this.subchunkScrubbingFraction[subChunk] = subchunkScrubbingFraction;
    }

    public void setSubchunkEffectiveScrubberCount(int subChunk, float subchunkScrubberCount) {
        this.subchunkEffectiveScrubberCount[subChunk] = subchunkScrubberCount;
    }

    @SideOnly(value=Side.CLIENT)
    public void setHighRadiation(short highRadiation) {
        this.highRadiation = highRadiation;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasHighRadiation(int subChunk) {
        return (this.highRadiation & 1 << subChunk) != 0;
    }

    public double getRadiationLevel() {
        if (this.currentSubchunk != -1) {
            return this.getSubchunkRadiationLevel(this.currentSubchunk);
        }
        if (!this.isDuringReadWrite) {
            EagleMixins.LOGGER.error("EagleMixins getting radiation level from chunk radiation source without setting subchunk index! Notfiy nischhelm!");
        }
        return (float)super.getRadiationLevel();
    }

    public double getRadiationBuffer() {
        if (this.currentSubchunk != -1) {
            return this.getSubchunkRadiationBuffer(this.currentSubchunk);
        }
        if (!this.isDuringReadWrite) {
            EagleMixins.LOGGER.error("EagleMixins getting radiation buffer from chunk radiation source without setting subchunk index! Notfiy nischhelm!");
        }
        return super.getRadiationBuffer();
    }

    public double getScrubbingFraction() {
        if (this.currentSubchunk != -1) {
            return this.getSubchunkScrubbingFraction(this.currentSubchunk);
        }
        if (!this.isDuringReadWrite) {
            EagleMixins.LOGGER.error("EagleMixins getting scrubbing fraction from chunk radiation source without setting subchunk index! Notfiy nischhelm!");
        }
        return super.getScrubbingFraction();
    }

    public double getEffectiveScrubberCount() {
        if (this.currentSubchunk != -1) {
            return this.getSubchunkEffectiveScrubberCount(this.currentSubchunk);
        }
        if (!this.isDuringReadWrite) {
            EagleMixins.LOGGER.error("EagleMixins getting scrubber coount from chunk radiation source without setting subchunk index! Notfiy nischhelm!");
        }
        return super.getEffectiveScrubberCount();
    }

    public void setRadiationLevel(double newRads) {
        if (!this.isDuringReadWrite) {
            if (this.currentSubchunk != -1) {
                this.setSubchunkRadiationLevel(this.currentSubchunk, (float)newRads);
                return;
            }
            Arrays.fill(this.subchunkRadiationLevel, (float)Math.max(newRads, 0.0));
            EagleMixins.LOGGER.warn("EagleMixins: Writing radiation to the whole chunk! This shouldn't happen as all methods should write to subchunk instead");
        }
        super.setRadiationLevel(newRads);
    }

    public void setRadiationBuffer(double newBuffer) {
        if (!this.isDuringReadWrite) {
            if (this.currentSubchunk != -1) {
                this.setSubchunkRadiationBuffer(this.currentSubchunk, (float)newBuffer);
                return;
            }
            Arrays.fill(this.subchunkRadiationBuffer, (float)Math.max(newBuffer, 0.0));
            EagleMixins.LOGGER.warn("EagleMixins: Writing radiation buffer to the whole chunk! This shouldn't happen as all methods should write to subchunk instead");
        }
        super.setRadiationLevel(newBuffer);
    }

    public void setScrubbingFraction(double newFraction) {
        if (!this.isDuringReadWrite) {
            if (this.currentSubchunk != -1) {
                this.setSubchunkScrubbingFraction(this.currentSubchunk, (float)newFraction);
                return;
            }
            Arrays.fill(this.subchunkScrubbingFraction, (float)MathHelper.func_151237_a((double)newFraction, (double)0.0, (double)1.0));
            EagleMixins.LOGGER.warn("EagleMixins: Writing scrubbing fraction to the whole chunk! This shouldn't happen as all methods should write to subchunk instead");
        }
        super.setScrubbingFraction(newFraction);
    }

    public void setEffectiveScrubberCount(double newScrubberCount) {
        if (!this.isDuringReadWrite) {
            if (this.currentSubchunk != -1) {
                this.setSubchunkEffectiveScrubberCount(this.currentSubchunk, (float)newScrubberCount);
                return;
            }
            Arrays.fill(this.subchunkEffectiveScrubberCount, (float)Math.max(0.0, newScrubberCount));
            EagleMixins.LOGGER.warn("EagleMixins: Writing scrubber count to the whole chunk! This shouldn't happen as all methods should write to subchunk instead");
        }
        super.setEffectiveScrubberCount(newScrubberCount);
    }

    public NBTTagCompound writeNBT(IRadiationSource instance, EnumFacing side, NBTTagCompound nbt) {
        nbt.func_74782_a("subchunkRadiationLevel", (NBTBase)ChunkRadiationSource.writeListToNBT(this.subchunkRadiationLevel));
        nbt.func_74782_a("subchunkRadiationBuffer", (NBTBase)ChunkRadiationSource.writeListToNBT(this.subchunkRadiationBuffer));
        nbt.func_74782_a("subchunkScrubbingFraction", (NBTBase)ChunkRadiationSource.writeListToNBT(this.subchunkScrubbingFraction));
        nbt.func_74782_a("subchunkEffectiveScrubberCount", (NBTBase)ChunkRadiationSource.writeListToNBT(this.subchunkEffectiveScrubberCount));
        this.isDuringReadWrite = true;
        super.writeNBT(instance, side, nbt);
        this.isDuringReadWrite = false;
        return nbt;
    }

    private static NBTTagByteArray writeListToNBT(float[] values) {
        byte[] data = new byte[values.length * 4];
        ByteBuffer buffer = ByteBuffer.wrap(data);
        for (float value : values) {
            buffer.putFloat(value);
        }
        return new NBTTagByteArray(data);
    }

    public void readNBT(IRadiationSource instance, EnumFacing side, NBTTagCompound nbt) {
        ChunkRadiationSource.readFromList(nbt, "subchunkRadiationLevel", this.subchunkRadiationLevel);
        ChunkRadiationSource.readFromList(nbt, "subchunkRadiationBuffer", this.subchunkRadiationBuffer);
        ChunkRadiationSource.readFromList(nbt, "subchunkScrubbingFraction", this.subchunkScrubbingFraction);
        ChunkRadiationSource.readFromList(nbt, "subchunkEffectiveScrubberCount", this.subchunkEffectiveScrubberCount);
        this.isDuringReadWrite = true;
        super.readNBT(instance, side, nbt);
        this.isDuringReadWrite = false;
    }

    private static void readFromList(NBTTagCompound nbt, String key, float[] setter) {
        if (!nbt.func_150297_b(key, 7)) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap(nbt.func_74770_j(key));
        for (int idx = 0; idx < 16; ++idx) {
            setter[idx] = buffer.getFloat();
        }
    }
}

