/*
 * Decompiled with CFR 0.152.
 */
package amphitheremod.client;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ColorizedEntityRender {
    private static final EnumDyeColor[] COLORS = new EnumDyeColor[]{EnumDyeColor.RED, EnumDyeColor.ORANGE, EnumDyeColor.YELLOW, EnumDyeColor.LIME, EnumDyeColor.LIGHT_BLUE, EnumDyeColor.MAGENTA, EnumDyeColor.PINK, EnumDyeColor.WHITE};
    private boolean isCustomColored = false;

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre<EntityLivingBase> event) {
        EntityLivingBase entity = event.getEntity();
        this.isCustomColored = false;
        String customName = TextFormatting.func_110646_a((String)entity.func_70005_c_());
        if (customName != null && customName.equals("rain")) {
            this.isCustomColored = true;
            this.applyBrightRainbowEffect(entity);
        }
    }

    private void applyBrightRainbowEffect(EntityLivingBase entity) {
        int ticks = entity.field_70173_aa;
        int entityId = entity.func_145782_y();
        int colorIndex = (ticks / 25 + entityId) % COLORS.length;
        int nextColorIndex = (colorIndex + 1) % COLORS.length;
        float interpolationFactor = (float)(ticks % 25) / 25.0f;
        float[] color1 = EntitySheep.func_175513_a((EnumDyeColor)COLORS[colorIndex]);
        float[] color2 = EntitySheep.func_175513_a((EnumDyeColor)COLORS[nextColorIndex]);
        this.applyInterpolatedColor(color1, color2, interpolationFactor);
    }

    private void applyInterpolatedColor(float[] rgb1, float[] rgb2, float factor) {
        float r = rgb1[0] * (1.0f - factor) + rgb2[0] * factor;
        float g = rgb1[1] * (1.0f - factor) + rgb2[1] * factor;
        float b = rgb1[2] * (1.0f - factor) + rgb2[2] * factor;
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post<EntityLivingBase> event) {
        if (this.isCustomColored) {
            GlStateManager.func_179121_F();
            this.isCustomColored = false;
        }
    }
}

