/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeEnd;
import net.minecraft.world.biome.BiomeHell;
import net.minecraftforge.common.BiomeDictionary;
import org.jwaresoftware.mcmods.lib.SharedGlue;

@ParametersAreNonnullByDefault
public final class Locations {
    public static final boolean isBiomeLike(Biome biome, Biome baseline, BiomeDictionary.Type ... plus) {
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        for (BiomeDictionary.Type wantedType : BiomeDictionary.getTypes((Biome)baseline)) {
            if (biomeTypes.contains(wantedType)) continue;
            return false;
        }
        if (plus != null) {
            for (BiomeDictionary.Type wantedType : plus) {
                if (biomeTypes.contains(wantedType)) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean isOverworld(@Nullable World world) {
        return world != null && world.field_73011_w.func_76569_d();
    }

    public static final boolean inTheOverworld(@Nullable World world, @Nonnull Entity wrt) {
        return Locations.isOverworld(world != null ? world : wrt.func_130014_f_());
    }

    public static final boolean inTheNether(@Nullable Biome biome, @Nonnull World world, @Nonnull BlockPos blockpos) {
        if (biome == null) {
            biome = world.func_180494_b(blockpos);
        }
        return biome instanceof BiomeHell || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
    }

    public static final boolean inTheNether(@Nullable World world, @Nonnull Entity wrt) {
        return Locations.inTheNether(null, world != null ? world : wrt.func_130014_f_(), wrt.func_180425_c());
    }

    public static final boolean inTheEnd(@Nullable Biome biome, @Nonnull World world, @Nonnull BlockPos blockpos) {
        if (biome == null) {
            biome = world.func_180494_b(blockpos);
        }
        return biome instanceof BiomeEnd || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END);
    }

    public static final boolean inTheEnd(@Nullable World world, @Nonnull EntityPlayer player) {
        return Locations.inTheEnd(null, world != null ? world : player.func_130014_f_(), player.func_180425_c());
    }

    public static final boolean isLikelyRealPosition(@Nullable IBlockAccess aworld, BlockPos blockpos) {
        return !BlockPos.field_177992_a.equals((Object)blockpos) && aworld instanceof World && ((World)aworld).func_175667_e(blockpos);
    }

    public static final boolean isGrowableYPos(IBlockAccess aworld, BlockPos blockpos) {
        return blockpos.func_177956_o() >= 15 && blockpos.func_177956_o() < SharedGlue.WORLD_HEIGHT();
    }

    private Locations() {
    }

    public static final void init() {
    }
}

