/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class Effects {
    private static final int[] RAINBOW = new int[]{0xFF00FF, 65280, 16766464, 0xFF7700, 16737969, 0xFF0000, 10367436, 4194284, 865008, 12979696, 15732160, 15740941, 15784461, 12185613, 4452365, 913520};

    public static final void play(int eventid, World world, BlockPos at) {
        world.func_175718_b(eventid, at, 0);
    }

    public static final void play(int eventid, World world, BlockPos at, int data) {
        world.func_175718_b(eventid, at, data);
    }

    public static final void playThisBlockBreak(World world, BlockPos at, Block block) {
        world.func_175718_b(SharedGlue.BLOCK_BREAK_SFX(), at, Block.func_149682_b((Block)block));
    }

    public static final void playHappySplashed(World world, BlockPos at) {
        Effects.play(SharedGlue.BONEMEAL_SPARKLE_SFX(), world, at);
    }

    public static final void playFertilizedSuccessfully(World world, BlockPos at) {
        Effects.play(SharedGlue.BONEMEAL_SPARKLE_SFX(), world, at);
    }

    public static final void playUsedHoeSuccessfully(World world, BlockPos at) {
        world.func_184133_a((EntityPlayer)null, at, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public static final void playPoisonSplashed(World world, BlockPos at) {
        world.func_175718_b(SharedGlue.POTION_SFX(), at, 32660);
    }

    public static final void playThrowingItemSound(World world, @Nonnull EntityPlayer player, SoundEvent sound, float volume, float pitch) {
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, sound, SoundCategory.PLAYERS, volume, pitch);
    }

    public static final void playUseItemFailedSound(World world, @Nonnull EntityPlayer player) {
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, SharedGlue.RANDOM_CLICK_SOUND(), SoundCategory.BLOCKS, 0.9f, player.func_70681_au().nextFloat() * 0.1f + 0.9f);
    }

    public static final void playUseItemFailedSoundFromServer(World world, @Nonnull EntityPlayer player) {
        world.func_175718_b(SharedGlue.DISPENSER_FAILED_SFX(), new BlockPos(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v), 0);
    }

    public static final void playTargetedItemSound(World world, @Nonnull EntityPlayer player) {
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, SharedGlue.RANDOM_FIZZ_SOUND(), SoundCategory.NEUTRAL, 0.9f, player.func_70681_au().nextFloat() * 0.1f + 0.9f);
    }

    public static final void playDispenserSound(World world, BlockPos at, boolean successful) {
        world.func_175718_b(successful ? SharedGlue.DISPENSER_SUCCEEDED_SFX() : SharedGlue.DISPENSER_FAILED_SFX(), at, 0);
    }

    public static final void playExtinguishingHissss(World world, BlockPos at, float volume) {
        world.func_184148_a(null, (double)at.func_177958_n() + 0.5, (double)at.func_177956_o() + 0.5, (double)at.func_177952_p() + 0.5, SharedGlue.RANDOM_FIZZ_SOUND(), SoundCategory.NEUTRAL, volume, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public static final void playExtinguishingHissssEvent(World world, BlockPos at) {
        Effects.play(1009, world, at);
    }

    public static final void playExtinguishedBurning(World world, @Nonnull EntityPlayer player) {
        world.func_184148_a(null, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, SharedGlue.RANDOM_FIZZ_SOUND(), SoundCategory.PLAYERS, 1.0f, 1.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
    }

    public static final void playVeryHeavyThingLanded(World world, BlockPos at) {
        Effects.play(SharedGlue.ANVIL_LANDED_SFX(), world, at);
    }

    public static final void playSound(World world, @Nonnull EntityPlayer player, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, sound, category == null ? SoundCategory.NEUTRAL : category, volume, pitch);
    }

    public static final void playSoundFor(World world, @Nonnull EntityPlayer player, SoundEvent sound, float volume, float pitch) {
        world.func_184148_a(player, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, sound, SoundCategory.PLAYERS, volume, pitch);
    }

    public static final void playSound(World world, @Nonnull EntityPlayer player, SoundEvent sound, float volume, float pitch) {
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, sound, SoundCategory.PLAYERS, volume, pitch);
    }

    public static final void playHostileSound(World world, @Nonnull EntityPlayer player, SoundEvent sound, float volume) {
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, sound, SoundCategory.HOSTILE, volume, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public static final void playBlockSound(World world, @Nonnull EntityPlayer player, SoundEvent sound, float volume, float pitch) {
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, sound, SoundCategory.BLOCKS, volume, pitch);
    }

    public static final void playProjectileHitBlock(World world, @Nonnull BlockPos pos, SoundEvent sound) {
        if (sound == null) {
            sound = SoundEvents.field_187843_fX;
        }
        world.func_184133_a(null, pos, sound, SoundCategory.AMBIENT, 0.5f, 0.65f);
    }

    public static final void playMagicalInteraction(World world, @Nonnull EntityPlayer player, float volume, float pitch) {
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, SharedGlue.SPARKLE_SOUND(), SoundCategory.RECORDS, volume, pitch);
    }

    public static final void playFoodConsumed(World world, EntityPlayer player, float volume, float pitch) {
        Effects.playSound(world, player, SharedGlue.PLAYER_BURP_SOUND(), volume, pitch);
    }

    public static final void playFoodConsumed(World world, EntityPlayer player) {
        Effects.playSound(world, player, SharedGlue.PLAYER_BURP_SOUND(), 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public static final void playFeedMeSeymourChomp(World world, EntityPlayer player, BlockPos plant) {
        world.func_184148_a(null, (double)plant.func_177958_n() + 0.5, (double)plant.func_177956_o() + 0.5, (double)plant.func_177952_p() + 0.5, SoundEvents.field_187537_bA, SoundCategory.NEUTRAL, 0.9f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public static final void playHealthConsumed(World world, @Nonnull EntityPlayer player) {
        Effects.playSound(world, player, SoundEvents.field_189109_ed, 0.15f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f));
    }

    public static final void playXpEaten(World world, @Nonnull EntityPlayer player) {
        Effects.playSound(world, player, SharedGlue.PLAYER_BURP_SOUND(), 0.15f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f));
    }

    public static final void playXpLevelUp(World world, @Nonnull EntityPlayer player, int loudThreshold) {
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, SoundEvents.field_187802_ec, player.func_184176_by(), player.field_71068_ca > loudThreshold ? 0.75f : 0.5f, 1.0f);
    }

    public static final void playXpSiphonedFrom(World world, EntityPlayer player, boolean burp) {
        Effects.playSound(world, player, burp ? SharedGlue.PLAYER_BURP_SOUND() : SoundEvents.field_187664_bz, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public static final void playXpOffLoaded(World world, EntityPlayer player, float volume) {
        Effects.playSound(world, player, SharedGlue.XP_INTERACT_SOUND(), volume, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f));
    }

    public static final void playBucketOfLiquidScoopedUp(World world, EntityPlayer player, @Nullable Material liquid) {
        Effects.playSound(world, player, SharedGlue.LIQUID_SCOOPED_SOUND(liquid == null ? SharedGlue.Material_water : liquid), 1.0f, 1.0f);
    }

    public static final void playBucketOfLiquidPlacedDown(World world, EntityPlayer player, @Nullable Material liquid) {
        Effects.playSound(world, player, SharedGlue.LIQUID_PUTDOWN_SOUND(liquid == null ? SharedGlue.Material_water : liquid), 1.0f, 1.0f);
    }

    public static final void playBottleOfWaterScoopedUp(World world, EntityPlayer player) {
        world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public static final void playExplosionFizzled(World world, BlockPos at, float volume) {
        world.func_184148_a(null, (double)at.func_177958_n() + 0.5, (double)at.func_177956_o() + 0.5, (double)at.func_177952_p() + 0.5, SoundEvents.field_187637_bq, SoundCategory.BLOCKS, volume, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    public static final void playPotionLevelUp(World world, @Nonnull EntityPlayer player) {
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, SoundEvents.field_187802_ec, player.func_184176_by(), 1.0f, 1.0f);
    }

    public static final void playBlockBOOM(World world, @Nullable EntityPlayer player, BlockPos at) {
        world.func_184148_a(player, (double)at.func_177958_n(), (double)at.func_177956_o(), (double)at.func_177952_p(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public static final void playGodsBOOM(World world, @Nullable EntityPlayer player, BlockPos at, boolean fromOnHigh) {
        double x = (double)at.func_177958_n() + 0.5;
        double y = (double)at.func_177956_o() + 0.5;
        double z = (double)at.func_177952_p() + 0.5;
        if (fromOnHigh) {
            world.func_184148_a((EntityPlayer)null, x, y, z, SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0f, 0.8f + world.field_73012_v.nextFloat() * 0.2f);
        }
        world.func_184148_a((EntityPlayer)null, x, y, z, SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + world.field_73012_v.nextFloat() * 0.2f);
    }

    public static final void playCreepyGroan(World world, EntityPlayer player, boolean wary) {
        Effects.playSound(world, player, wary ? SoundEvents.field_190031_ew : SoundEvents.field_190026_er, null, MathHelper.func_151240_a((Random)world.field_73012_v, (float)0.3f, (float)0.6f), world.field_73012_v.nextFloat() * 0.1f + 0.8f);
    }

    public static final void playAmbientGroan(World world, BlockPos at, boolean wary) {
        double x = (double)at.func_177958_n() + 0.5;
        double y = (double)at.func_177956_o() + 0.5;
        double z = (double)at.func_177952_p() + 0.5;
        world.func_184148_a((EntityPlayer)null, x, y, z, wary ? SoundEvents.field_190031_ew : SoundEvents.field_190026_er, SoundCategory.NEUTRAL, MathHelper.func_151240_a((Random)world.field_73012_v, (float)0.3f, (float)0.6f), world.field_73012_v.nextFloat() * 0.1f + 0.8f);
    }

    public static final void playLockableUnlocked(World world, BlockPos at, boolean metal) {
        Effects.play(metal ? 1037 : 1007, world, at);
    }

    public static final void playLockableLocked(World world, BlockPos at, boolean metal) {
        Effects.play(metal ? 1036 : 1013, world, at);
    }

    public static final void playItemPickedUp(World world, EntityPlayer player, float volume) {
        Effects.playSound(world, player, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, volume < 0.0f ? 0.2f : volume, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
    }

    public static final void spawnWarningParticle(World world, BlockPos at, Random rand, @Nonnull EnumParticleTypes particleType) {
        if (rand.nextInt(20) == 0) {
            world.func_175688_a(particleType, (double)((float)at.func_177958_n() + rand.nextFloat()), (double)((float)at.func_177956_o() + 1.0f), (double)((float)at.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, ArrayUtils.EMPTY_INT_ARRAY);
        }
    }

    public static final void spawnSmallArrayOfParticles(@Nonnull World world, BlockPos at, Random rand, @Nonnull EnumParticleTypes particleType) {
        if (rand == null) {
            rand = world.field_73012_v;
        }
        int n = 0;
        do {
            world.func_175688_a(particleType, (double)((float)at.func_177958_n() + rand.nextFloat()), (double)((float)at.func_177956_o() + rand.nextFloat()), (double)((float)at.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, ArrayUtils.EMPTY_INT_ARRAY);
        } while (++n < 3);
    }

    public static final void spawnPinklyParticles(World world, BlockPos at, @Nullable EnumParticleTypes particleType, Random rand) {
        if (rand == null) {
            rand = world.field_73012_v;
        }
        if (rand.nextInt(20) == 0) {
            if (particleType == null) {
                particleType = EnumParticleTypes.VILLAGER_HAPPY;
            }
            Effects.spawnSmallArrayOfParticles(world, at, rand, particleType);
        }
    }

    public static final void spawnLoveyDoveyParticles(World world, BlockPos at) {
        Effects.spawnSmallArrayOfParticles(world, at, world.field_73012_v, EnumParticleTypes.HEART);
    }

    public static final void spawnPiOoedParticles(World world, BlockPos at) {
        Effects.spawnSmallArrayOfParticles(world, at, world.field_73012_v, EnumParticleTypes.VILLAGER_ANGRY);
    }

    public static final void spawnPinklyParticles(World world, BlockPos at) {
        Effects.play(SharedGlue.BONEMEAL_SPARKLE_SFX(), world, at);
    }

    public static final void spawnPinklyExplosion(World world, BlockPos at) {
        Effects.play(SharedGlue.BONEMEAL_SPARKLE_SFX(), world, at);
        Effects.play(2003, world, at);
    }

    public static final void spawnTpParticles(World world, BlockPos at, Random rand) {
        if (rand == null) {
            rand = world.field_73012_v;
        }
        for (int i = 0; i < 32; ++i) {
            world.func_175688_a(EnumParticleTypes.PORTAL, (double)at.func_177958_n(), (double)at.func_177956_o() + rand.nextDouble() * 2.0, (double)at.func_177952_p(), rand.nextGaussian(), 0.0, rand.nextGaussian(), ArrayUtils.EMPTY_INT_ARRAY);
        }
    }

    public static final void playTpArrival(World world, BlockPos at) {
        Effects.play(SharedGlue.PORTAL_TRAVEL_SFX(), world, at);
    }

    public static final void spawnParticles(@Nonnull World world, double atX, double atY, double atZ, @Nullable Random rand, @Nullable EnumParticleTypes particleType, int count, boolean still) {
        if (particleType == null) {
            particleType = EnumParticleTypes.VILLAGER_HAPPY;
        }
        if (rand == null) {
            rand = world.field_73012_v;
        }
        if (count <= 0) {
            count = 20;
        }
        for (int i = 0; i < count; ++i) {
            double speedx = still ? 0.0 : rand.nextGaussian() * 0.02;
            double speedy = still ? 0.0 : rand.nextGaussian() * 0.02;
            double speedz = still ? 0.0 : rand.nextGaussian() * 0.02;
            world.func_175688_a(particleType, atX + (double)(rand.nextFloat() * 2.0f) - 1.0 - speedx * 10.0, atY + (double)(rand.nextFloat() * 2.0f) - speedy * 10.0, atZ + (double)(rand.nextFloat() * 2.0f) - 1.0 - speedz * 10.0, speedx, speedy, speedz, ArrayUtils.EMPTY_INT_ARRAY);
        }
    }

    public static final void spawnVisualBOOM(@Nonnull World world, double atX, double atY, double atZ, @Nullable Random rand, @Nullable EnumParticleTypes particleType) {
        Effects.spawnParticles(world, atX, atY, atZ, rand, particleType, -1, false);
    }

    public static final void spawnVisualWhack(@Nonnull World world, @Nonnull Entity at, @Nullable Random rand, @Nullable EnumParticleTypes particleType) {
        Effects.spawnParticles(world, at.field_70165_t, at.field_70163_u + 0.5, at.field_70161_v, rand, particleType, -1, false);
    }

    public static final void spawnSmallFlamesAround(@Nonnull World world, @Nonnull Entity at, boolean flat) {
        double y = at.field_70163_u + 0.5;
        if (flat) {
            world.func_175688_a(EnumParticleTypes.FLAME, at.field_70165_t + 1.0, y, at.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, at.field_70165_t - 1.0, y, at.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, at.field_70165_t, y, at.field_70161_v + 1.0, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, at.field_70165_t, y, at.field_70161_v - 1.0, 0.0, 0.0, 0.0, new int[0]);
        } else {
            Effects.spawnParticles(world, at.field_70165_t + 1.0, y, at.field_70161_v, null, EnumParticleTypes.FLAME, 1, true);
            Effects.spawnParticles(world, at.field_70165_t - 1.0, y, at.field_70161_v, null, EnumParticleTypes.FLAME, 1, true);
            Effects.spawnParticles(world, at.field_70165_t, y, at.field_70161_v + 1.0, null, EnumParticleTypes.FLAME, 1, true);
            Effects.spawnParticles(world, at.field_70165_t, y, at.field_70161_v - 1.0, null, EnumParticleTypes.FLAME, 1, true);
        }
    }

    public static final void spawnRainbowParticlesAround(@Nonnull World world, BlockPos pos, @Nullable Random rand) {
        if (rand == null) {
            rand = world.field_73012_v;
        }
        if (rand.nextInt(20) == 0) {
            int n = 0;
            do {
                double yd;
                double xd;
                EnumFacing face;
                BlockPos neighborPos;
                IBlockState neighborState;
                if ((neighborState = world.func_180495_p(neighborPos = pos.func_177972_a(face = EnumFacing.func_176741_a((Random)world.field_73012_v)))).func_185917_h()) continue;
                double d = face.func_82601_c() == 0 ? (double)rand.nextFloat() : (xd = face.func_82601_c() < 0 ? -0.05 : 1.05);
                double d2 = face.func_96559_d() == 0 ? (double)rand.nextFloat() : (yd = face.func_96559_d() < 0 ? -0.05 : 1.05);
                double zd = face.func_82599_e() == 0 ? (double)rand.nextFloat() : (face.func_82599_e() < 0 ? -0.05 : 1.05);
                double x = (double)pos.func_177958_n() + xd;
                double y = (double)pos.func_177956_o() + yd;
                double z = (double)pos.func_177952_p() + zd;
                int rgb = RAINBOW[rand.nextInt(RAINBOW.length)];
                world.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, (double)(rgb >> 16 & 0xFF) / 255.0, (double)(rgb >> 8 & 0xFF) / 255.0, (double)(rgb & 0xFF) / 255.0, new int[0]);
            } while (++n < 3);
        }
    }

    public static boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !oldStack.func_77969_a(newStack) || oldStack.func_77942_o() && newStack.func_77942_o() && !oldStack.func_77978_p().equals((Object)newStack.func_77978_p());
    }

    private Effects() {
    }
}

