/*
 * Decompiled with CFR 0.152.
 */
package azmalent.potiondescriptions;

import azmalent.potiondescriptions.ModConfig;
import azmalent.potiondescriptions.client.TooltipHandler;
import java.util.Collection;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="potiondescriptions", name="Potion Descriptions", version="1.2.4", dependencies="after:actuallyadditions;after:botania;after:rustic;after:xreliquary", clientSideOnly=true)
public class PotionDescriptions {
    public static final String MODID = "potiondescriptions";
    public static final String NAME = "Potion Descriptions";
    public static final String VERSION = "1.2.4";
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)new TooltipHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (ModConfig.loggingEnabled) {
            IForgeRegistry potionRegistry = GameRegistry.findRegistry(Potion.class);
            Collection potions = potionRegistry.getValuesCollection();
            for (Potion potion : potions) {
                String translationKey = potion.func_76393_a() + ".desc";
                if (I18n.func_188566_a((String)translationKey)) continue;
                logger.warn(String.format("Missing description for effect '%s' (expected translation key: %s)", I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]), translationKey));
            }
        }
    }
}

