/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BlockBOPMushroom;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenConiferTopper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesDarkOakConifer
extends Species {
    public SpeciesDarkOakConifer(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesbop", "darkoakconifer"), treeFamily, ModContent.leaves.get("darkoakconifer"));
        this.setBasicGrowingParameters(0.3f, 16.0f, 3, 3, 0.9f);
        this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit((String)"conifer"));
        this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
        this.envFactor(BiomeDictionary.Type.SWAMP, 1.05f);
        this.setupStandardSeedDropping();
        this.setRequiresTileEntity(true);
        this.leavesProperties.setTree(treeFamily);
        this.addGenFeature((IGenFeature)new FeatureGenConiferTopper(this.getLeavesProperties()));
    }

    public boolean isBiomePerfect(Biome biome) {
        return biome == BOPBiomes.fen.orNull();
    }

    public ItemStack getSeedStack(int qty) {
        return this.getFamily().getCommonSpecies().getSeedStack(qty);
    }

    public Seed getSeed() {
        return this.getFamily().getCommonSpecies().getSeed();
    }

    public int maxBranchRadius() {
        return 8;
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
            if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                world.func_175656_a(pos, random.nextInt(3) == 0 ? BOPBlocks.mushroom.func_176223_P().func_177226_a((IProperty)BlockBOPMushroom.VARIANT, (Comparable)BlockBOPMushroom.MushroomType.TOADSTOOL) : BOPBlocks.mushroom.func_176223_P().func_177226_a((IProperty)BlockBOPMushroom.VARIANT, (Comparable)BlockBOPMushroom.MushroomType.FLAT_MUSHROOM));
            }
            return true;
        }
        return false;
    }
}

