/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.world;

import com.dhanantry.scapeandrunparasites.init.SRPBiomes;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import com.dhanantry.scapeandrunparasites.init.SRPFluids;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventWorld;
import com.dhanantry.scapeandrunparasites.world.biome.BiomeParasite;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SRPChunkGenerator
implements IChunkGenerator {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState PARABLOCK = SRPBlocks.ParasiteStain.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState DEADBLOOD = SRPFluids.DEADBLOOD_FLUID.getBlock().func_176223_P();
    protected static final IBlockState PARABLOCK2 = SRPBlocks.ParasiteRubble.func_176223_P();
    private final World world;
    private final Random rand;
    double[] pnr;
    double[] ar;
    double[] br;
    double[] dr;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    private NoiseGeneratorOctaves lperlinNoise1;
    private NoiseGeneratorOctaves lperlinNoise2;
    private NoiseGeneratorOctaves perlinNoise1;
    private double[] buffer;
    private double[] slowsandNoise = new double[256];
    private double[] depthBuffer = new double[256];
    private NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private NoiseGeneratorOctaves parablockExculsivityNoiseGen;
    private MapGenBase genCaves = new MapGenSourceCaves();

    public SRPChunkGenerator(World worldIn, long seed) {
        this.world = worldIn;
        this.rand = new Random(seed);
        this.lperlinNoise1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.lperlinNoise2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 8);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.parablockExculsivityNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        worldIn.func_181544_b(63);
        InitNoiseGensEvent.ContextHell ctx = new InitNoiseGensEvent.ContextHell(this.lperlinNoise1, this.lperlinNoise2, this.perlinNoise1, this.slowsandGravelNoiseGen, this.parablockExculsivityNoiseGen, this.scaleNoise, this.depthNoise);
        ctx = (InitNoiseGensEvent.ContextHell)TerrainGen.getModdedNoiseGenerators((World)worldIn, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.lperlinNoise1 = ctx.getLPerlin1();
        this.lperlinNoise2 = ctx.getLPerlin2();
        this.perlinNoise1 = ctx.getPerlin();
        this.slowsandGravelNoiseGen = ctx.getPerlin2();
        this.parablockExculsivityNoiseGen = ctx.getPerlin3();
        this.scaleNoise = ctx.getScale();
        this.depthNoise = ctx.getDepth();
        this.genCaves = TerrainGen.getModdedMapGen((MapGenBase)this.genCaves, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
    }

    @Nonnull
    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.prepareHeights(x, z, chunkprimer);
        this.buildSurfaces(x, z, chunkprimer);
        this.genCaves.func_186125_a(this.world, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        Arrays.fill(chunk.func_76605_m(), (byte)Biome.func_185362_a((Biome)SRPBiomes.biomeInfested));
        chunk.func_76613_n();
        return chunk;
    }

    public void prepareHeights(int cx, int cz, ChunkPrimer primer) {
        int deadBloodLevel = this.world.func_181545_F() / 2 + 1;
        int always16 = 32;
        int always17 = always16 + 1;
        this.buffer = this.getHeights(this.buffer, cx * 4, 0, cz * 4, 5, always17, 5);
        for (int bigx = 0; bigx < 4; ++bigx) {
            for (int bigz = 0; bigz < 4; ++bigz) {
                for (int bigy = 0; bigy < always16; ++bigy) {
                    double x0y0z0 = this.buffer[(bigx * 5 + bigz) * always17 + bigy];
                    double x0y0z1 = this.buffer[(bigx * 5 + bigz + 1) * always17 + bigy];
                    double x1y0z0 = this.buffer[((bigx + 1) * 5 + bigz) * always17 + bigy];
                    double x1y0z1 = this.buffer[((bigx + 1) * 5 + bigz + 1) * always17 + bigy];
                    double dVdy_at_x0z0 = (this.buffer[(bigx * 5 + bigz) * always17 + bigy + 1] - x0y0z0) * 0.125;
                    double dVdy_at_x0z1 = (this.buffer[(bigx * 5 + bigz + 1) * always17 + bigy + 1] - x0y0z1) * 0.125;
                    double dVdy_at_x1z0 = (this.buffer[((bigx + 1) * 5 + bigz) * always17 + bigy + 1] - x1y0z0) * 0.125;
                    double dVdy_at_x1z1 = (this.buffer[((bigx + 1) * 5 + bigz + 1) * always17 + bigy + 1] - x1y0z1) * 0.125;
                    for (int smally = 0; smally < 8; ++smally) {
                        double d10 = x0y0z0;
                        double d11 = x0y0z1;
                        double dVdx_at_z0 = (x1y0z0 - x0y0z0) * 0.25;
                        double dVdx_at_z1 = (x1y0z1 - x0y0z1) * 0.25;
                        for (int smallx = 0; smallx < 4; ++smallx) {
                            double d15 = d10;
                            double dVdz_at_x0 = (d11 - d10) * 0.25;
                            for (int smallz = 0; smallz < 4; ++smallz) {
                                IBlockState iblockstate = null;
                                if (bigy * 8 + smally < deadBloodLevel) {
                                    iblockstate = DEADBLOOD;
                                }
                                if (d15 > 0.0) {
                                    iblockstate = PARABLOCK;
                                }
                                int x = smallx + bigx * 4;
                                int y = smally + bigy * 8;
                                int z = smallz + bigz * 4;
                                primer.func_177855_a(x, y, z, iblockstate);
                                d15 += dVdz_at_x0;
                            }
                            d10 += dVdx_at_z0;
                            d11 += dVdx_at_z1;
                        }
                        x0y0z0 += dVdy_at_x0z0;
                        x0y0z1 += dVdy_at_x0z1;
                        x1y0z0 += dVdy_at_x1z0;
                        x1y0z1 += dVdy_at_x1z1;
                    }
                }
            }
        }
    }

    private double[] getHeights(double[] bufferIn, int cx_4, int cy_always0, int cz_4, int sizex_always5, int sizey_always17, int sizez_always5) {
        if (bufferIn == null) {
            bufferIn = new double[sizex_always5 * sizey_always17 * sizez_always5];
        }
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, bufferIn, cx_4, cy_always0, cz_4, sizex_always5, sizey_always17, sizez_always5);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        this.dr = this.depthNoise.func_76304_a(this.dr, cx_4, cy_always0, cz_4, sizex_always5, 1, sizez_always5, 100.0, 0.0, 100.0);
        this.pnr = this.perlinNoise1.func_76304_a(this.pnr, cx_4, cy_always0, cz_4, sizex_always5, sizey_always17, sizez_always5, 8.555150000000001, 34.2206, 8.555150000000001);
        this.ar = this.lperlinNoise1.func_76304_a(this.ar, cx_4, cy_always0, cz_4, sizex_always5, sizey_always17, sizez_always5, 684.412, 2053.236, 684.412);
        this.br = this.lperlinNoise2.func_76304_a(this.br, cx_4, cy_always0, cz_4, sizex_always5, sizey_always17, sizez_always5, 684.412, 2053.236, 684.412);
        int unrolled_idx = 0;
        double[] seventeen_pre_values = new double[sizey_always17];
        for (int bigy = 0; bigy < sizey_always17; ++bigy) {
            seventeen_pre_values[bigy] = Math.cos((double)bigy * Math.PI * 6.0 / (double)sizey_always17) * 2.0;
            double d2 = bigy;
            if (bigy > sizey_always17 / 2) {
                d2 = sizey_always17 - 1 - bigy;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = bigy;
            seventeen_pre_values[n] = seventeen_pre_values[n] - d2 * d2 * d2 * 10.0;
        }
        for (int bigx = 0; bigx < sizex_always5; ++bigx) {
            for (int bigz = 0; bigz < sizez_always5; ++bigz) {
                for (int bigy = 0; bigy < sizey_always17; ++bigy) {
                    double some_pre_value = seventeen_pre_values[bigy];
                    double ar_val = this.ar[unrolled_idx] / 512.0;
                    double br_val = this.br[unrolled_idx] / 512.0;
                    double pnr_val = (this.pnr[unrolled_idx] / 10.0 + 1.0) / 2.0;
                    double calced_val = pnr_val < 0.0 ? ar_val : (pnr_val > 1.0 ? br_val : ar_val + (br_val - ar_val) * pnr_val);
                    calced_val -= some_pre_value;
                    if (bigy > sizey_always17 - 4) {
                        double d9 = (float)(bigy - (sizey_always17 - 4)) / 3.0f;
                        calced_val = calced_val * (1.0 - d9) - 10.0 * d9;
                    }
                    bufferIn[unrolled_idx] = calced_val;
                    ++unrolled_idx;
                }
            }
        }
        return bufferIn;
    }

    public void buildSurfaces(int cx, int cz, ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)cx, (int)cz, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        int yAboveSeaLevel = this.world.func_181545_F() + 1;
        this.slowsandNoise = this.slowsandGravelNoiseGen.func_76304_a(this.slowsandNoise, cx * 16, cz * 16, 0, 16, 16, 1, 0.03125, 0.03125, 1.0);
        this.depthBuffer = this.parablockExculsivityNoiseGen.func_76304_a(this.depthBuffer, cx * 16, cz * 16, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                int yMax;
                boolean shouldPlaceOtherBlock = this.slowsandNoise[z + x * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                int l = (int)(this.depthBuffer[z + x * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int i1 = -1;
                IBlockState iblockstate = PARABLOCK;
                IBlockState iblockstate1 = PARABLOCK;
                for (int y = yMax = 255; y >= 0; --y) {
                    if (y >= yMax - this.rand.nextInt(5) || y <= this.rand.nextInt(5)) {
                        primer.func_177855_a(x, y, z, BEDROCK);
                        continue;
                    }
                    IBlockState primerState = primer.func_177856_a(x, y, z);
                    primer.func_177855_a(x, y, z, primerState);
                    if (primerState.func_185904_a() != Material.field_151579_a) {
                        if (primerState.func_177230_c() != SRPBlocks.ParasiteStain) continue;
                        if (i1 == -1) {
                            if (l <= 0) {
                                iblockstate = AIR;
                                iblockstate1 = PARABLOCK;
                            } else if (y >= yAboveSeaLevel - 4 && y <= yAboveSeaLevel + 1) {
                                iblockstate = PARABLOCK;
                                iblockstate1 = PARABLOCK;
                                if (shouldPlaceOtherBlock) {
                                    iblockstate = PARABLOCK2;
                                    iblockstate1 = PARABLOCK2;
                                }
                            }
                            if (y < yAboveSeaLevel && iblockstate.func_185904_a() == Material.field_151579_a) {
                                iblockstate = DEADBLOOD;
                            }
                            i1 = l;
                            if (y >= yAboveSeaLevel - 1) {
                                primer.func_177855_a(x, y, z, iblockstate);
                                continue;
                            }
                            primer.func_177855_a(x, y, z, iblockstate1);
                            continue;
                        }
                        if (i1 <= 0) continue;
                        --i1;
                        primer.func_177855_a(x, y, z, iblockstate1);
                        continue;
                    }
                    i1 = -1;
                }
            }
        }
    }

    public void func_185931_b(int cx, int cz) {
        BlockFalling.field_149832_M = true;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)cx, (int)cz, (boolean)false);
        BlockPos startPos = new BlockPos(cx * 16, 0, cz * 16);
        SRPBiomes.biomeInfested.func_180624_a(this.world, this.rand, startPos);
        ParasiteEventWorld.spawnGenFeatureParasite((World)this.world, (BlockPos)startPos.func_177982_a(8, 60, 8), (Random)this.rand);
        ParasiteEventWorld.spawnGenRoofParasite((World)this.world, (BlockPos)startPos.func_177982_a(8, 60, 8), (Random)this.rand);
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)cx, (int)cz, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    @Nonnull
    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return SRPBiomes.biomeInfested.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    private static class MapGenSourceCaves
    extends MapGenCaves {
        protected static final IBlockState BLK_DEADBLOOD = SRPFluids.DEADBLOOD_FLUID.getBlock().func_176223_P();

        private MapGenSourceCaves() {
        }

        protected void digBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop, IBlockState state, IBlockState up) {
            BiomeParasite biome = SRPBiomes.biomeInfested;
            IBlockState top = biome.field_76752_A;
            IBlockState filler = biome.field_76753_B;
            if (this.func_175793_a(state, up) || state.func_177230_c() == top.func_177230_c() || state.func_177230_c() == filler.func_177230_c()) {
                if (y - 1 < 10) {
                    data.func_177855_a(x, y, z, BLK_DEADBLOOD);
                } else {
                    data.func_177855_a(x, y, z, field_186127_b);
                    if (foundTop && data.func_177856_a(x, y - 1, z).func_177230_c() == filler.func_177230_c()) {
                        data.func_177855_a(x, y - 1, z, top.func_177230_c().func_176223_P());
                    }
                }
            }
        }
    }
}

