/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.util.customphasemechanics;

import java.util.ArrayList;
import java.util.List;
import srpmixins.mixin.customphases.SRPSaveDataAccessor;

public class SRPSaveDataPlayerLegacyPatch {
    private final int dimId;
    private int points;
    private byte phase;
    private int time;
    private boolean canGain;
    private boolean cantLose;
    private List<Integer> lockedParaIds;
    private List<Byte> simParaIds;
    private List<Integer> simCounters;
    private boolean isValid = true;

    public SRPSaveDataPlayerLegacyPatch(int dimId, SRPSaveDataAccessor legacyData) {
        this.dimId = dimId;
        int idx = legacyData.getDimEPid().indexOf(dimId);
        if (idx == -1) {
            this.isValid = false;
            return;
        }
        this.points = legacyData.getDimEPtotalKills().get(idx);
        this.phase = legacyData.getDimEPevolution().get(idx);
        this.time = legacyData.getDimEPtimeEvolution().get(idx);
        this.canGain = legacyData.getDimEPcanGainPoints().get(idx);
        this.cantLose = legacyData.getDimEPcanLossPoints().get(idx);
        this.lockedParaIds = legacyData.getLockedParasites();
        this.simParaIds = legacyData.getSimRegId();
        this.simCounters = legacyData.getSimRegIdTimes();
    }

    public void patchWithLegacyData(SRPSaveDataAccessor actualData) {
        if (!this.isValid) {
            return;
        }
        int actualIdx = actualData.getDimEPid().indexOf(this.dimId);
        if (actualIdx == -1) {
            actualIdx = actualData.getDimEPid().size();
            actualData.getDimEPid().add(this.dimId);
        }
        actualData.getDimEPtotalKills().set(actualIdx, this.points);
        actualData.getDimEPevolution().set(actualIdx, this.phase);
        actualData.getDimEPtimeEvolution().set(actualIdx, this.time);
        actualData.getDimEPcanGainPoints().set(actualIdx, this.canGain);
        actualData.getDimEPcanLossPoints().set(actualIdx, this.cantLose);
        ArrayList<Integer> commonLockedParaIds = new ArrayList<Integer>();
        for (int paraId : actualData.getLockedParasites()) {
            if (!this.lockedParaIds.contains(paraId)) continue;
            commonLockedParaIds.add(paraId);
        }
        actualData.getLockedParasites().clear();
        actualData.getLockedParasites().addAll(commonLockedParaIds);
        for (int i = 0; i < this.simParaIds.size(); ++i) {
            int paraId;
            paraId = this.simParaIds.get(i).byteValue();
            int counterInLegacy = this.simCounters.get(i);
            int idxInActual = actualData.getSimRegId().indexOf((byte)paraId);
            if (idxInActual == -1) {
                idxInActual = actualData.getSimRegId().size();
                actualData.getSimRegId().add((byte)paraId);
            }
            int counterInActual = actualData.getSimRegIdTimes().get(idxInActual);
            actualData.getSimRegIdTimes().set(idxInActual, counterInActual + counterInLegacy);
        }
    }
}

