/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.rules.rule;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import srpmixins.SRPMixins;
import srpmixins.rules.conditions.DimensionCondition;
import srpmixins.rules.conditions.EvoPhaseCondition;
import srpmixins.rules.conditions.GenericCondition;
import srpmixins.rules.conditions.NodeCountCondition;
import srpmixins.rules.conditions.ParaGroupCondition;
import srpmixins.rules.conditions.ParaIdCondition;
import srpmixins.rules.rule.GenericRule;

public class VariantDisableRule
extends GenericRule {
    private Set<EnumVariant> variantsToDisable;

    public VariantDisableRule(String rule) {
        super(rule);
    }

    @Override
    protected Map<String, Function<String, ? extends GenericCondition<?>>> getConditionConstructors() {
        return new HashMap<String, Function<String, ? extends GenericCondition<?>>>(){
            {
                this.put("phase", EvoPhaseCondition::new);
                this.put("dim", DimensionCondition::new);
                this.put("mob", ParaIdCondition::new);
                this.put("group", ParaGroupCondition::new);
                this.put("nodes", NodeCountCondition::new);
            }
        };
    }

    @Override
    protected void parseRemainingConfigEntries(List<String> remainingEntries) {
        this.variantsToDisable = new HashSet<EnumVariant>();
        if (remainingEntries.size() != 1) {
            SRPMixins.LOGGER.warn("SRPMixins unable to parse Variant Disable Rule, no variant to disable");
            return;
        }
        String s = remainingEntries.get(0).trim();
        if (!s.startsWith("variant")) {
            SRPMixins.LOGGER.warn("SRPMixins unable to parse Variant Disable Rule, no variant to disable in {}", (Object)s);
            return;
        }
        s = s.replaceFirst("variant *=", "").trim();
        try {
            this.variantsToDisable.addAll(Arrays.stream(s.split(" +")).map(EnumVariant::valueOf).collect(Collectors.toSet()));
        }
        catch (Exception e) {
            SRPMixins.LOGGER.warn("SRPMixins unable to parse Variant Rule entry {}", (Object)s);
        }
    }

    public void disableVariants(List<EnumVariant> availableVariants, Map<String, Object> actualValues) {
        block5: {
            block4: {
                if (this.variantsToDisable.isEmpty()) break block4;
                if (!availableVariants.stream().noneMatch(this.variantsToDisable::contains)) break block5;
            }
            return;
        }
        if (this.anyMismatch(actualValues)) {
            return;
        }
        availableVariants.removeAll(this.variantsToDisable);
    }

    public static enum EnumVariant {
        SPECIAL(1),
        VIRULENT(5),
        BERSERKER(6),
        BREACHER(7);

        public final int skinId;

        private EnumVariant(int skinId) {
            this.skinId = skinId;
        }
    }
}

