/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.rules.rule;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import srpmixins.SRPMixins;
import srpmixins.rules.conditions.BloodMoonCondition;
import srpmixins.rules.conditions.DimensionCondition;
import srpmixins.rules.conditions.EvoPhaseCondition;
import srpmixins.rules.conditions.GenericCondition;
import srpmixins.rules.conditions.NodeCountCondition;
import srpmixins.rules.conditions.ParaGroupCondition;
import srpmixins.rules.conditions.ParaIdCondition;
import srpmixins.rules.conditions.VariantCondition;
import srpmixins.rules.rule.GenericRule;

public class StatIncreaseRule
extends GenericRule {
    private static int statCounter = 0;
    private Multimap<String, AttributeModifier> modifiers;
    private static final Map<String, String> attributeAliases = new HashMap<String, String>(){
        {
            this.put("DMG", "generic.attackDamage");
            this.put("DAMAGE", "generic.attackDamage");
            this.put("ATTACKDAMAGE", "generic.attackDamage");
            this.put("ATTACK", "generic.attackDamage");
            this.put("ATK", "generic.attackDamage");
            this.put("ATKSPD", "generic.attackSpeed");
            this.put("ATKSPEED", "generic.attackSpeed");
            this.put("ATTACKSPD", "generic.attackSpeed");
            this.put("ATTACKSPEED", "generic.attackSpeed");
            this.put("HP", "generic.maxHealth");
            this.put("MAXHP", "generic.maxHealth");
            this.put("HEALTH", "generic.maxHealth");
            this.put("MAXHEALTH", "generic.maxHealth");
            this.put("KB", "generic.knockbackResistance");
            this.put("KBRES", "generic.knockbackResistance");
            this.put("KBRESISTANCE", "generic.knockbackResistance");
            this.put("ARMOR", "generic.armor");
            this.put("TOUGH", "generic.armorToughness");
            this.put("TOUGHNESS", "generic.armorToughness");
            this.put("ARMORTOUGHNESS", "generic.armorToughness");
            this.put("SPD", "generic.movementSpeed");
            this.put("SPEED", "generic.movementSpeed");
            this.put("MOVSPEED", "generic.movementSpeed");
            this.put("MOVEMENTSPEED", "generic.movementSpeed");
            this.put("LUCK", "generic.luck");
            this.put("RANGE", "generic.followRange");
            this.put("FOLLOW", "generic.followRange");
            this.put("FOLLOWRANGE", "generic.followRange");
        }
    };
    private static final Map<String, Integer> operationAliases = new HashMap<String, Integer>(){
        {
            this.put("0", 0);
            this.put("ADD", 0);
            this.put("ADDITION", 0);
            this.put("+", 0);
            this.put("op0", 0);
            this.put("OP0", 0);
            this.put("OPERATION0", 0);
            this.put("1", 1);
            this.put("%", 1);
            this.put("MULT_BASE", 1);
            this.put("op1", 1);
            this.put("OP1", 1);
            this.put("OPERATION1", 1);
            this.put("2", 2);
            this.put("*", 2);
            this.put("x", 2);
            this.put("MULT", 2);
            this.put("MULT_TOTAL", 2);
            this.put("op2", 2);
            this.put("OP2", 2);
            this.put("OPERATION2", 2);
        }
    };

    public StatIncreaseRule(String rule) {
        super(rule);
    }

    @Override
    protected Map<String, Function<String, ? extends GenericCondition<?>>> getConditionConstructors() {
        return new HashMap<String, Function<String, ? extends GenericCondition<?>>>(){
            {
                this.put("phase", EvoPhaseCondition::new);
                this.put("dim", DimensionCondition::new);
                this.put("bloodmoon", BloodMoonCondition::new);
                this.put("mob", ParaIdCondition::new);
                this.put("group", ParaGroupCondition::new);
                this.put("variant", VariantCondition::new);
                this.put("nodes", NodeCountCondition::new);
            }
        };
    }

    @Override
    protected void parseRemainingConfigEntries(List<String> remainingEntries) {
        if (remainingEntries.isEmpty()) {
            SRPMixins.LOGGER.warn("SRPMixins unable to parse Stat Increase Rule, no stat modifiers given.");
            return;
        }
        this.modifiers = HashMultimap.create();
        for (String s : remainingEntries) {
            String[] split = s.split("=");
            if (split.length != 2) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse Stat Increase Rule Modifier, didn't name modifying value in {}", (Object)s);
                continue;
            }
            String attributeName = split[0].trim();
            if (attributeAliases.containsKey(attributeName)) {
                attributeName = attributeAliases.get(attributeName);
            }
            try {
                double value;
                int operation = 2;
                if (split[1].contains("@")) {
                    String[] modOp = split[1].trim().split("@");
                    String opString = modOp[1].trim();
                    if (!operationAliases.containsKey(opString)) {
                        SRPMixins.LOGGER.warn("SRPMixins unable to parse Stat Increase Rule Modifier, operation needs to be 0 (ADD) 1 (MULT_BASE) or 2 (MULT_TOTAL)");
                        continue;
                    }
                    operation = operationAliases.get(opString);
                    value = Double.parseDouble(modOp[0].trim());
                    if (value == 0.0) {
                        continue;
                    }
                } else {
                    value = Double.parseDouble(split[1].trim());
                }
                if (operation == 1 || operation == 2) {
                    value -= 1.0;
                }
                AttributeModifier mod = new AttributeModifier(UUID.nameUUIDFromBytes(("srpmixins_uuid" + statCounter++).getBytes()), "SRPMIXINS_STAT", value, operation);
                this.modifiers.put((Object)attributeName, (Object)mod);
            }
            catch (Exception e) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse Stat Increase Rule Modifier, parsing number(s) failed in {}", (Object)s);
            }
        }
    }

    public boolean hasModifiers(Map<String, Object> actualValues) {
        return !this.modifiers.isEmpty() && !this.anyMismatch(actualValues);
    }

    public Multimap<String, AttributeModifier> getModifiers() {
        return this.modifiers;
    }
}

