/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.rules.rule;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import srpmixins.SRPMixins;
import srpmixins.rules.conditions.BloodMoonCondition;
import srpmixins.rules.conditions.DimensionCondition;
import srpmixins.rules.conditions.EvoPhaseCondition;
import srpmixins.rules.conditions.GenericCondition;
import srpmixins.rules.conditions.NodeCountCondition;
import srpmixins.rules.rule.GenericRule;

public class MobCapRule
extends GenericRule {
    private double multi;

    public MobCapRule(String rule) {
        super(rule);
    }

    @Override
    protected Map<String, Function<String, ? extends GenericCondition<?>>> getConditionConstructors() {
        return new HashMap<String, Function<String, ? extends GenericCondition<?>>>(){
            {
                this.put("phase", EvoPhaseCondition::new);
                this.put("dim", DimensionCondition::new);
                this.put("bloodmoon", BloodMoonCondition::new);
                this.put("nodes", NodeCountCondition::new);
            }
        };
    }

    @Override
    protected void parseRemainingConfigEntries(List<String> remainingEntries) {
        this.multi = 1.0;
        if (remainingEntries.size() != 1) {
            SRPMixins.LOGGER.warn("SRPMixins unable to parse Mob Cap Rule, no multiplier");
        } else {
            try {
                this.multi = Double.parseDouble(remainingEntries.get(0).trim());
            }
            catch (Exception e) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse Mob Cap Rule {}", (Object)remainingEntries.get(0));
            }
        }
    }

    public double getMulti(Map<String, Object> actualValues) {
        if (this.multi == 1.0) {
            return 1.0;
        }
        if (this.anyMismatch(actualValues)) {
            return 1.0;
        }
        return this.multi;
    }
}

