/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.rules.rule;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import srpmixins.SRPMixins;
import srpmixins.rules.conditions.DimensionCondition;
import srpmixins.rules.conditions.EvoPhaseCondition;
import srpmixins.rules.conditions.GenericCondition;
import srpmixins.rules.rule.GenericRule;

public class MinMaxDayPerPhaseRule
extends GenericRule {
    private int min;
    private int max;

    public MinMaxDayPerPhaseRule(String rule) {
        super(rule);
    }

    @Override
    protected Map<String, Function<String, ? extends GenericCondition<?>>> getConditionConstructors() {
        return new HashMap<String, Function<String, ? extends GenericCondition<?>>>(){
            {
                this.put("phase", EvoPhaseCondition::new);
                this.put("dim", DimensionCondition::new);
            }
        };
    }

    @Override
    protected void parseRemainingConfigEntries(List<String> remainingEntries) {
        this.min = Integer.MAX_VALUE;
        this.max = 0;
        for (String s : remainingEntries) {
            try {
                if (s.contains("min")) {
                    this.min = Integer.parseInt(s.replaceFirst("min *=", "").trim());
                } else if (s.contains("max")) {
                    this.max = Integer.parseInt(s.replaceFirst("max *=", "").trim());
                }
                if (this.min == Integer.MAX_VALUE || this.max == 0 || this.min <= this.max) continue;
                this.max = this.min;
            }
            catch (Exception e) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse Days Per Phase Rule {}", (Object)s);
            }
        }
    }

    public int getMin(Map<String, Object> actualValues) {
        if (this.min == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (this.anyMismatch(actualValues)) {
            return Integer.MAX_VALUE;
        }
        return this.min;
    }

    public int getMax(Map<String, Object> actualValues) {
        if (this.max == 0) {
            return 0;
        }
        if (this.anyMismatch(actualValues)) {
            return 0;
        }
        return this.max;
    }
}

