/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.rules.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import srpmixins.SRPMixins;
import srpmixins.rules.conditions.GenericCondition;

public abstract class GenericRule {
    protected final List<GenericCondition<?>> conditions = new ArrayList();

    protected abstract Map<String, Function<String, ? extends GenericCondition<?>>> getConditionConstructors();

    public GenericRule(String rule) {
        rule = rule.replaceAll("\\[", "");
        String[] split = rule.split("[;,\\]]");
        ArrayList<String> remainingEntries = new ArrayList<String>();
        Map<String, Function<String, GenericCondition<?>>> constructorMap = this.getConditionConstructors();
        block2: for (String s : split) {
            s = s.trim();
            for (Map.Entry<String, Function<String, GenericCondition<?>>> constructorMapEntry : constructorMap.entrySet()) {
                if (!s.startsWith(constructorMapEntry.getKey())) continue;
                try {
                    this.conditions.add(constructorMapEntry.getValue().apply(s));
                    continue block2;
                }
                catch (Exception e) {
                    SRPMixins.LOGGER.warn("SRPMixins unable to parse Rule {}", (Object)s);
                }
            }
            remainingEntries.add(s);
        }
        this.parseRemainingConfigEntries(remainingEntries);
    }

    protected abstract void parseRemainingConfigEntries(List<String> var1);

    protected boolean anyMismatch(Map<String, Object> actualValues) {
        for (GenericCondition<?> rule : this.conditions) {
            if (rule.test(actualValues)) continue;
            return true;
        }
        return false;
    }
}

