/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.rules.rule;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import srpmixins.SRPMixins;
import srpmixins.rules.conditions.DimensionCondition;
import srpmixins.rules.conditions.EvoPhaseCondition;
import srpmixins.rules.conditions.GenericCondition;
import srpmixins.rules.conditions.ParaGroupCondition;
import srpmixins.rules.conditions.ParaIdCondition;
import srpmixins.rules.rule.GenericRule;

public class DespawnTimerRule
extends GenericRule {
    private int timerAdd;

    public DespawnTimerRule(String rule) {
        super(rule);
    }

    @Override
    protected Map<String, Function<String, ? extends GenericCondition<?>>> getConditionConstructors() {
        return new HashMap<String, Function<String, ? extends GenericCondition<?>>>(){
            {
                this.put("phase", EvoPhaseCondition::new);
                this.put("dim", DimensionCondition::new);
                this.put("mob", ParaIdCondition::new);
                this.put("group", ParaGroupCondition::new);
            }
        };
    }

    @Override
    protected void parseRemainingConfigEntries(List<String> remainingEntries) {
        this.timerAdd = 0;
        if (remainingEntries.size() != 1) {
            SRPMixins.LOGGER.warn("SRPMixins unable to parse Despawn Timer Rule, no timer value");
        } else {
            try {
                this.timerAdd = Integer.parseInt(remainingEntries.get(0).trim());
            }
            catch (Exception e) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse Despawn Timer Rule {}", (Object)remainingEntries.get(0));
            }
        }
    }

    public int getTimer(Map<String, Object> actualValues) {
        if (this.timerAdd == 0) {
            return 0;
        }
        if (this.anyMismatch(actualValues)) {
            return 0;
        }
        return this.timerAdd;
    }
}

