/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.rules;

import com.dhanantry.scapeandrunparasites.block.BlockInfestedOre;
import com.dhanantry.scapeandrunparasites.block.BlockParasiteRubble;
import com.dhanantry.scapeandrunparasites.block.BlockParasiteStain;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockObsidian;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

public class BlockTransformationRule {
    private static final Map<Material, List<BlockTransformationRule>> allRules = new HashMap<Material, List<BlockTransformationRule>>();
    private final Predicate<Block> predicateBlock;
    private final IBlockState resultState;
    private boolean addsPoints = true;
    private boolean doGenAbove = false;
    private boolean doGenBelow = false;
    private boolean skipsHardnessCheck = false;

    public BlockTransformationRule(Material material, Predicate<Block> predicateBlock, IBlockState resultState) {
        this.predicateBlock = predicateBlock;
        this.resultState = resultState;
        allRules.computeIfAbsent(material, key -> new ArrayList()).add(this);
    }

    public BlockTransformationRule setNoPoints() {
        this.addsPoints = false;
        return this;
    }

    public BlockTransformationRule setGeneratesAbove() {
        this.doGenAbove = true;
        return this;
    }

    public BlockTransformationRule setGeneratesBelow() {
        this.doGenBelow = true;
        return this;
    }

    public BlockTransformationRule setSkipsHardnessCheck() {
        this.skipsHardnessCheck = true;
        return this;
    }

    public boolean getGeneratesAbove() {
        return this.doGenAbove;
    }

    public boolean getGeneratesBelow() {
        return this.doGenBelow;
    }

    public boolean getAddsPoints() {
        return this.addsPoints;
    }

    public boolean getSkipHardnessCheck() {
        return this.skipsHardnessCheck;
    }

    @Nullable
    public IBlockState getResultState() {
        return this.resultState;
    }

    public boolean isApplicable(Block block) {
        return this.predicateBlock == null || this.predicateBlock.test(block);
    }

    @Nullable
    public static BlockTransformationRule getFirstApplicableRule(Material material, Block blockToTest) {
        if (allRules.isEmpty()) {
            new BlockTransformationRule(Material.field_151578_c, null, SRPBlocks.ParasiteStain.func_176223_P()).setGeneratesBelow().setGeneratesAbove();
            new BlockTransformationRule(Material.field_151577_b, null, SRPBlocks.ParasiteStain.func_176223_P()).setGeneratesBelow().setGeneratesAbove();
            new BlockTransformationRule(Material.field_151595_p, null, SRPBlocks.ParasiteStain.func_176223_P().func_177226_a((IProperty)BlockParasiteStain.VARIANT, (Comparable)BlockParasiteStain.EnumType.MUD)).setGeneratesBelow().setGeneratesAbove();
            new BlockTransformationRule(Material.field_151585_k, null, SRPBlocks.ParasiteStain.func_176223_P().func_177226_a((IProperty)BlockParasiteStain.VARIANT, (Comparable)BlockParasiteStain.EnumType.FLESH));
            new BlockTransformationRule(Material.field_151573_f, null, SRPBlocks.ParasiteRubble.func_176223_P().func_177226_a((IProperty)BlockParasiteRubble.VARIANT, (Comparable)BlockParasiteRubble.EnumType.METAL));
            new BlockTransformationRule(Material.field_151598_x, null, SRPBlocks.BloodyIce.func_176223_P());
            new BlockTransformationRule(Material.field_151588_w, block -> block == SRPBlocks.BloodyIce, null).setNoPoints().setSkipsHardnessCheck();
            new BlockTransformationRule(Material.field_151588_w, null, SRPBlocks.BloodyIce.func_176223_P()).setSkipsHardnessCheck();
            new BlockTransformationRule(Material.field_151576_e, block -> block instanceof BlockStone, SRPBlocks.ParasiteRubble.func_176223_P().func_177226_a((IProperty)BlockParasiteRubble.VARIANT, (Comparable)BlockParasiteRubble.EnumType.STONE)).setGeneratesAbove();
            new BlockTransformationRule(Material.field_151576_e, block -> block == Blocks.field_150365_q, SRPBlocks.InfestedOre.func_176223_P()).setGeneratesBelow();
            new BlockTransformationRule(Material.field_151576_e, block -> block == Blocks.field_150366_p, SRPBlocks.InfestedOre.func_176223_P().func_177226_a((IProperty)BlockInfestedOre.VARIANT, (Comparable)BlockInfestedOre.EnumType.IRO)).setGeneratesBelow();
            new BlockTransformationRule(Material.field_151576_e, block -> block == Blocks.field_150482_ag, SRPBlocks.InfestedOre.func_176223_P().func_177226_a((IProperty)BlockInfestedOre.VARIANT, (Comparable)BlockInfestedOre.EnumType.DIA)).setGeneratesBelow();
            new BlockTransformationRule(Material.field_151576_e, block -> block == Blocks.field_150412_bA, SRPBlocks.InfestedOre.func_176223_P().func_177226_a((IProperty)BlockInfestedOre.VARIANT, (Comparable)BlockInfestedOre.EnumType.EME)).setGeneratesBelow();
            new BlockTransformationRule(Material.field_151576_e, block -> block == Blocks.field_150352_o, SRPBlocks.InfestedOre.func_176223_P().func_177226_a((IProperty)BlockInfestedOre.VARIANT, (Comparable)BlockInfestedOre.EnumType.GOL)).setGeneratesBelow();
            new BlockTransformationRule(Material.field_151576_e, block -> block == Blocks.field_150369_x, SRPBlocks.InfestedOre.func_176223_P().func_177226_a((IProperty)BlockInfestedOre.VARIANT, (Comparable)BlockInfestedOre.EnumType.LAP)).setGeneratesBelow();
            new BlockTransformationRule(Material.field_151576_e, block -> block == Blocks.field_150450_ax, SRPBlocks.InfestedOre.func_176223_P().func_177226_a((IProperty)BlockInfestedOre.VARIANT, (Comparable)BlockInfestedOre.EnumType.RED)).setGeneratesBelow();
            new BlockTransformationRule(Material.field_151576_e, block -> block instanceof BlockOre, SRPBlocks.InfestedOre.func_176223_P().func_177226_a((IProperty)BlockInfestedOre.VARIANT, (Comparable)BlockInfestedOre.EnumType.UN)).setGeneratesBelow();
            new BlockTransformationRule(Material.field_151576_e, block -> block instanceof BlockObsidian, SRPBlocks.ParasiteRubble.func_176223_P().func_177226_a((IProperty)BlockParasiteRubble.VARIANT, (Comparable)BlockParasiteRubble.EnumType.OBSIDIAN)).setGeneratesBelow().setGeneratesAbove();
            new BlockTransformationRule(Material.field_151576_e, block -> block == SRPBlocks.BiomeHeart || block == SRPBlocks.ColonyHeart || block instanceof BlockMobSpawner, null).setNoPoints();
            new BlockTransformationRule(Material.field_151576_e, block -> block.getRegistryName().toString().contains("brick"), SRPBlocks.ParasiteRubble.func_176223_P().func_177226_a((IProperty)BlockParasiteRubble.VARIANT, (Comparable)BlockParasiteRubble.EnumType.BRICKS)).setGeneratesBelow().setGeneratesAbove();
            new BlockTransformationRule(Material.field_151576_e, null, SRPBlocks.ParasiteRubble.func_176223_P().func_177226_a((IProperty)BlockParasiteRubble.VARIANT, (Comparable)BlockParasiteRubble.EnumType.STONE)).setGeneratesBelow().setGeneratesAbove();
            new BlockTransformationRule(Material.field_151575_d, block -> block == SRPBlocks.InfestedTrunk, SRPBlocks.ParasiteTrunk.func_176223_P()).setNoPoints();
            new BlockTransformationRule(Material.field_151575_d, block -> block.getRegistryName().toString().contains("mushroom"), SRPBlocks.ParasiteRubble.func_176223_P().func_177226_a((IProperty)BlockParasiteRubble.VARIANT, (Comparable)BlockParasiteRubble.EnumType.FUNGUS));
            new BlockTransformationRule(Material.field_151575_d, null, SRPBlocks.ParasiteRubble.func_176223_P().func_177226_a((IProperty)BlockParasiteRubble.VARIANT, (Comparable)BlockParasiteRubble.EnumType.WOOD));
        }
        for (BlockTransformationRule rule : allRules.getOrDefault(material, Collections.emptyList())) {
            if (!rule.isApplicable(blockToTest)) continue;
            return rule;
        }
        return null;
    }
}

