/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.network;

import com.dhanantry.scapeandrunparasites.SRPMain;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.network.SRPPacketMovingSound;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.config.providers.SRPMobConfigProvider;

public class PhaseWarningOverhaul {
    public static void alertOnePlayer(World worldIn, UUID playerUUID, String message, int warning) {
        boolean sendToAll;
        boolean bl = sendToAll = !SRPMixinsConfigHandler.playerphases.enabled || playerUUID == null;
        if (sendToAll) {
            ParasiteEventEntity.alertAllPlayerDim((World)worldIn, (String)message, (int)warning);
        } else {
            EntityPlayer player = worldIn.func_152378_a(playerUUID);
            if (player == null) {
                return;
            }
            player.func_145747_a((ITextComponent)new TextComponentString(message));
            SRPMain.network.sendTo((IMessage)new SRPPacketMovingSound(warning), (EntityPlayerMP)player);
            if (warning == -7 && message.equals("Phase decreased")) {
                for (EntityParasiteBase entity : worldIn.func_175644_a(EntityParasiteBase.class, ent -> ent.func_70068_e((Entity)player) <= 65536.0)) {
                    entity.func_70690_d(new PotionEffect(SRPPotions.RAGE_E, 2400, 1, false, false));
                }
            }
        }
    }

    public static void sendUnlockMessage(World world, UUID playerUUID, String message, int paraId) {
        TextComponentString msg;
        boolean sendToAll = !SRPMixinsConfigHandler.playerphases.enabled || playerUUID == null;
        String paraName = SRPMobConfigProvider.paraIdToMobName.get(paraId);
        String customMsg = SRPMixinsConfigHandler.phasepoints.customUnlockMessages.getOrDefault(paraName, message);
        if (customMsg.contains("%")) {
            ResourceLocation loc = new ResourceLocation("srparasites", paraName);
            msg = new TextComponentTranslation(customMsg, new Object[]{new TextComponentTranslation("entity." + EntityList.func_191302_a((ResourceLocation)loc) + ".name", new Object[0])});
        } else {
            msg = new TextComponentString(customMsg);
        }
        if (!sendToAll) {
            EntityPlayer player = world.func_152378_a(playerUUID);
            if (player != null) {
                player.func_145747_a((ITextComponent)msg);
            }
        } else {
            world.func_73046_m().func_184103_al().func_181057_v().forEach(arg_0 -> PhaseWarningOverhaul.lambda$sendUnlockMessage$1((ITextComponent)msg, arg_0));
        }
    }

    private static /* synthetic */ void lambda$sendUnlockMessage$1(ITextComponent msg, EntityPlayerMP player) {
        player.func_145747_a(msg);
    }
}

