/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.weaponfixes;

import com.dhanantry.scapeandrunparasites.init.SRPItems;
import com.dhanantry.scapeandrunparasites.item.tool.WeaponToolArmorBase;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import srpmixins.capability.adaptation.CapabilityAdaptationHandler;
import srpmixins.capability.adaptation.ICapabilityAdaptation;
import srpmixins.config.SRPMixinsConfigHandler;

@Mixin(value={WeaponToolArmorBase.class})
public class SentientArmorEvolution
extends ItemArmor {
    public SentientArmorEvolution(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
    }

    @Inject(method={"onUpdate"}, at={@At(value="TAIL")})
    public void srpmixins_countKillsOnArmor(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected, CallbackInfo ci) {
        int srpkills;
        NBTTagCompound compound;
        if (SRPMixinsConfigHandler.weapons.disableSentientEvolution) {
            return;
        }
        if (!worldIn.field_72995_K && entityIn.field_70173_aa % 80 == 0 && (compound = stack.func_77978_p()) != null && this.func_82812_d() == SRPItems.ARMOR_LIVING && (srpkills = compound.func_74762_e("srpkills")) > SRPConfig.weapon_livingSentient_HP_needed) {
            compound.func_74768_a("srpkills", 0);
            stack.func_190918_g(1);
            ItemStack newStack = new ItemStack(this.srpmixins$getNext(), 1);
            if (SRPMixinsConfigHandler.weapons.fixSentientEvolutionNBT) {
                newStack.func_77982_d(stack.func_77978_p());
                if (SRPMixinsConfigHandler.adaptation.overhaulAdaptation) {
                    ICapabilityAdaptation adaCap = (ICapabilityAdaptation)stack.getCapability(CapabilityAdaptationHandler.CAP_ADAPTATION, null);
                    ICapabilityAdaptation adaCapNew = (ICapabilityAdaptation)newStack.getCapability(CapabilityAdaptationHandler.CAP_ADAPTATION, null);
                    if (adaCap != null && adaCapNew != null) {
                        adaCapNew.copyAdaptationsFrom(adaCap);
                    }
                }
            }
            EntityItem entityitem = new EntityItem(worldIn, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, newStack);
            entityitem.func_174869_p();
            worldIn.func_72838_d((Entity)entityitem);
            if (SRPConfig.thunderEnable) {
                worldIn.func_72942_c((Entity)new EntityLightningBolt(worldIn, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, true));
            }
        }
    }

    @Unique
    public Item srpmixins$getNext() {
        if (this.func_82812_d() != SRPItems.ARMOR_LIVING) {
            return null;
        }
        switch (this.field_77881_a) {
            case HEAD: {
                return SRPItems.armor_helmetSentient;
            }
            case CHEST: {
                return SRPItems.armor_chestSentient;
            }
            case LEGS: {
                return SRPItems.armor_pantsSentient;
            }
            case FEET: {
                return SRPItems.armor_bootsSentient;
            }
        }
        return null;
    }

    @Inject(method={"addInformation"}, at={@At(value="HEAD")})
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn, CallbackInfo ci) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (SRPMixinsConfigHandler.weapons.disableSentientEvolution) {
            return;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (!(compound == null || this.func_82812_d() != SRPItems.ARMOR_LIVING && SRPMixinsConfigHandler.weapons.removeSentientSRPKillsTooltip)) {
            tooltip.add(TextFormatting.BLUE + "---> " + compound.func_74762_e("srpkills"));
            tooltip.add(TextFormatting.BLUE + "  ");
        }
    }
}

