/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.waterparasites;

import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfSquid;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import srpmixins.compat.CompatUtil;
import srpmixins.compat.SRPExtraCompat;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.handlers.WorldMobCapHandler;

@Mixin(value={ParasiteEventEntity.class})
public abstract class WaterParasiteCapOnConversion {
    @WrapWithCondition(method={"convertEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z", ordinal=0)})
    private static boolean srpmixins_infSquidCap(World world, Entity entity) {
        if (WaterParasiteCapOnConversion.srpmixins$isWaterPara(entity)) {
            if (SRPMixinsConfigHandler.spawns.fixSpawningEntirely) {
                return (double)WorldMobCapHandler.waterCount.get(world.field_73011_w.getDimension()).intValue() < (double)SRPMixinsConfigHandler.waterparas.waterParasiteCap * 1.5;
            }
            int infSquidCount = (int)world.field_72996_f.stream().filter(e -> e instanceof EntityInfSquid).count();
            return infSquidCount < SRPMixinsConfigHandler.waterparas.waterParasiteCap;
        }
        return true;
    }

    @Unique
    private static boolean srpmixins$isWaterPara(Entity entity) {
        if (entity instanceof EntityInfSquid) {
            return true;
        }
        return CompatUtil.srpextra.isLoaded() && SRPExtraCompat.isWaterParasite(entity);
    }
}

