/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.spawning.summoningoverhaul;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityCanSummon;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import srpmixins.util.ISummonsByUUID;

@Mixin(value={EntityParasiteBase.class})
public abstract class ReadWriteSummons {
    @Inject(method={"writeEntityToNBT"}, at={@At(value="TAIL")})
    private void srpmixins_writeSummonsToNBT(NBTTagCompound compound, CallbackInfo ci) {
        if (!(this instanceof EntityCanSummon)) {
            return;
        }
        Map<UUID, Integer> summonMap = ((ISummonsByUUID)((Object)this)).srpmixins$getSummonEntries();
        if (summonMap.isEmpty()) {
            return;
        }
        NBTTagList nbtList = new NBTTagList();
        for (Map.Entry<UUID, Integer> entry : summonMap.entrySet()) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74778_a("uuid", entry.getKey().toString());
            tags.func_74768_a("points", entry.getValue().intValue());
            nbtList.func_74742_a((NBTBase)tags);
        }
        compound.func_74782_a("srpmixins_summons", (NBTBase)nbtList);
    }

    @Inject(method={"readEntityFromNBT"}, at={@At(value="TAIL")})
    private void srpmixins_readSummonsToNBT(NBTTagCompound compound, CallbackInfo ci) {
        if (!(this instanceof EntityCanSummon)) {
            return;
        }
        if (!compound.func_74764_b("srpmixins_summons")) {
            return;
        }
        NBTTagList nbtList = compound.func_150295_c("srpmixins_summons", 10);
        for (NBTBase tag : nbtList) {
            UUID uuid = UUID.fromString(((NBTTagCompound)tag).func_74779_i("uuid"));
            int points = ((NBTTagCompound)tag).func_74762_e("points");
            ((ISummonsByUUID)((Object)this)).srpmixins$addSummon(uuid, points);
        }
    }
}

