/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.spawning;

import com.dhanantry.scapeandrunparasites.world.SRPWorldEntitySpawner;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.config.SRPMixinsConfigProvider;

@Mixin(value={SRPWorldEntitySpawner.class})
public abstract class SpawningBlacklistByBiome {
    @Inject(method={"getSpawnListEntryForTypeAt"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void srpmixins_blacklistBiomesAndDimensions(WorldServer worldServerIn, BlockPos pos, CallbackInfoReturnable<Biome.SpawnListEntry> cir) {
        boolean isInList;
        int dim = worldServerIn.field_73011_w.getDimension();
        Set<String> biomeBlacklist = SRPMixinsConfigProvider.biomeSpawningBlacklists.get(dim);
        if (biomeBlacklist == null) {
            return;
        }
        if (biomeBlacklist.isEmpty()) {
            if (!SRPMixinsConfigHandler.spawns.biomeBlacklistIsWhitelist) {
                cir.setReturnValue(null);
            }
            return;
        }
        ResourceLocation biome = worldServerIn.func_180494_b(pos).getRegistryName();
        if (biome == null) {
            return;
        }
        String currBiome = biome.toString();
        String currBiomeMod = biome.func_110624_b();
        boolean bl = isInList = biomeBlacklist.contains(currBiome) || biomeBlacklist.contains(currBiomeMod);
        if (isInList != SRPMixinsConfigHandler.spawns.biomeBlacklistIsWhitelist) {
            cir.setReturnValue(null);
        }
    }
}

