/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.phaseresetfix.srpworlddata;

import com.dhanantry.scapeandrunparasites.world.SRPWorldData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import srpmixins.config.SRPMixinsConfigHandler;

@Mixin(value={SRPWorldData.class})
public abstract class SRPWorldDataMixin
extends WorldSavedData {
    @Unique
    private static SRPWorldData srpmixins$clientSRPData = null;
    @Unique
    private static long srpmixins$lastMsgTick = 0L;

    public SRPWorldDataMixin(String name) {
        super(name);
    }

    @Inject(method={"get"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void srpmixins_fullyDisableNodeResetsForever(World world, CallbackInfoReturnable<SRPWorldData> cir) {
        if (!world.field_72995_K) {
            return;
        }
        if (srpmixins$clientSRPData == null) {
            srpmixins$clientSRPData = new SRPWorldData("SRPMixins_protects_your_nodes");
        }
        long currTime = world.func_82737_E();
        if (SRPMixinsConfigHandler.phasepoints.phaseResetDebugMode && currTime - srpmixins$lastMsgTick > 100L) {
            srpmixins$lastMsgTick = currTime;
            try {
                throw new Exception("SRP tried to reset your node data");
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                for (EntityPlayer player : world.field_73010_i) {
                    if (player == null) continue;
                    player.func_145747_a(new TextComponentString("SRPMixins prevented an accidental node reset. Check (serverside) latest.log and send to Nischhelm").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
        }
        cir.setReturnValue((Object)srpmixins$clientSRPData);
    }

    @Inject(method={"checkHeartExistance", "checkColonyExistance"}, at={@At(value="TAIL")}, remap=false)
    private void srpmixins_saveWhenChanged(World worldIn, CallbackInfo ci) {
        this.func_76185_a();
    }

    @ModifyVariable(method={"setNode", "setColony"}, at=@At(value="STORE", ordinal=1), name={"canAdd"}, remap=false)
    private int srpmixins_saveWhenChanged(int value) {
        this.func_76185_a();
        return value;
    }
}

