/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.phaseresetfix.srpsavedata;

import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import java.io.PrintStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import srpmixins.config.SRPMixinsConfigHandler;

@Mixin(value={SRPSaveData.class})
public abstract class SRPSaveDataMixin {
    @Shadow(remap=false)
    private static SRPSaveData instance;
    @Unique
    private static SRPSaveData srpmixins$clientSRPData;
    @Unique
    private static long srpmixins$lastMsgTick;

    @Shadow(remap=false)
    private static SRPSaveData createData(World world, MapStorage storage) {
        return null;
    }

    @Inject(method={"get"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void srpmixins_fullyDisablePhaseResetsForever(World world, CallbackInfoReturnable<SRPSaveData> cir) {
        if (!world.field_72995_K) {
            return;
        }
        if (srpmixins$clientSRPData == null) {
            SRPSaveData tmpInstance = instance;
            instance = new SRPSaveData("SRPMixins_protects_your_phase");
            srpmixins$clientSRPData = SRPSaveDataMixin.createData(world, null);
            instance = tmpInstance;
        }
        long currTime = world.func_82737_E();
        if (SRPMixinsConfigHandler.phasepoints.phaseResetDebugMode && currTime - srpmixins$lastMsgTick > 100L) {
            srpmixins$lastMsgTick = currTime;
            try {
                throw new Exception("SRP tried to reset your phase");
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                for (EntityPlayer player : world.field_73010_i) {
                    if (player == null) continue;
                    player.func_145747_a(new TextComponentString("SRPMixins prevented an accidental phase reset. Check (serverside) latest.log and send to Nischhelm").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
        }
        cir.setReturnValue((Object)srpmixins$clientSRPData);
    }

    @Redirect(method={"get"}, at=@At(value="INVOKE", target="Ljava/io/PrintStream;println(Ljava/lang/String;)V"), remap=false)
    private static void srpmixins_disableSRPDebugMessage(PrintStream instance, String s) {
    }

    static {
        srpmixins$clientSRPData = null;
        srpmixins$lastMsgTick = 0L;
    }
}

