/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.phasepointfixes;

import com.dhanantry.scapeandrunparasites.item.ItemEPClock;
import com.dhanantry.scapeandrunparasites.network.SRPCommandEvolution;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import srpmixins.config.SRPConfigProvider;
import srpmixins.config.SRPMixinsConfigHandler;

@Mixin(value={ItemEPClock.class})
public abstract class ModifiedBloodyClock {
    @WrapWithCondition(method={"onItemRightClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;sendStatusMessage(Lnet/minecraft/util/text/ITextComponent;Z)V")})
    public boolean srpmixins_sendPhaseMessageToChat(EntityPlayer player, ITextComponent iTextComponent, boolean actionBar, @Local(argsOnly=true) World worldIn, @Local SRPSaveData saveData) {
        int dimension = worldIn.field_73011_w.getDimension();
        byte evoPhase = saveData.getEvolutionPhase(dimension);
        int pointsCurr = saveData.getTotalKills(dimension);
        if (evoPhase == -2) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("srpmixins.bloodyclock.phaseminustwo", new Object[0]), actionBar);
            return false;
        }
        if (evoPhase == -1) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("srpmixins.bloodyclock.phaseminusone", new Object[0]), actionBar);
            return false;
        }
        if (pointsCurr >= SRPConfigSystems.phaseTenTotalPoints) {
            player.func_146105_b(new TextComponentTranslation("srpmixins.bloodyclock.phasemaximum", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), actionBar);
            return false;
        }
        int pointsThis = SRPCommandEvolution.getNeededPoints((byte)evoPhase);
        int pointsNext = SRPCommandEvolution.getNeededPoints((byte)((byte)Math.min(evoPhase + 1, SRPConfigProvider.getMaxPhase())));
        int perc = (int)Math.round(100.0 * ((double)pointsCurr - (double)pointsThis) / ((double)pointsNext - (double)pointsThis));
        if (pointsNext == pointsThis) {
            perc = 0;
        }
        int cooldown = saveData.getCooldown(worldIn, dimension);
        if (SRPMixinsConfigHandler.phasepoints.bloodyClockShowsCooldown && cooldown > 0) {
            int hours = cooldown / 3600;
            int minutes = (cooldown -= 3600 * hours) / 60;
            int seconds = cooldown -= 60 * minutes;
            TextComponentTranslation cooldownMsg = hours > 0 ? new TextComponentTranslation("srpmixins.bloodyclock.hours", new Object[]{hours, minutes, seconds}) : (minutes > 0 ? new TextComponentTranslation("srpmixins.bloodyclock.minutes", new Object[]{minutes, seconds}) : new TextComponentTranslation("srpmixins.bloodyclock.seconds", new Object[]{seconds}));
            player.func_146105_b((ITextComponent)new TextComponentTranslation("srpmixins.bloodyclock.phaseandcooldown", new Object[]{Integer.toString(evoPhase), perc, cooldownMsg}), actionBar);
        } else {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("srpmixins.bloodyclock.currentphase", new Object[]{Integer.toString(evoPhase), perc}), actionBar);
        }
        return false;
    }
}

