/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.parabiome;

import com.dhanantry.scapeandrunparasites.block.IMetaName;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventWorld;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigWorld;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import srpmixins.compat.CompatUtil;
import srpmixins.compat.CotesiaCompat;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.event.BlockInfestationEvent;
import srpmixins.rules.BlockTransformationRule;
import srpmixins.util.customphasemechanics.SRPSaveDataInterface;

@Mixin(value={ParasiteEventWorld.class})
public abstract class BiomeSpreadOverhaul {
    @Shadow(remap=false)
    public static int blockParasiteCount;
    @Unique
    private static final Set<Block> srpmixins$listedBlocks;

    @Shadow(remap=false)
    public static void spawnGenFeatureParasite(World worldIn, BlockPos pos, Random rand) {
    }

    @Shadow(remap=false)
    public static void spawnGenRoofParasite(World worldIn, BlockPos pos, Random rand) {
    }

    @Overwrite(remap=false)
    public static void spreadBiomeBlockStain(World worldIn, BlockPos startPos, Random rand) {
        if (CompatUtil.cotesia.isLoaded() && CotesiaCompat.spreadBiomeInject(worldIn, startPos, rand)) {
            return;
        }
        if (SRPMixinsConfigHandler.parabiome.fixBiomeSpreadingLimit && blockParasiteCount > SRPConfig.BlockParasiteLimit) {
            return;
        }
        int convertedCount = 0;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (EnumFacing facing : EnumFacing.values()) {
            Block block;
            blockPos.func_189533_g((Vec3i)startPos).func_189536_c(facing);
            IBlockState state = worldIn.func_180495_p((BlockPos)blockPos);
            Material material = state.func_185904_a();
            if (material == Material.field_151579_a || (block = state.func_177230_c()) instanceof IMetaName) continue;
            if (block.isWood((IBlockAccess)worldIn, (BlockPos)blockPos) || block == SRPBlocks.InfestedStain) {
                ++convertedCount;
                worldIn.func_175656_a((BlockPos)blockPos, SRPBlocks.ParasiteTrunk.func_176223_P());
                continue;
            }
            BlockTransformationRule rule = BlockTransformationRule.getFirstApplicableRule(material, block);
            if (rule == null) continue;
            BlockInfestationEvent event = new BlockInfestationEvent(worldIn, (BlockPos)blockPos, rule.getResultState(), true, rule).setFacing(facing);
            boolean isCanceled = MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceledFully()) break;
            if (isCanceled || event.getState() == null || !rule.getSkipHardnessCheck() && BiomeSpreadOverhaul.srpmixins$blockIsBlacklistedForBiome(worldIn, (BlockPos)blockPos, block, state)) continue;
            worldIn.func_175656_a((BlockPos)blockPos, event.getState());
            if (event.generatesAbove) {
                BiomeSpreadOverhaul.spawnGenFeatureParasite(worldIn, blockPos.func_177984_a(), rand);
            }
            if (event.generatesBelow) {
                BiomeSpreadOverhaul.spawnGenRoofParasite(worldIn, blockPos.func_177977_b(), rand);
            }
            if (!event.increasesPoints) continue;
            ++convertedCount;
        }
        if (convertedCount != 0) {
            blockParasiteCount += convertedCount;
            if (SRPConfigSystems.useEvolution) {
                SRPSaveData data = SRPSaveDataInterface.get(worldIn, null, startPos);
                byte lock = SRPMixinsConfigHandler.phasepoints.biomeSpreadingPenaltyPhase;
                if (lock < 0 || data.getEvolutionPhase(worldIn.field_73011_w.getDimension()) >= lock) {
                    data.setTotalKills(worldIn.field_73011_w.getDimension(), SRPConfigSystems.valueBlock * convertedCount, true, worldIn, true);
                }
            }
        }
    }

    @Unique
    private static boolean srpmixins$blockIsBlacklistedForBiome(World worldIn, BlockPos pos, Block block, IBlockState state) {
        float hardness = state.func_185887_b(worldIn, pos);
        if (hardness < 0.0f || hardness > SRPConfigWorld.biomeBlockIMaxH) {
            return true;
        }
        if (!state.func_185917_h() || block.func_176205_b((IBlockAccess)worldIn, pos) || block instanceof BlockBreakable || block instanceof BlockContainer || block instanceof BlockHorizontal || block instanceof BlockTNT || block instanceof IPlantable) {
            return true;
        }
        if (CompatUtil.cotesia.isLoaded() && CotesiaCompat.isUncorruptible(block)) {
            return true;
        }
        if (srpmixins$listedBlocks.contains(block)) {
            return !SRPConfigWorld.blockBBiomeListWhite;
        }
        ResourceLocation loc = block.getRegistryName();
        if (loc == null) {
            return SRPConfigSystems.blockBListWhite;
        }
        String blockName = loc.toString();
        boolean isInList = Arrays.stream(SRPConfigWorld.blockBBiomeList).anyMatch(blockName::contains);
        if (isInList) {
            srpmixins$listedBlocks.add(block);
        }
        return isInList != SRPConfigWorld.blockBBiomeListWhite;
    }

    @Overwrite(remap=false)
    public static void spreadBiomeBlockTrunk(World worldIn, BlockPos startPos, Random rand) {
        if (CompatUtil.cotesia.isLoaded() && CotesiaCompat.spreadBiomeInject(worldIn, startPos, rand)) {
            return;
        }
        int convertedCount = 0;
        for (BlockPos.MutableBlockPos blockPos : BlockPos.func_177975_b((BlockPos)startPos.func_177982_a(-1, -1, -1), (BlockPos)startPos.func_177982_a(1, 1, 1))) {
            IBlockState lookingState = worldIn.func_180495_p((BlockPos)blockPos);
            Block lookingBlock = lookingState.func_177230_c();
            if (lookingBlock instanceof IMetaName || !lookingBlock.isWood((IBlockAccess)worldIn, (BlockPos)blockPos)) continue;
            BlockInfestationEvent event = new BlockInfestationEvent(worldIn, (BlockPos)blockPos, SRPBlocks.ParasiteTrunk.func_176223_P(), true, 0, false, false, true);
            boolean isCanceled = MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceledFully()) break;
            if (isCanceled || event.getState() == null) continue;
            worldIn.func_175656_a((BlockPos)blockPos, event.getState());
            if (!event.increasesPoints) continue;
            ++convertedCount;
        }
        if (convertedCount != 0) {
            blockParasiteCount += convertedCount;
            if (SRPConfigSystems.useEvolution) {
                SRPSaveData data = SRPSaveDataInterface.get(worldIn, null, startPos);
                byte lock = SRPMixinsConfigHandler.phasepoints.biomeSpreadingPenaltyPhase;
                if (lock < 0 || data.getEvolutionPhase(worldIn.field_73011_w.getDimension()) >= lock) {
                    data.setTotalKills(worldIn.field_73011_w.getDimension(), SRPConfigSystems.valueBlock * convertedCount, true, worldIn, true);
                }
            }
        }
    }

    static {
        srpmixins$listedBlocks = new HashSet<Block>();
    }
}

