/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.parabiome;

import com.dhanantry.scapeandrunparasites.block.BlockBiomePurifier;
import com.dhanantry.scapeandrunparasites.block.BlockInfestedRubble;
import com.dhanantry.scapeandrunparasites.block.BlockInfestedStain;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPStationaryArchitect;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import srpmixins.config.SRPMixinsConfigHandler;

@Mixin(value={BlockBiomePurifier.class})
public abstract class BiomePurifierTweak
extends Block {
    public BiomePurifierTweak(Material blockMaterialIn, MapColor blockMapColorIn) {
        super(blockMaterialIn, blockMapColorIn);
    }

    @Inject(method={"updateTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void srpmixins_dontTick(World worldIn, BlockPos pos, IBlockState state, Random rand, CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"onBlockActivated"}, at={@At(value="TAIL")})
    private void srpmixins_effectsOnActivate(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ, CallbackInfoReturnable<Boolean> cir) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (!worldIn.func_175697_a(pos, 3)) {
            return;
        }
        WorldServer world = (WorldServer)worldIn;
        HashSet<EntityParasiteBase> parasites = new HashSet<EntityParasiteBase>();
        HashSet<EntityPStationaryArchitect> nexus = new HashSet<EntityPStationaryArchitect>();
        ChunkPos cPos = new ChunkPos(pos);
        int chunkRange = SRPMixinsConfigHandler.parabiome.biomePurifPotionRange;
        for (int dx = -chunkRange; dx <= chunkRange; ++dx) {
            for (int dz = -chunkRange; dz <= chunkRange; ++dz) {
                int cx = cPos.field_77276_a + dx;
                int cz = cPos.field_77275_b + dz;
                if (!world.func_72863_F().func_73149_a(cx, cz)) continue;
                Chunk chunk = world.func_72964_e(cx, cz);
                for (ClassInheritanceMultiMap entityList : chunk.func_177429_s()) {
                    for (EntityParasiteBase para : entityList.func_180215_b(EntityParasiteBase.class)) {
                        parasites.add(para);
                        if (!(para instanceof EntityPStationaryArchitect)) continue;
                        nexus.add((EntityPStationaryArchitect)para);
                    }
                }
            }
        }
        for (EntityParasiteBase mob : parasites) {
            mob.func_70690_d(new PotionEffect(SRPPotions.RAGE_E, SRPMixinsConfigHandler.parabiome.biomePurifRageDuration, 1, false, false));
        }
        if (SRPMixinsConfigHandler.parabiome.biomePurifApplyGlowingToAll) {
            for (EntityPStationaryArchitect mob : nexus) {
                mob.func_70690_d(new PotionEffect(MobEffects.field_188423_x, SRPMixinsConfigHandler.parabiome.biomePurifGlowingDuration, 0, false, false));
            }
        } else {
            nexus.stream().findFirst().ifPresent(nex -> nex.func_70690_d(new PotionEffect(MobEffects.field_188423_x, SRPMixinsConfigHandler.parabiome.biomePurifGlowingDuration, 0, false, false)));
        }
    }

    public void func_180633_a(@Nonnull World worldIn, BlockPos startPos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        int purifyRange = SRPMixinsConfigHandler.parabiome.biomePurifReversionRange;
        for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)startPos.func_177982_a(-purifyRange, -purifyRange * 2, -purifyRange), (BlockPos)startPos.func_177982_a(purifyRange, purifyRange * 2, purifyRange))) {
            IBlockState iblockstate = worldIn.func_180495_p((BlockPos)pos);
            Block block = iblockstate.func_177230_c();
            if (block == SRPBlocks.InfestedStain) {
                worldIn.func_175656_a((BlockPos)pos, SRPBlocks.InfestedStain.func_176223_P().func_177226_a((IProperty)BlockInfestedStain.STAGE, (Comparable)Integer.valueOf(5)));
                worldIn.func_175654_a((BlockPos)pos, SRPBlocks.InfestedStain, 40, 5);
                continue;
            }
            if (block != SRPBlocks.InfestedRubble) continue;
            worldIn.func_175656_a((BlockPos)pos, SRPBlocks.InfestedRubble.func_176223_P().func_177226_a((IProperty)BlockInfestedRubble.STAGE, (Comparable)Integer.valueOf(5)));
            worldIn.func_175654_a((BlockPos)pos, SRPBlocks.InfestedRubble, 40, 5);
        }
    }
}

