/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.extraphases;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.HashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import srpmixins.config.providers.SRPMobConfigProvider;
import srpmixins.rules.ruleset.DespawnTimerRuleSet;
import srpmixins.util.customphasemechanics.SRPSaveDataInterface;

@Mixin(value={EntityParasiteBase.class})
public abstract class DespawnTimer
extends EntityLivingBase {
    @Unique
    private int srpmixins$despawnTimer = -1;

    public DespawnTimer(World worldIn) {
        super(worldIn);
    }

    @Shadow(remap=false)
    public abstract void cannotDespawn(boolean var1);

    @Shadow(remap=false)
    public abstract int getParasiteIDRegister();

    @ModifyReturnValue(method={"canDespawn"}, at={@At(value="RETURN")})
    private boolean srpmixins_allowDespawnAfterCertainTime(boolean original) {
        if (original) {
            return true;
        }
        if (this.srpmixins$despawnTimer == -1) {
            return original;
        }
        if (this.field_70173_aa > this.srpmixins$despawnTimer) {
            this.cannotDespawn(true);
            return true;
        }
        return original;
    }

    @Inject(method={"cannotDespawn"}, at={@At(value="TAIL")}, remap=false)
    private void srpmixins_allowDespawnAfterCertainTime(boolean newCanDespawnFlag, CallbackInfo ci) {
        if (newCanDespawnFlag) {
            return;
        }
        if (DespawnTimerRuleSet.INSTANCE.hasNoRules()) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int paraId = this.getParasiteIDRegister();
        int dimId = this.field_70170_p.field_73011_w.getDimension();
        HashMap<String, Object> actualValues = new HashMap<String, Object>();
        actualValues.put("dim", dimId);
        actualValues.put("phase", SRPSaveDataInterface.get(this.field_70170_p, null, this.func_180425_c()).getEvolutionPhase(dimId));
        actualValues.put("mob", paraId);
        actualValues.put("group", SRPMobConfigProvider.getParaGroup(paraId));
        int totalTimer = DespawnTimerRuleSet.INSTANCE.getTotalTimer(actualValues);
        if (totalTimer > 0) {
            this.srpmixins$despawnTimer = totalTimer;
        }
    }

    @Inject(method={"writeEntityToNBT"}, at={@At(value="TAIL")})
    private void writeTimerToNBT(NBTTagCompound compound, CallbackInfo ci) {
        if (this.srpmixins$despawnTimer > 0) {
            compound.func_74768_a("srpmixinsDespawnTimer", this.srpmixins$despawnTimer);
        }
    }

    @Inject(method={"readEntityFromNBT"}, at={@At(value="TAIL")})
    private void readTimerFromNBT(NBTTagCompound compound, CallbackInfo ci) {
        if (compound.func_74764_b("srpmixinsDespawnTimer")) {
            this.srpmixins$despawnTimer = compound.func_74762_e("srpmixinsDespawnTimer");
        }
    }
}

