/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.extraphases;

import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import srpmixins.config.SRPConfigProvider;
import srpmixins.rules.ruleset.MinMaxDayPerPhaseRuleSet;

@Mixin(value={SRPSaveData.class})
public abstract class DaysPerPhase
extends WorldSavedData {
    @Shadow(remap=false)
    private ArrayList<Integer> dimEPid;
    @Shadow(remap=false)
    private ArrayList<Byte> dimEPevolution;
    @Shadow(remap=false)
    private ArrayList<Integer> dimEPtotalKills;
    @Unique
    private final Map<Integer, Long> srpmixins$lastPhaseChangeTick = new HashMap<Integer, Long>();

    public DaysPerPhase(String name) {
        super(name);
    }

    @ModifyReturnValue(method={"writeToNBT"}, at={@At(value="TAIL")})
    private NBTTagCompound writeTicks(NBTTagCompound original) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Integer, Long> entry : this.srpmixins$lastPhaseChangeTick.entrySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("dimId", entry.getKey().intValue());
            nbt.func_74772_a("ticks", entry.getValue().longValue());
            list.func_74742_a((NBTBase)nbt);
        }
        original.func_74782_a("srpmixins_phaseTicks", (NBTBase)list);
        return original;
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void readTicks(NBTTagCompound compound, CallbackInfo ci) {
        if (!compound.func_74764_b("srpmixins_phaseTicks")) {
            return;
        }
        NBTTagList list = compound.func_150295_c("srpmixins_phaseTicks", 10);
        for (NBTBase nbt : list) {
            NBTTagCompound cmp = (NBTTagCompound)nbt;
            int dim = cmp.func_74762_e("dimId");
            long ticks = cmp.func_74763_f("ticks");
            this.srpmixins$lastPhaseChangeTick.put(dim, ticks);
        }
    }

    @Inject(method={"setTotalKills"}, at={@At(value="FIELD", target="Lcom/dhanantry/scapeandrunparasites/util/config/SRPConfigSystems;phaseTenTotalPoints:I", ordinal=0)}, remap=false)
    private void srpmixins_forceOrStopPhaseChange(int dimId, int addedPoints, boolean plus, World world, boolean canChangePhase, CallbackInfoReturnable<Boolean> cir, @Local(name={"kills"}) LocalIntRef pointsRef, @Local(argsOnly=true, ordinal=1) LocalBooleanRef canChangeRef) {
        if (!canChangePhase) {
            return;
        }
        if (!plus) {
            return;
        }
        if (addedPoints < 0) {
            return;
        }
        if (MinMaxDayPerPhaseRuleSet.INSTANCE.hasNoRules()) {
            return;
        }
        int idx = this.dimEPid.indexOf(dimId);
        if (idx == -1) {
            return;
        }
        byte currentPhase = this.dimEPevolution.get(idx);
        if (currentPhase >= SRPConfigProvider.getMaxPhase()) {
            return;
        }
        HashMap<String, Object> actualValues = new HashMap<String, Object>();
        actualValues.put("dim", dimId);
        actualValues.put("phase", currentPhase);
        int minDays = MinMaxDayPerPhaseRuleSet.INSTANCE.getTotalMin(actualValues);
        int maxDays = MinMaxDayPerPhaseRuleSet.INSTANCE.getTotalMax(actualValues);
        if (maxDays != 0 || minDays != Integer.MAX_VALUE) {
            long ticksElapsed = world.func_72820_D() - this.srpmixins$lastPhaseChangeTick.getOrDefault(dimId, 0L);
            int days = (int)(ticksElapsed / (long)SRPConfig.dayTickValue);
            int newPoints = SRPConfigProvider.getPhaseMinPoints((byte)(currentPhase + 1));
            if (minDays != Integer.MAX_VALUE && days < minDays && pointsRef.get() >= newPoints) {
                canChangeRef.set(false);
                pointsRef.set(newPoints - 1);
                this.dimEPtotalKills.set(idx, newPoints - 1);
            } else if (maxDays != 0 && days >= maxDays) {
                pointsRef.set(newPoints + 1);
                this.dimEPtotalKills.set(idx, newPoints + 1);
            }
        }
    }

    @Inject(method={"setEvolutionPhase"}, at={@At(value="INVOKE", target="Lcom/dhanantry/scapeandrunparasites/world/SRPSaveData;checkForUnlock(BILnet/minecraft/world/World;)V")}, remap=false)
    private void srpmixins_resetDays(int id, byte in, boolean override, World worldIn, boolean canChangePhase, CallbackInfoReturnable<Boolean> cir) {
        this.srpmixins$lastPhaseChangeTick.put(id, worldIn.func_72820_D());
    }
}

