/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.deterrenttweaks;

import com.dhanantry.scapeandrunparasites.block.BlockBase;
import com.dhanantry.scapeandrunparasites.block.BlockInfestedRubble;
import com.dhanantry.scapeandrunparasites.block.BlockInfestedStain;
import com.dhanantry.scapeandrunparasites.block.IMetaName;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPStationaryArchitect;
import com.dhanantry.scapeandrunparasites.entity.monster.deterrent.nexus.EntityVenkrol;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventWorld;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigMobs;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigWorld;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import srpmixins.compat.CompatUtil;
import srpmixins.compat.CotesiaCompat;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.event.BlockInfestationEvent;
import srpmixins.util.customphasemechanics.SRPSaveDataInterface;

@Mixin(value={ParasiteEventWorld.class})
public abstract class InfestationOverhaul {
    @Shadow(remap=false)
    public static int blockInfestedCount;
    @Unique
    private static final Set<Block> srpmixins$listedBlocks;

    @Shadow(remap=false)
    public static void spawnGenFeatureInfested(World worldIn, BlockPos pos, Random rand) {
    }

    @Shadow(remap=false)
    public static void spawnGenRoofInfested(World worldIn, BlockPos pos, Random rand) {
    }

    @Overwrite(remap=false)
    public static void canInfestBlock(World worldIn, BlockPos startPos, Random rand, int beckonStage, boolean alwaysTrue) {
        if (beckonStage >= 4) {
            InfestationOverhaul.srpmixins$infestationReversionLogic(worldIn, startPos, beckonStage);
            return;
        }
        if (blockInfestedCount > SRPConfig.BlockInfestedLimit) {
            return;
        }
        if (worldIn.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return;
        }
        boolean canAffectRock = beckonStage >= 2;
        int convertedCount = 0;
        int maxPivotLvl = 0;
        int range = SRPConfigMobs.venkrolsiiiRange - 1;
        int rangeY = SRPConfigMobs.venkrolsiiiRangeY;
        if (SRPMixinsConfigHandler.deterrents.fixInfestedBlockLimit) {
            switch (beckonStage) {
                case 1: {
                    range = SRPConfigMobs.venkrolRange - 1;
                    rangeY = SRPConfigMobs.venkrolRangeY;
                    break;
                }
                case 2: {
                    range = SRPConfigMobs.venkrolsiiRange - 1;
                    rangeY = SRPConfigMobs.venkrolsiiRangeY;
                }
            }
        }
        BlockPos blockPosAbove = startPos.func_177984_a();
        Block blockAboveStartPos = worldIn.func_180495_p(blockPosAbove).func_177230_c();
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(startPos).func_72314_b((double)(range + 1), (double)(rangeY + 1), (double)(range + 1));
        List moblist = worldIn.func_72872_a(EntityPStationaryArchitect.class, axisalignedbb);
        if (alwaysTrue) {
            if (moblist.isEmpty()) {
                InfestationOverhaul.srpmixins$trySpawnBeckon(worldIn, beckonStage, startPos, blockPosAbove, blockAboveStartPos);
                return;
            }
            boolean anyBeckonInDarkness = false;
            double distSqToNearestBeckon = range * range + 1;
            for (EntityPStationaryArchitect mob : moblist) {
                if (mob.func_70644_a(SRPPotions.PIVOT_E)) {
                    maxPivotLvl = Math.max(mob.func_70660_b(SRPPotions.PIVOT_E).func_76458_c() + 1, maxPivotLvl);
                }
                if (mob.getStageV() < beckonStage || anyBeckonInDarkness) continue;
                BlockPos venPosUp = mob.func_180425_c().func_177984_a();
                if (SRPMixinsConfigHandler.deterrents.infestationAreaIsCircular) {
                    distSqToNearestBeckon = Math.min(distSqToNearestBeckon, startPos.func_177951_i((Vec3i)mob.func_180425_c()));
                }
                if (!(worldIn.func_175724_o(venPosUp) < (float)SRPConfigSystems.rsBlockLight / 15.0f) || worldIn.func_175642_b(EnumSkyBlock.BLOCK, venPosUp) >= SRPConfigSystems.rsBlockLight) continue;
                anyBeckonInDarkness = true;
            }
            if (!anyBeckonInDarkness || SRPMixinsConfigHandler.deterrents.infestationAreaIsCircular && distSqToNearestBeckon > (double)(range * range)) {
                return;
            }
        }
        IBlockState stain = SRPBlocks.InfestedStain.func_176223_P().func_177226_a((IProperty)BlockInfestedStain.STAGE, (Comparable)Integer.valueOf(beckonStage));
        IBlockState rubble = SRPBlocks.InfestedRubble.func_176223_P().func_177226_a((IProperty)BlockInfestedRubble.STAGE, (Comparable)Integer.valueOf(beckonStage));
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (EnumFacing facing : EnumFacing.values()) {
            Block block;
            blockPos.func_189533_g((Vec3i)startPos).func_189536_c(facing);
            IBlockState state = worldIn.func_180495_p((BlockPos)blockPos);
            Material material = state.func_185904_a();
            if (material == Material.field_151579_a || (block = state.func_177230_c()) instanceof IMetaName) continue;
            IBlockState newState = material == Material.field_151576_e ? rubble : stain;
            boolean generatesAbove = false;
            boolean generatesBelow = false;
            boolean increasesPoints = true;
            IBlockState resultState = null;
            if (block instanceof BlockBase) {
                if (block == SRPBlocks.BiomeHeart || block == SRPBlocks.ColonyHeart || material != Material.field_151578_c && material != Material.field_151576_e) continue;
                int storedStage = block.func_176201_c(state);
                if (beckonStage > storedStage && (material != Material.field_151576_e || canAffectRock)) {
                    resultState = newState;
                }
                increasesPoints = false;
            } else if (!InfestationOverhaul.srpmixins$blockIsBlacklistedForInfestation(worldIn, (BlockPos)blockPos, block, state)) {
                if (block.isWood((IBlockAccess)worldIn, (BlockPos)blockPos)) {
                    resultState = SRPBlocks.InfestedTrunk.func_176223_P();
                } else if (material == Material.field_151578_c || material == Material.field_151577_b || material == Material.field_151595_p || material == Material.field_151576_e && canAffectRock) {
                    resultState = newState;
                    generatesAbove = true;
                    generatesBelow = true;
                }
            }
            BlockInfestationEvent event = new BlockInfestationEvent(worldIn, startPos, resultState, false, beckonStage, generatesAbove, generatesBelow, increasesPoints).setFacing(facing);
            boolean isCanceled = MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceledFully()) break;
            if (isCanceled || event.getState() == null) continue;
            worldIn.func_175656_a((BlockPos)blockPos, event.getState());
            if (event.increasesPoints) {
                ++convertedCount;
            }
            if (event.generatesAbove) {
                InfestationOverhaul.spawnGenFeatureInfested(worldIn, blockPos.func_177984_a(), rand);
            }
            if (!event.generatesBelow) continue;
            InfestationOverhaul.spawnGenRoofInfested(worldIn, blockPos.func_177977_b(), rand);
        }
        if (convertedCount != 0) {
            blockInfestedCount += convertedCount;
            if (SRPConfigSystems.useEvolution) {
                SRPSaveData data = SRPSaveDataInterface.get(worldIn, null, startPos);
                int dimId = worldIn.field_73011_w.getDimension();
                if (SRPMixinsConfigHandler.phasepoints.infestationPenaltyPhase >= 0 && data.getEvolutionPhase(dimId) < SRPMixinsConfigHandler.phasepoints.infestationPenaltyPhase) {
                    return;
                }
                int pointsToAdd = SRPConfigSystems.valueBlock * convertedCount;
                if (maxPivotLvl != 0) {
                    pointsToAdd *= SRPConfigSystems.pivotPointMultiplier * maxPivotLvl;
                }
                if (CompatUtil.cotesia.isLoaded()) {
                    CotesiaCompat.countInfestationPointsToPlayer(data, dimId, pointsToAdd, true, worldIn, true, true);
                }
                data.setTotalKills(dimId, pointsToAdd, true, worldIn, true);
            }
        }
    }

    @Unique
    private static void srpmixins$infestationReversionLogic(World worldIn, BlockPos startPos, int beckonStage) {
        BlockPos blockPosAbove = startPos.func_177984_a();
        Block blockAboveStartPos = worldIn.func_180495_p(blockPosAbove).func_177230_c();
        IBlockState stain = SRPBlocks.InfestedStain.func_176223_P().func_177226_a((IProperty)BlockInfestedStain.STAGE, (Comparable)Integer.valueOf(beckonStage));
        IBlockState rubble = SRPBlocks.InfestedRubble.func_176223_P().func_177226_a((IProperty)BlockInfestedRubble.STAGE, (Comparable)Integer.valueOf(beckonStage));
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (EnumFacing facing : EnumFacing.values()) {
            Block block;
            blockPos.func_189533_g((Vec3i)startPos).func_189536_c(facing);
            IBlockState state = worldIn.func_180495_p((BlockPos)blockPos);
            Material material = state.func_185904_a();
            if (material == Material.field_151579_a || (block = state.func_177230_c()) instanceof IMetaName || !(block instanceof BlockBase) || material != Material.field_151578_c && material != Material.field_151576_e || block == SRPBlocks.BiomeHeart || block == SRPBlocks.ColonyHeart) continue;
            IBlockState newState = material == Material.field_151576_e ? rubble : stain;
            worldIn.func_175656_a((BlockPos)blockPos, newState);
            worldIn.func_175654_a((BlockPos)blockPos, newState.func_177230_c(), 40, 5);
        }
        Block blockAtStartPos = worldIn.func_180495_p(startPos).func_177230_c();
        if (blockAtStartPos == SRPBlocks.InfestedStain) {
            worldIn.func_175656_a(startPos, SRPBlocks.optionalDirt.func_176223_P());
        } else if (blockAtStartPos == SRPBlocks.InfestedRubble) {
            worldIn.func_175656_a(startPos, SRPBlocks.optionalRub.func_176223_P());
        }
        if (blockAboveStartPos == Blocks.field_150350_a || blockAboveStartPos == SRPBlocks.InfestedBush) {
            worldIn.func_175656_a(blockPosAbove, SRPBlocks.InfestRemain.func_176223_P());
        }
    }

    @Unique
    private static void srpmixins$trySpawnBeckon(World worldIn, int beckonStage, BlockPos startPos, BlockPos blockPosAbove, Block blockAboveStartPos) {
        if (beckonStage == 1) {
            return;
        }
        if (worldIn.field_73012_v.nextDouble() >= SRPConfigSystems.rsVenkrolEmpty) {
            return;
        }
        if (blockAboveStartPos != Blocks.field_150350_a && !(blockAboveStartPos instanceof BlockBush)) {
            return;
        }
        if (worldIn.func_175724_o(blockPosAbove) > 0.46666667f) {
            return;
        }
        if (worldIn.func_175642_b(EnumSkyBlock.BLOCK, blockPosAbove) > 7) {
            return;
        }
        EntityVenkrol newBeckon = new EntityVenkrol(worldIn);
        newBeckon.func_70012_b((double)startPos.func_177958_n(), (double)(startPos.func_177956_o() + 1), (double)startPos.func_177952_p(), 0.0f, 0.0f);
        worldIn.func_72838_d((Entity)newBeckon);
        newBeckon.cannotDespawn(true);
        if (CompatUtil.cotesia.isLoaded()) {
            CotesiaCompat.handleSpawnedBeckon(worldIn, true, newBeckon);
        }
    }

    @Unique
    private static boolean srpmixins$blockIsBlacklistedForInfestation(World worldIn, BlockPos pos, Block block, IBlockState state) {
        float hardness = state.func_185887_b(worldIn, pos);
        if (hardness < 0.0f || hardness > SRPConfigSystems.rsBlockIMaxH) {
            return true;
        }
        if (!state.func_185917_h() || block.func_176205_b((IBlockAccess)worldIn, pos) || block instanceof BlockBreakable || block instanceof BlockContainer || block instanceof BlockHorizontal || block instanceof BlockTNT || block instanceof IPlantable || block instanceof BlockMobSpawner) {
            return true;
        }
        if (srpmixins$listedBlocks.contains(block)) {
            return !SRPConfigSystems.blockBListWhite;
        }
        ResourceLocation loc = block.getRegistryName();
        if (loc == null) {
            return SRPConfigSystems.blockBListWhite;
        }
        String blockName = loc.toString();
        boolean isInList = Arrays.stream(SRPConfigSystems.blockBList).anyMatch(blockName::contains);
        if (isInList) {
            srpmixins$listedBlocks.add(block);
        }
        return isInList != SRPConfigWorld.blockBBiomeListWhite;
    }

    static {
        srpmixins$listedBlocks = new HashSet<Block>();
    }
}

