/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.customphases;

import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import srpmixins.SRPMixins;
import srpmixins.config.SRPConfigProvider;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.mixin.customphases.SRPSaveDataAccessor;
import srpmixins.network.PhaseWarningOverhaul;
import srpmixins.util.customphasemechanics.SRPSaveDataInterface;
import srpmixins.util.customphasemechanics.SRPSaveDataPlayerLegacyPatch;

@Mixin(value={SRPSaveData.class})
public abstract class SRPSaveDataMixin
implements SRPSaveDataInterface {
    @Unique
    private UUID srpmixins$playerUUID;
    @Unique
    private static final String srpmixins$legacyDontReadKey = "srpmixins_legacydata_dont_read";
    @Unique
    private boolean srpmixins$isLegacyPerDimSaveData = false;

    @Override
    public void srpmixins$setUUID(UUID uuid) {
        this.srpmixins$playerUUID = uuid;
    }

    @Override
    public UUID srpmixins$getUUID() {
        return this.srpmixins$playerUUID;
    }

    @Unique
    private static SRPSaveData srpmixins$createForPlayer(World world, UUID playerUUID, MapStorage storage) {
        SRPMixins.LOGGER.info("Creating new SRPSaveData for dim{} and player{}", (Object)world.field_73011_w.getDimension(), (Object)playerUUID.toString());
        String dataName = "srparasites_global_data" + playerUUID;
        SRPSaveData instance = new SRPSaveData(dataName);
        storage.func_75745_a(dataName, (WorldSavedData)instance);
        instance.getLockedList().addAll(SRPConfigProvider.lockedParasites);
        for (Map.Entry<Integer, List<Integer>> entry : SRPConfigProvider.evolutionStartPerDimension.entrySet()) {
            int dim = entry.getKey();
            int phase = entry.getValue().get(0);
            int points = entry.getValue().get(1);
            SRPSaveDataMixin.srpmixins$addDim(instance, dim);
            instance.setEvolutionPhase(dim, (byte)phase, true, world, true);
            if (phase == -2) {
                instance.setGaining(false, dim);
                instance.setLoss(true, dim);
                continue;
            }
            if (phase == -1) {
                instance.setTotalKills(dim, -points, false, world, true);
                continue;
            }
            instance.setTotalKills(dim, points, false, world, true);
        }
        Iterator<Object> iterator = ((SRPSaveDataAccessor)instance).getDimEPid().iterator();
        while (iterator.hasNext()) {
            int dim;
            boolean dimIsInList;
            if (!SRPConfigSystems.evolutionDimGainInverted == (dimIsInList = SRPConfigProvider.dimensionCanGainPointsBlacklist.contains(dim = ((Integer)iterator.next()).intValue()))) {
                instance.setGaining(false, dim);
            }
            if (!SRPConfigSystems.evolutionDimLossInverted != (dimIsInList = SRPConfigProvider.dimensionCantLosePointsBlacklist.contains(dim))) continue;
            instance.setLoss(true, dim);
        }
        instance.func_76185_a();
        return instance;
    }

    @Unique
    private static void srpmixins$addDim(SRPSaveData instance, int id) {
        if (((SRPSaveDataAccessor)instance).getDimEPid().contains(id)) {
            return;
        }
        ((SRPSaveDataAccessor)instance).getDimEPid().add(id);
        ((SRPSaveDataAccessor)instance).getDimEPcanGainPoints().add(true);
        ((SRPSaveDataAccessor)instance).getDimEPcanLossPoints().add(false);
        ((SRPSaveDataAccessor)instance).getDimEPevolution().add(SRPConfigSystems.defaultEvoPhase);
        ((SRPSaveDataAccessor)instance).getDimEPtimeEvolution().add(0);
        ((SRPSaveDataAccessor)instance).getDimEPtotalKills().add(SRPConfigSystems.defaultEvoPoints);
    }

    @Override
    public SRPSaveData srpmixins$getByPlayer(World world, UUID playerUUID) {
        if (playerUUID != null) {
            MapStorage storage = world.func_175693_T();
            SRPSaveData instancePlayer = (SRPSaveData)storage.func_75742_a(SRPSaveData.class, "srparasites_global_data" + playerUUID);
            if (instancePlayer == null) {
                instancePlayer = SRPSaveDataMixin.srpmixins$createForPlayer(world, playerUUID, storage);
            }
            SRPSaveDataMixin.srpmixins$patchIfAvailable(world, playerUUID, instancePlayer);
            ((SRPSaveDataInterface)instancePlayer).srpmixins$setUUID(playerUUID);
            return instancePlayer;
        }
        if (SRPMixinsConfigHandler.playerphases.playerPhaseDebugMode) {
            SRPMixins.LOGGER.warn("SRPMixins Debug Mode: getByPlayer didnt find player");
        }
        return SRPSaveData.get((World)world);
    }

    @Override
    public SRPSaveData srpmixins$getByBlock(World world, BlockPos blockPos) {
        if (!world.field_73010_i.isEmpty()) {
            if (blockPos != null) {
                int z;
                int y;
                int x = blockPos.func_177958_n();
                EntityPlayer player = this.srpmixins$getClosestPlayer(world, x, y = blockPos.func_177956_o(), z = blockPos.func_177952_p(), 256.0);
                if (player != null) {
                    return this.srpmixins$getByPlayer(world, player.func_110124_au());
                }
                if (SRPMixinsConfigHandler.playerphases.playerPhaseDebugMode) {
                    SRPMixins.LOGGER.warn("SRPMixins Debug Mode: getByBlock didnt find player {}", (Object)blockPos);
                }
            } else if (SRPMixinsConfigHandler.playerphases.playerPhaseDebugMode) {
                SRPMixins.LOGGER.warn("SRPMixins Debug Mode: getByBlock didnt find blockpos");
            }
            if (SRPMixinsConfigHandler.playerphases.playerPhaseDebugMode) {
                try {
                    throw new Exception("SRPMixins Debug Mode - Stack Trace");
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
        }
        return SRPSaveData.get((World)world);
    }

    @Unique
    public EntityPlayer srpmixins$getClosestPlayer(World world, double x, double y, double z, double maxDist) {
        double minDist = -1.0;
        EntityPlayer closestPlayer = null;
        for (EntityPlayer player : world.field_73010_i) {
            if (player.func_175149_v()) continue;
            double currDistXZ = this.srpmixins$distSq(player, x, z);
            double currDist = player.func_70092_e(x, y, z);
            if (!(maxDist < 0.0) && !(currDistXZ < maxDist * maxDist) || minDist != -1.0 && !(currDist < minDist)) continue;
            minDist = currDist;
            closestPlayer = player;
        }
        return closestPlayer;
    }

    @Unique
    private double srpmixins$distSq(EntityPlayer player, double x, double z) {
        double xD = Math.abs(player.field_70165_t - x);
        double zD = Math.abs(player.field_70161_v - z);
        return Math.max(xD, zD);
    }

    @WrapWithCondition(method={"checkKills"}, at={@At(value="INVOKE", target="Lcom/dhanantry/scapeandrunparasites/util/ParasiteEventEntity;alertAllPlayerDim(Lnet/minecraft/world/World;Ljava/lang/String;I)V")}, remap=false)
    private boolean srpmixins_sendWarningToOnePlayer(World world, String message, int warning) {
        PhaseWarningOverhaul.alertOnePlayer(world, this.srpmixins$playerUUID, message, warning);
        return false;
    }

    @WrapWithCondition(method={"checkForUnlock"}, at={@At(value="INVOKE", target="Lcom/dhanantry/scapeandrunparasites/util/ParasiteEventEntity;alertAllPlayerSer(Ljava/lang/String;Lnet/minecraft/world/World;)V")}, remap=false)
    private boolean srpmixins_sendParaUnlockMessageToOnePlayer(String message, World world, @Local(name={"id"}) int paraId) {
        PhaseWarningOverhaul.sendUnlockMessage(world, this.srpmixins$getUUID(), message, paraId);
        return false;
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void srpmixins_readLegacyTag(NBTTagCompound compound, CallbackInfo ci) {
        if (compound.func_74764_b(srpmixins$legacyDontReadKey)) {
            this.srpmixins$isLegacyPerDimSaveData = true;
        }
    }

    @Inject(method={"writeToNBT"}, at={@At(value="TAIL")})
    private void srpmixins_writeLegacyTag(NBTTagCompound compound, CallbackInfoReturnable<NBTTagCompound> cir) {
        if (this.srpmixins$isLegacyPerDimSaveData) {
            compound.func_74757_a(srpmixins$legacyDontReadKey, true);
        }
    }

    @Override
    public boolean srpmixins$getIsLegacy() {
        return this.srpmixins$isLegacyPerDimSaveData;
    }

    @Override
    public void srpmixins$setIsLegacy() {
        this.srpmixins$isLegacyPerDimSaveData = true;
    }

    @Unique
    private static void srpmixins$patchIfAvailable(World world, UUID playerUUID, SRPSaveData actualData) {
        MapStorage storagePerWorld;
        SRPSaveData instancePlayerLegacy;
        int dimId = world.field_73011_w.getDimension();
        if (SRPMixinsConfigHandler.playerphases.playerPhaseLegacyPatch && dimId != 0 && (instancePlayerLegacy = (SRPSaveData)(storagePerWorld = world.getPerWorldStorage()).func_75742_a(SRPSaveData.class, "srparasites_global_data" + playerUUID)) != null && !((SRPSaveDataInterface)instancePlayerLegacy).srpmixins$getIsLegacy()) {
            ((SRPSaveDataInterface)instancePlayerLegacy).srpmixins$setIsLegacy();
            instancePlayerLegacy.func_76185_a();
            new SRPSaveDataPlayerLegacyPatch(dimId, (SRPSaveDataAccessor)instancePlayerLegacy).patchWithLegacyData((SRPSaveDataAccessor)actualData);
            actualData.func_76185_a();
        }
    }
}

