/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.configreroute.morephases;

import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.UUID;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import srpmixins.SRPMixinsPlugin;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.network.PhaseWarningOverhaul;
import srpmixins.util.customphasemechanics.SRPSaveDataInterface;

@Mixin(value={SRPSaveData.class})
public abstract class SRPSaveDataMixin {
    @Shadow(remap=false)
    public abstract byte getEvolutionPhase(int var1);

    @Shadow(remap=false)
    public abstract boolean setEvolutionPhase(int var1, byte var2, boolean var3, World var4, boolean var5);

    @Shadow(remap=false)
    public abstract boolean setTotalKills(int var1, int var2, boolean var3, World var4, boolean var5);

    @WrapMethod(method={"checkKills"}, remap=false)
    private boolean srpmixins_checkKills(int dimId, int currPoints, World worldIn, boolean canChangePhase, Operation<Boolean> original) {
        UUID playerUUID;
        byte currPhase = this.getEvolutionPhase(dimId);
        UUID uUID = playerUUID = SRPMixinsPlugin.areCustomPhasesEnabled() ? ((SRPSaveDataInterface)((Object)this)).srpmixins$getUUID() : null;
        if (currPhase >= -1 && currPhase < SRPMixinsConfigHandler.morephases.maxEvolutionPhase && currPoints >= SRPMixinsConfigHandler.morephases.phaseKills[currPhase + 1]) {
            if (this.setEvolutionPhase(dimId, (byte)(currPhase + 1), false, worldIn, canChangePhase)) {
                PhaseWarningOverhaul.alertOnePlayer(worldIn, playerUUID, SRPMixinsConfigHandler.morephases.phaseWarning[currPhase + 1], currPhase + 1);
                return false;
            }
        } else if (currPhase > 0 && currPhase <= SRPMixinsConfigHandler.morephases.maxEvolutionPhase && currPoints < SRPMixinsConfigHandler.morephases.phaseKills[currPhase] && this.setEvolutionPhase(dimId, (byte)(currPhase - 1), false, worldIn, canChangePhase)) {
            PhaseWarningOverhaul.alertOnePlayer(worldIn, playerUUID, "Phase decreased", -7);
            return true;
        }
        return false;
    }

    @WrapMethod(method={"checkPhase"}, remap=false)
    private void srpmixins_checkPhase(int dimId, byte phase, World worldIn, Operation<Void> original) {
        if (phase == -1) {
            this.setTotalKills(dimId, -10, false, worldIn, true);
        } else if (phase >= 0 && phase <= SRPMixinsConfigHandler.morephases.maxEvolutionPhase) {
            this.setTotalKills(dimId, SRPMixinsConfigHandler.morephases.phaseKills[phase], false, worldIn, true);
        }
    }

    @WrapMethod(method={"getDelay"}, remap=false)
    private int srpmixins_getDelay(byte phase, Operation<Integer> original) {
        if (phase < 0 || phase > SRPMixinsConfigHandler.morephases.maxEvolutionPhase) {
            return 0;
        }
        return SRPMixinsConfigHandler.morephases.phaseDelayTicks[phase];
    }
}

