/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.configparsefix;

import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import srpmixins.SRPMixins;

@Mixin(value={SRPPotions.class})
public abstract class SRPPotionsMixin {
    @Unique
    private static Map<String, Integer> srpmixins$maxAmpMap = null;
    @Unique
    private static final String[] srpmixins$emptyList = new String[]{"", ""};

    @Unique
    private static Integer srpmixins$getMaxAmp(String potionName) {
        if (srpmixins$maxAmpMap == null) {
            srpmixins$maxAmpMap = new HashMap<String, Integer>();
            for (String s : SRPConfig.stackablePotionsLimit) {
                String[] split = s.split(";");
                if (split.length < 2) {
                    SRPMixins.LOGGER.warn("SRPMixins unable to parse SRP potion max amplifier entry, expected pattern: modid:potionname; max amplifier, provided was: {}", (Object)s);
                    continue;
                }
                try {
                    srpmixins$maxAmpMap.put(split[0].trim(), Integer.parseInt(split[1].trim()));
                }
                catch (Exception e) {
                    SRPMixins.LOGGER.warn("SRPMixins unable to parse SRP potion max amplifier entry, expected number after semicolon, provided was {}", (Object)s);
                }
            }
        }
        return srpmixins$maxAmpMap.get(potionName);
    }

    @Redirect(method={"applyStackPotion"}, at=@At(value="FIELD", target="Lcom/dhanantry/scapeandrunparasites/util/config/SRPConfig;stackablePotionsLimit:[Ljava/lang/String;", opcode=190, args={"array=length"}), remap=false)
    private static int srpmixins_onlyLoopOnce(String[] array) {
        return Math.min(array.length, 1);
    }

    @WrapOperation(method={"applyStackPotion"}, at={@At(value="INVOKE", target="Ljava/lang/String;split(Ljava/lang/String;)[Ljava/lang/String;")}, remap=false)
    private static String[] srpmixins_dontSplitList(String instance, String regex, Operation<String[]> original, @Local(name={"name"}) String potionName) {
        Integer maxAmp = SRPPotionsMixin.srpmixins$getMaxAmp(potionName);
        if (maxAmp != null) {
            return new String[]{potionName, ""};
        }
        return srpmixins$emptyList;
    }

    @WrapOperation(method={"applyStackPotion"}, at={@At(value="INVOKE", target="Ljava/lang/Integer;parseInt(Ljava/lang/String;)I")}, remap=false)
    private static int srpmixins_dontParseMaxAmp(String instance, Operation<Integer> original, @Local(name={"name"}) String potionName) {
        return SRPPotionsMixin.srpmixins$getMaxAmp(potionName);
    }
}

