/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.configparsefix;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import srpmixins.config.SRPConfigProvider;
import srpmixins.util.configparse.ParaOrbEffect;

@Mixin(value={ParasiteEventEntity.class})
public abstract class ParasiteEventEntityMixin_OrbEffects {
    @Inject(method={"orbApplyEffects"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void srpmixins_orbApplyEffects(EntityLivingBase target, EntityParasiteBase orbCreator, String[] unused, int mobCount, CallbackInfo ci) {
        List<ParaOrbEffect> orbEffects = SRPConfigProvider.orbEffects.get(orbCreator.getParasiteIDRegister());
        if (orbEffects == null) {
            return;
        }
        boolean targetIsPara = target instanceof EntityParasiteBase;
        block4: for (ParaOrbEffect orbEffect : orbEffects) {
            int duration = orbEffect.effect.func_76459_b();
            int amp = orbEffect.effect.func_76458_c();
            Potion potion = orbEffect.effect.func_188419_a();
            if (orbEffect.mobDivisorAmplifier != 0) {
                amp += mobCount / orbEffect.mobDivisorAmplifier;
            }
            if (orbEffect.mobDivisorDuration != 0) {
                duration += mobCount / orbEffect.mobDivisorDuration * 20;
            }
            switch (orbEffect.applicationMode) {
                case 1: {
                    orbCreator.func_70690_d(new PotionEffect(potion, duration, amp, false, false));
                    continue block4;
                }
                case 2: {
                    if (!targetIsPara) continue block4;
                    SRPPotions.applyStackPotion((Potion)potion, (EntityLivingBase)target, (int)duration, (int)amp);
                    continue block4;
                }
            }
            if (targetIsPara) continue;
            SRPPotions.applyStackPotion((Potion)potion, (EntityLivingBase)target, (int)duration, (int)amp);
        }
        ci.cancel();
    }
}

