/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.configparsefix;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import srpmixins.SRPMixins;

@Mixin(value={EntityParasiteBase.class})
public abstract class EntityParasiteBaseMixin_DamageWeakness {
    @Unique
    private static Map<String, Float> srpmixins$parasiteWeakToItems = null;
    @Unique
    private static Map<String, Float> srpmixins$parasiteWeakToMobs = null;
    @Unique
    private static Map<String, Float> srpmixins$parasiteWeakToElse = null;

    @Unique
    private static float srpmixins$getMultiplier(String damageName, int type) {
        switch (type) {
            case 1: {
                if (srpmixins$parasiteWeakToItems == null) {
                    srpmixins$parasiteWeakToItems = EntityParasiteBaseMixin_DamageWeakness.srpmixins$parseWeaknessList(SRPConfig.parasiteWeakToItems);
                }
                return srpmixins$parasiteWeakToItems.getOrDefault(damageName, Float.valueOf(1.0f)).floatValue();
            }
            case 2: {
                if (srpmixins$parasiteWeakToMobs == null) {
                    srpmixins$parasiteWeakToMobs = EntityParasiteBaseMixin_DamageWeakness.srpmixins$parseWeaknessList(SRPConfig.parasiteWeakToMobs);
                }
                return srpmixins$parasiteWeakToMobs.getOrDefault(damageName, Float.valueOf(1.0f)).floatValue();
            }
            case 3: {
                if (srpmixins$parasiteWeakToElse == null) {
                    srpmixins$parasiteWeakToElse = EntityParasiteBaseMixin_DamageWeakness.srpmixins$parseWeaknessList(SRPConfig.parasiteWeakToElse);
                }
                return srpmixins$parasiteWeakToElse.getOrDefault(damageName, Float.valueOf(1.0f)).floatValue();
            }
        }
        return 1.0f;
    }

    @Unique
    private static Map<String, Float> srpmixins$parseWeaknessList(String[] list) {
        HashMap<String, Float> map = new HashMap<String, Float>();
        for (String s : list) {
            String[] split = s.split(";");
            if (split.length < 2) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse SRP parasite weakness list entry, expected pattern: damage type; multiplier, provided was: {}", (Object)s);
                continue;
            }
            try {
                String dmgName = split[0].trim();
                float multi = Float.parseFloat(split[1].trim());
                map.put(dmgName, Float.valueOf(multi));
            }
            catch (Exception e) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse SRP parasite weakness list entry, expected number after semicolon, provided was: {}", (Object)s);
            }
        }
        return map;
    }

    @ModifyVariable(method={"attackEntityFrom"}, at=@At(value="LOAD", ordinal=1), name={"flagWeak"})
    private boolean srpmixins_overwriteDamageWeakness(boolean value, @Local(argsOnly=true) LocalFloatRef amount, @Local(name={"damageName"}) String damageName, @Local(name={"naniDesu"}) byte damageType) {
        amount.set(amount.get() * EntityParasiteBaseMixin_DamageWeakness.srpmixins$getMultiplier(damageName, damageType));
        return false;
    }
}

