/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.handlers;

import com.dhanantry.scapeandrunparasites.entity.EntityParasiticScent;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPStationaryArchitect;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityAta;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfEnderman;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfSquid;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.head.EntityInfEndermanHead;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityLum;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import com.dhanantry.scapeandrunparasites.world.SRPWorldData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import srpmixins.compat.CompatUtil;
import srpmixins.compat.SRPExtraCompat;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.event.WorldMobCapEvent;
import srpmixins.rules.ruleset.MobCapRuleSet;
import srpmixins.util.ParasiteCreatureType;
import srpmixins.util.customphasemechanics.SRPSaveDataInterface;

public class WorldMobCapHandler {
    public static final Map<Integer, Integer> nexusCount = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> waterCount = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> gnatCount = new HashMap<Integer, Integer>();
    public static final Map<Integer, Integer> scentCount = new HashMap<Integer, Integer>();
    public static int end_simmermanCount = 0;

    @SubscribeEvent
    public static void onSetMobCap(WorldMobCapEvent event) {
        int dimId = event.getWorld().field_73011_w.getDimension();
        if (event.getType() != ParasiteCreatureType.PARASITE) {
            if (!SRPMixinsConfigHandler.playerphases.enabled && !SRPMixinsConfigHandler.chunkphases.enabled && SRPSaveData.get((World)event.getWorld()).getEvolutionPhase(dimId) >= SRPConfigSystems.evolutionNoParasiteSpawnDenied) {
                event.setMobCap(0);
            }
            return;
        }
        if (MobCapRuleSet.INSTANCE.hasNoRules()) {
            return;
        }
        HashMap<String, Object> actualValues = new HashMap<String, Object>();
        actualValues.put("dim", dimId);
        actualValues.put("nodes", SRPWorldData.get((World)event.getWorld()).getNodes("x").size());
        double multi = 0.0;
        if (SRPMixinsConfigHandler.playerphases.enabled) {
            int counter = 0;
            for (EntityPlayer player : event.getWorld().field_73010_i) {
                if (player.func_175149_v()) continue;
                actualValues.put("phase", SRPSaveDataInterface.get(event.getWorld(), player, null).getEvolutionPhase(dimId));
                multi += MobCapRuleSet.INSTANCE.getTotalMulti(actualValues);
                ++counter;
            }
            multi = counter != 0 ? (multi /= (double)counter) : 1.0;
        } else if (SRPMixinsConfigHandler.chunkphases.enabled) {
            int counter = 0;
            for (ChunkPos pos : event.getEligibleChunks()) {
                actualValues.put("phase", SRPSaveDataInterface.get(event.getWorld(), null, pos.func_180331_a(8, 0, 8)).getEvolutionPhase(dimId));
                multi += MobCapRuleSet.INSTANCE.getTotalMulti(actualValues);
                ++counter;
            }
            multi = counter != 0 ? (multi /= (double)counter) : 1.0;
        } else {
            actualValues.put("phase", SRPSaveData.get((World)event.getWorld()).getEvolutionPhase(dimId));
            multi = MobCapRuleSet.INSTANCE.getTotalMulti(actualValues);
        }
        if (multi != 1.0) {
            event.setMobCap((int)((double)event.getMobCap() * multi));
        }
    }

    @SubscribeEvent
    public static void onWorldServerTick(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        int dimId = event.world.field_73011_w.getDimension();
        if (SRPMixinsConfigHandler.deterrents.nexusCap >= 0) {
            nexusCount.put(dimId, event.world.func_72907_a(EntityPStationaryArchitect.class));
        }
        if (SRPMixinsConfigHandler.waterparas.waterParasiteCap >= 0) {
            waterCount.put(dimId, event.world.func_72907_a(EntityInfSquid.class) + event.world.func_72907_a(EntityLum.class) + (CompatUtil.srpextra.isLoaded() ? SRPExtraCompat.countWaterParasites(event.world) : 0));
        }
        gnatCount.put(dimId, event.world.func_72907_a(EntityAta.class));
        scentCount.put(dimId, event.world.func_72907_a(EntityParasiticScent.class));
        if (SRPMixinsConfigHandler.simmermen.endSimmermenCap > 0 && dimId == 1) {
            end_simmermanCount = event.world.func_72907_a(EntityInfEnderman.class) + event.world.func_72907_a(EntityInfEndermanHead.class);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onJoinWorld(EntityJoinWorldEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getEntity() instanceof EntityParasiteBase)) {
            return;
        }
        EntityParasiteBase parasite = (EntityParasiteBase)event.getEntity();
        int dimId = event.getWorld().field_73011_w.getDimension();
        if (SRPMixinsConfigHandler.deterrents.nexusCap >= 0 && parasite instanceof EntityPStationaryArchitect) {
            nexusCount.put(dimId, nexusCount.getOrDefault(dimId, 0));
        } else if (SRPMixinsConfigHandler.waterparas.waterParasiteCap >= 0 && (parasite instanceof EntityInfSquid || parasite instanceof EntityLum || CompatUtil.srpextra.isLoaded() && SRPExtraCompat.isWaterParasite((Entity)parasite))) {
            waterCount.put(dimId, waterCount.getOrDefault(dimId, 0));
        } else if (parasite instanceof EntityAta) {
            gnatCount.put(dimId, gnatCount.getOrDefault(dimId, 0));
        } else if (dimId == 1 && parasite instanceof EntityInfEnderman || parasite instanceof EntityInfEndermanHead) {
            ++end_simmermanCount;
        }
    }
}

