/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.handlers;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPStationaryArchitect;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityAta;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfSquid;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityLum;
import com.dhanantry.scapeandrunparasites.init.SRPSpawning;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigWorld;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import com.dhanantry.scapeandrunparasites.world.SRPWorldData;
import com.dhanantry.scapeandrunparasites.world.biome.BiomeParasite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import srpmixins.compat.CompatUtil;
import srpmixins.compat.SRPExtraCompat;
import srpmixins.config.SRPConfigProvider;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.config.SRPMixinsConfigProvider;
import srpmixins.config.providers.SRPMobConfigProvider;
import srpmixins.handlers.WorldMobCapHandler;
import srpmixins.util.ParasiteCreatureType;
import srpmixins.util.customphasemechanics.SRPSaveDataInterface;

public class SpawnPotentialsHandler {
    public static final Map<Byte, List<BiomeSpawnListEntryWrapper>> phaseIdSpawnsCustom = new HashMap<Byte, List<BiomeSpawnListEntryWrapper>>();
    public static final Map<Byte, List<BiomeSpawnListEntryWrapper>> phaseIdSpawns = new HashMap<Byte, List<BiomeSpawnListEntryWrapper>>();
    public static final List<BiomeSpawnListEntryWrapper> allPhaseSpawns = new ArrayList<BiomeSpawnListEntryWrapper>();
    public static final List<BiomeSpawnListEntryWrapper> biomeSpawns = new ArrayList<BiomeSpawnListEntryWrapper>();
    private static Map<Integer, Integer> paraIdToColoPointLock = null;
    private static int playerCount = 0;

    public static void resetCaches() {
        phaseIdSpawns.clear();
        allPhaseSpawns.clear();
        biomeSpawns.clear();
        paraIdToColoPointLock = null;
    }

    public static List<BiomeSpawnListEntryWrapper> getPhaseSpawnListCustom(byte phaseChecked) {
        List srpList;
        if (phaseIdSpawnsCustom.containsKey(phaseChecked)) {
            return phaseIdSpawnsCustom.get(phaseChecked);
        }
        List<BiomeSpawnListEntryWrapper> freshList = phaseChecked > SRPConfigProvider.getMaxPhase() ? Collections.emptyList() : ((srpList = SRPSpawning.getSpawns((byte)phaseChecked)) == null || srpList.isEmpty() ? Collections.emptyList() : srpList.stream().map(entry -> {
            ResourceLocation loc = EntityList.func_191306_a((Class)entry.field_76300_b);
            if (loc == null) {
                return new BiomeSpawnListEntryWrapper((Biome.SpawnListEntry)entry, Integer.MIN_VALUE);
            }
            int paraId = SRPMobConfigProvider.mobNameToParaIdMap.getOrDefault(loc.func_110623_a(), Integer.MIN_VALUE);
            return new BiomeSpawnListEntryWrapper((Biome.SpawnListEntry)entry, paraId);
        }).collect(Collectors.toList()));
        phaseIdSpawnsCustom.put(phaseChecked, freshList);
        return freshList;
    }

    public static Map<Integer, Integer> getParaIdToColoPointLockMap() {
        if (paraIdToColoPointLock == null) {
            paraIdToColoPointLock = Arrays.stream(SRPConfigWorld.preeValues).map(s -> s.split(";")).collect(Collectors.toMap(split -> Integer.parseInt(split[0].trim()), split -> Integer.parseInt(split[1].trim())));
        }
        return paraIdToColoPointLock;
    }

    @SubscribeEvent
    public static void onSpawnPotentials(WorldEvent.PotentialSpawns event) {
        boolean isInList;
        if (event.getType() != ParasiteCreatureType.PARASITE) {
            return;
        }
        World world = event.getWorld();
        int currDim = world.field_73011_w.getDimension();
        if (!SRPConfigSystems.useEvolution && (isInList = Arrays.stream(SRPConfig.blackListedDimensions).anyMatch(dim -> dim == currDim)) != SRPConfig.blackListedDimensionsWhite) {
            return;
        }
        Set<String> biomeBlacklist = SRPMixinsConfigProvider.biomeSpawningBlacklists.get(currDim);
        if (biomeBlacklist != null && SpawnPotentialsHandler.isDimensionBlacklisted(biomeBlacklist)) {
            return;
        }
        Biome biome = world.func_180494_b(event.getPos());
        if (biomeBlacklist != null && SpawnPotentialsHandler.isBiomeBlacklisted(biomeBlacklist, biome)) {
            return;
        }
        SRPSaveData data = SRPSaveDataInterface.get(world, null, event.getPos());
        SRPWorldData worlddata = SRPWorldData.get((World)world);
        playerCount = world.field_73010_i.size();
        if (biome instanceof BiomeParasite) {
            event.getList().addAll(SpawnPotentialsHandler.filterSpawnEntries(biomeSpawns, data, worlddata, true, currDim));
        } else {
            byte evophase = data.getEvolutionPhase(currDim);
            if (SRPConfigSystems.useEvolution && evophase < 0) {
                return;
            }
            if (SRPConfigSystems.useEvolution && SRPConfigSystems.phaseCustomSpawner) {
                event.getList().addAll(SpawnPotentialsHandler.filterSpawnEntries(SpawnPotentialsHandler.getPhaseSpawnListCustom(evophase), data, worlddata, false, currDim));
            } else if (SRPConfigSystems.useEvolution) {
                event.getList().addAll(SpawnPotentialsHandler.filterSpawnEntries(phaseIdSpawns.getOrDefault(evophase, Collections.emptyList()), data, worlddata, false, currDim));
            } else {
                event.getList().addAll(SpawnPotentialsHandler.filterSpawnEntries(allPhaseSpawns, data, worlddata, false, currDim));
            }
        }
    }

    private static List<Biome.SpawnListEntry> filterSpawnEntries(List<BiomeSpawnListEntryWrapper> original, SRPSaveData data, SRPWorldData worldData, boolean isParaBiome, int dimId) {
        ArrayList<Biome.SpawnListEntry> returnList = new ArrayList<Biome.SpawnListEntry>();
        for (BiomeSpawnListEntryWrapper wrapper : original) {
            if (wrapper.paraId == Integer.MIN_VALUE || data.checkParasiteID(wrapper.paraId) || SpawnPotentialsHandler.isColonyLocked(wrapper.paraId, worldData, isParaBiome) || SpawnPotentialsHandler.isSubCapLocked(wrapper.entry.field_76300_b, dimId)) continue;
            returnList.add(wrapper.entry);
        }
        return returnList;
    }

    private static boolean isSubCapLocked(Class<? extends EntityLiving> entityClass, int dimId) {
        if (entityClass == EntityLum.class || entityClass == EntityInfSquid.class || CompatUtil.srpextra.isLoaded() && SRPExtraCompat.isWaterParasite(entityClass)) {
            if (SRPMixinsConfigHandler.waterparas.waterParasiteCap < 0) {
                return false;
            }
            return WorldMobCapHandler.waterCount.getOrDefault(dimId, 0) >= SRPMixinsConfigHandler.waterparas.waterParasiteCap * playerCount;
        }
        if (EntityPStationaryArchitect.class.isAssignableFrom(entityClass)) {
            if (SRPMixinsConfigHandler.deterrents.nexusCap < 0) {
                return false;
            }
            return WorldMobCapHandler.nexusCount.getOrDefault(dimId, 0) >= SRPMixinsConfigHandler.deterrents.nexusCap * playerCount;
        }
        if (entityClass == EntityAta.class) {
            return WorldMobCapHandler.gnatCount.getOrDefault(dimId, 0) >= SRPConfig.worldGnatCap * playerCount;
        }
        return false;
    }

    private static boolean isColonyLocked(int paraIdToCheck, SRPWorldData data, boolean isParaBiome) {
        if (paraIdToCheck == 90 && !SRPConfigWorld.coloniesActivated) {
            return false;
        }
        if (SRPMixinsConfigHandler.spawns.fixColonyLock && !SRPConfigWorld.coloniesActivated) {
            return false;
        }
        if (isParaBiome && !SRPConfigWorld.preeValuesBiome) {
            return false;
        }
        int minColoPointsRequired = SpawnPotentialsHandler.getParaIdToColoPointLockMap().getOrDefault(paraIdToCheck, 0);
        if (minColoPointsRequired <= 0) {
            return false;
        }
        int currColoPoints = data.totalColonyPoints(0);
        return currColoPoints < minColoPointsRequired;
    }

    private static boolean isDimensionBlacklisted(Set<String> biomeBlacklist) {
        if (biomeBlacklist.isEmpty()) {
            return !SRPMixinsConfigHandler.spawns.biomeBlacklistIsWhitelist;
        }
        return false;
    }

    private static boolean isBiomeBlacklisted(Set<String> biomeBlacklist, Biome biome) {
        if (biomeBlacklist.isEmpty()) {
            return false;
        }
        ResourceLocation biomeLoc = biome.getRegistryName();
        if (biomeLoc == null) {
            return false;
        }
        String biomeId = biomeLoc.toString();
        String biomeModId = biomeLoc.func_110624_b();
        boolean isInList = biomeBlacklist.contains(biomeId) || biomeBlacklist.contains(biomeModId);
        return isInList != SRPMixinsConfigHandler.spawns.biomeBlacklistIsWhitelist;
    }

    public static class BiomeSpawnListEntryWrapper {
        final Biome.SpawnListEntry entry;
        final int paraId;

        public BiomeSpawnListEntryWrapper(Biome.SpawnListEntry entry, int paraId) {
            this.entry = entry;
            this.paraId = paraId;
        }
    }
}

