/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config.providers;

import com.dhanantry.scapeandrunparasites.util.config.SRPConfigMobs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;
import srpmixins.SRPMixins;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.rules.rule.VariantDisableRule;

public class SRPMobConfigProvider {
    public static final Map<String, Integer> mobNameToParaIdMap = new HashMap<String, Integer>();
    public static final Map<String, Byte> mobNameToParaTypeMap = new HashMap<String, Byte>();
    public static final Map<Integer, String> paraIdToMobName = new HashMap<Integer, String>();
    public static final Map<String, List<Integer>> mobGroupToParaIdMap = new HashMap<String, List<Integer>>();
    public static final Map<String, List<VariantDisableRule.EnumVariant>> mobNameToVariantsMap = new HashMap<String, List<VariantDisableRule.EnumVariant>>();
    private static final Map<String, SRPMobConfig> srpMobConfig = new HashMap<String, SRPMobConfig>();

    public static void reset() {
        srpMobConfig.clear();
    }

    public static boolean init() {
        String unused = "---";
        for (String s : SRPMixinsConfigHandler.mobConfig.mobConfig) {
            List split = Arrays.stream(s.split("\t")).map(String::trim).collect(Collectors.toList());
            if (split.size() < 7) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse SRPMixins Mob Config entry, too few entries, provided was {}", (Object)s);
                continue;
            }
            try {
                Boolean enabled = ((String)split.get(0)).equals(unused) ? null : Boolean.valueOf(Boolean.parseBoolean((String)split.get(0)));
                Float healthMulti = ((String)split.get(1)).equals(unused) ? null : Float.valueOf(Float.parseFloat((String)split.get(1)));
                Float dmgMulti = ((String)split.get(2)).equals(unused) ? null : Float.valueOf(Float.parseFloat((String)split.get(2)));
                Float armorMulti = ((String)split.get(3)).equals(unused) ? null : Float.valueOf(Float.parseFloat((String)split.get(3)));
                Float kbresMulti = ((String)split.get(4)).equals(unused) ? null : Float.valueOf(Float.parseFloat((String)split.get(4)));
                Integer spawnRate = ((String)split.get(5)).equals(unused) ? null : Integer.valueOf(Integer.parseInt((String)split.get(5)));
                String mobName = (String)split.get(6);
                srpMobConfig.put(mobName, new SRPMobConfig(enabled, dmgMulti, armorMulti, healthMulti, kbresMulti, spawnRate));
            }
            catch (Exception e) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse SRPMixins Mob Config entry, expected numbers, provided was {}", (Object)s);
            }
        }
        return !srpMobConfig.isEmpty();
    }

    public static void initMobConfigs() {
        srpMobConfig.put("anc_dreadnaut", new SRPMobConfig(SRPConfigMobs.oroncoEnabled, Float.valueOf(SRPConfigMobs.oroncoDamageMultiplier), Float.valueOf(SRPConfigMobs.oroncoArmorMultiplier), Float.valueOf(SRPConfigMobs.oroncoHealthMultiplier), Float.valueOf(SRPConfigMobs.oroncoKDResistanceMultiplier), SRPConfigMobs.oroncoSpawnRate));
        srpMobConfig.put("anc_overlord", new SRPMobConfig(SRPConfigMobs.terlaEnabled, Float.valueOf(SRPConfigMobs.terlaDamageMultiplier), Float.valueOf(SRPConfigMobs.terlaArmorMultiplier), Float.valueOf(SRPConfigMobs.terlaHealthMultiplier), Float.valueOf(SRPConfigMobs.terlaKDResistanceMultiplier), SRPConfigMobs.terlaSpawnRate));
        srpMobConfig.put("anc_pod", new SRPMobConfig(null, Float.valueOf(SRPConfigMobs.pod1DamageMultiplier), Float.valueOf(SRPConfigMobs.pod1ArmorMultiplier), Float.valueOf(SRPConfigMobs.pod1HealthMultiplier), null, null));
        srpMobConfig.put("pri_arachnida", new SRPMobConfig(SRPConfigMobs.arachnidaEnabled, Float.valueOf(SRPConfigMobs.arachnidaDamageMultiplier), Float.valueOf(SRPConfigMobs.arachnidaArmorMultiplier), Float.valueOf(SRPConfigMobs.arachnidaHealthMultiplier), Float.valueOf(SRPConfigMobs.arachnidaKDResistanceMultiplier), SRPConfigMobs.arachnidaSpawnRate));
        srpMobConfig.put("bogle", new SRPMobConfig(SRPConfigMobs.lenciaEnabled, Float.valueOf(SRPConfigMobs.lenciaDamageMultiplier), Float.valueOf(SRPConfigMobs.lenciaArmorMultiplier), Float.valueOf(SRPConfigMobs.lenciaHealthMultiplier), Float.valueOf(SRPConfigMobs.lenciaKDResistanceMultiplier), SRPConfigMobs.lenciaSpawnRate));
        srpMobConfig.put("bomber_heavy", new SRPMobConfig(SRPConfigMobs.jinjoEnabled, Float.valueOf(SRPConfigMobs.jinjoDamageMultiplier), Float.valueOf(SRPConfigMobs.jinjoArmorMultiplier), Float.valueOf(SRPConfigMobs.jinjoHealthMultiplier), Float.valueOf(SRPConfigMobs.jinjoKDResistanceMultiplier), SRPConfigMobs.jinjoSpawnRate));
        srpMobConfig.put("bomber_light", new SRPMobConfig(SRPConfigMobs.ombooEnabled, Float.valueOf(SRPConfigMobs.ombooDamageMultiplier), Float.valueOf(SRPConfigMobs.ombooArmorMultiplier), Float.valueOf(SRPConfigMobs.ombooHealthMultiplier), Float.valueOf(SRPConfigMobs.ombooKDResistanceMultiplier), SRPConfigMobs.ombooSpawnRate));
        srpMobConfig.put("buglin", new SRPMobConfig(SRPConfigMobs.lodoEnabled, Float.valueOf(SRPConfigMobs.lodoDamageMultiplier), Float.valueOf(SRPConfigMobs.lodoArmorMultiplier), Float.valueOf(SRPConfigMobs.lodoHealthMultiplier), Float.valueOf(SRPConfigMobs.lodoKDResistanceMultiplier), SRPConfigMobs.lodoSpawnRate));
        srpMobConfig.put("carrier_colony", new SRPMobConfig(SRPConfigMobs.vestaEnabled, Float.valueOf(SRPConfigMobs.vestaDamageMultiplier), Float.valueOf(SRPConfigMobs.vestaArmorMultiplier), Float.valueOf(SRPConfigMobs.vestaHealthMultiplier), Float.valueOf(SRPConfigMobs.vestaKDResistanceMultiplier), SRPConfigMobs.vestaSpawnRate));
        srpMobConfig.put("carrier_flying", new SRPMobConfig(SRPConfigMobs.butholEnabled, Float.valueOf(SRPConfigMobs.butholDamageMultiplier), Float.valueOf(SRPConfigMobs.butholArmorMultiplier), Float.valueOf(SRPConfigMobs.butholHealthMultiplier), Float.valueOf(SRPConfigMobs.butholKDResistanceMultiplier), SRPConfigMobs.butholSpawnRate));
        srpMobConfig.put("carrier_heavy", new SRPMobConfig(SRPConfigMobs.ratholEnabled, Float.valueOf(SRPConfigMobs.ratholDamageMultiplier), Float.valueOf(SRPConfigMobs.ratholArmorMultiplier), Float.valueOf(SRPConfigMobs.ratholHealthMultiplier), Float.valueOf(SRPConfigMobs.ratholKDResistanceMultiplier), SRPConfigMobs.ratholSpawnRate));
        srpMobConfig.put("carrier_light", new SRPMobConfig(SRPConfigMobs.gotholEnabled, Float.valueOf(SRPConfigMobs.gotholDamageMultiplier), Float.valueOf(SRPConfigMobs.gotholArmorMultiplier), Float.valueOf(SRPConfigMobs.gotholHealthMultiplier), Float.valueOf(SRPConfigMobs.gotholKDResistanceMultiplier), SRPConfigMobs.gotholSpawnRate));
        srpMobConfig.put("crux", new SRPMobConfig(SRPConfigMobs.cruxaEnabled, Float.valueOf(SRPConfigMobs.cruxaDamageMultiplier), Float.valueOf(SRPConfigMobs.cruxaArmorMultiplier), Float.valueOf(SRPConfigMobs.cruxaHealthMultiplier), Float.valueOf(SRPConfigMobs.cruxaKDResistanceMultiplier), SRPConfigMobs.cruxaSpawnRate));
        srpMobConfig.put("draconite", new SRPMobConfig(SRPConfigMobs.hebluEnabled, Float.valueOf(SRPConfigMobs.hebluDamageMultiplier), Float.valueOf(SRPConfigMobs.hebluArmorMultiplier), Float.valueOf(SRPConfigMobs.hebluHealthMultiplier), Float.valueOf(SRPConfigMobs.hebluKDResistanceMultiplier), SRPConfigMobs.hebluSpawnRate));
        srpMobConfig.put("fer_bear", new SRPMobConfig(SRPConfigMobs.ferbearEnabled, Float.valueOf(SRPConfigMobs.ferbearDamageMultiplier), Float.valueOf(SRPConfigMobs.ferbearArmorMultiplier), Float.valueOf(SRPConfigMobs.ferbearHealthMultiplier), Float.valueOf(SRPConfigMobs.ferbearKDResistanceMultiplier), SRPConfigMobs.ferbearSpawnRate));
        srpMobConfig.put("fer_cow", new SRPMobConfig(SRPConfigMobs.fercowEnabled, Float.valueOf(SRPConfigMobs.fercowDamageMultiplier), Float.valueOf(SRPConfigMobs.fercowArmorMultiplier), Float.valueOf(SRPConfigMobs.fercowHealthMultiplier), Float.valueOf(SRPConfigMobs.fercowKDResistanceMultiplier), SRPConfigMobs.fercowSpawnRate));
        srpMobConfig.put("fer_enderman", new SRPMobConfig(SRPConfigMobs.ferendermanEnabled, Float.valueOf(SRPConfigMobs.ferendermanDamageMultiplier), Float.valueOf(SRPConfigMobs.ferendermanArmorMultiplier), Float.valueOf(SRPConfigMobs.ferendermanHealthMultiplier), Float.valueOf(SRPConfigMobs.ferendermanKDResistanceMultiplier), SRPConfigMobs.ferendermanSpawnRate));
        srpMobConfig.put("fer_horse", new SRPMobConfig(SRPConfigMobs.ferhorseEnabled, Float.valueOf(SRPConfigMobs.ferhorseDamageMultiplier), Float.valueOf(SRPConfigMobs.ferhorseArmorMultiplier), Float.valueOf(SRPConfigMobs.ferhorseHealthMultiplier), Float.valueOf(SRPConfigMobs.ferhorseKDResistanceMultiplier), SRPConfigMobs.ferhorseSpawnRate));
        srpMobConfig.put("fer_human", new SRPMobConfig(SRPConfigMobs.ferhumanEnabled, Float.valueOf(SRPConfigMobs.ferhumanDamageMultiplier), Float.valueOf(SRPConfigMobs.ferhumanArmorMultiplier), Float.valueOf(SRPConfigMobs.ferhumanHealthMultiplier), Float.valueOf(SRPConfigMobs.ferhumanKDResistanceMultiplier), SRPConfigMobs.ferhumanSpawnRate));
        srpMobConfig.put("fer_pig", new SRPMobConfig(SRPConfigMobs.ferpigEnabled, Float.valueOf(SRPConfigMobs.ferpigDamageMultiplier), Float.valueOf(SRPConfigMobs.ferpigArmorMultiplier), Float.valueOf(SRPConfigMobs.ferpigHealthMultiplier), Float.valueOf(SRPConfigMobs.ferpigKDResistanceMultiplier), SRPConfigMobs.ferpigSpawnRate));
        srpMobConfig.put("fer_sheep", new SRPMobConfig(SRPConfigMobs.fersheepEnabled, Float.valueOf(SRPConfigMobs.fersheepDamageMultiplier), Float.valueOf(SRPConfigMobs.fersheepArmorMultiplier), Float.valueOf(SRPConfigMobs.fersheepHealthMultiplier), Float.valueOf(SRPConfigMobs.fersheepKDResistanceMultiplier), SRPConfigMobs.fersheepSpawnRate));
        srpMobConfig.put("fer_villager", new SRPMobConfig(SRPConfigMobs.fervillagerEnabled, Float.valueOf(SRPConfigMobs.fervillagerDamageMultiplier), Float.valueOf(SRPConfigMobs.fervillagerArmorMultiplier), Float.valueOf(SRPConfigMobs.fervillagerHealthMultiplier), Float.valueOf(SRPConfigMobs.fervillagerKDResistanceMultiplier), SRPConfigMobs.fervillagerSpawnRate));
        srpMobConfig.put("fer_wolf", new SRPMobConfig(SRPConfigMobs.ferwolfEnabled, Float.valueOf(SRPConfigMobs.ferwolfDamageMultiplier), Float.valueOf(SRPConfigMobs.ferwolfArmorMultiplier), Float.valueOf(SRPConfigMobs.ferwolfHealthMultiplier), Float.valueOf(SRPConfigMobs.ferwolfKDResistanceMultiplier), SRPConfigMobs.ferwolfSpawnRate));
        srpMobConfig.put("gnat", new SRPMobConfig(SRPConfigMobs.ataEnabled, Float.valueOf(SRPConfigMobs.ataDamageMultiplier), Float.valueOf(SRPConfigMobs.ataArmorMultiplier), Float.valueOf(SRPConfigMobs.ataHealthMultiplier), Float.valueOf(SRPConfigMobs.ataKDResistanceMultiplier), SRPConfigMobs.ataSpawnRate));
        srpMobConfig.put("grunt", new SRPMobConfig(SRPConfigMobs.flogEnabled, Float.valueOf(SRPConfigMobs.flogDamageMultiplier), Float.valueOf(SRPConfigMobs.flogArmorMultiplier), Float.valueOf(SRPConfigMobs.flogHealthMultiplier), Float.valueOf(SRPConfigMobs.flogKDResistanceMultiplier), SRPConfigMobs.flogSpawnRate));
        srpMobConfig.put("haunter", new SRPMobConfig(SRPConfigMobs.pheonEnabled, Float.valueOf(SRPConfigMobs.pheonDamageMultiplier), Float.valueOf(SRPConfigMobs.pheonArmorMultiplier), Float.valueOf(SRPConfigMobs.pheonHealthMultiplier), Float.valueOf(SRPConfigMobs.pheonKDResistanceMultiplier), SRPConfigMobs.pheonSpawnRate));
        srpMobConfig.put("heed", new SRPMobConfig(SRPConfigMobs.heedEnabled, Float.valueOf(SRPConfigMobs.heedDamageMultiplier), Float.valueOf(SRPConfigMobs.heedArmorMultiplier), Float.valueOf(SRPConfigMobs.heedHealthMultiplier), Float.valueOf(SRPConfigMobs.heedKDResistanceMultiplier), SRPConfigMobs.heedSpawnRate));
        srpMobConfig.put("hostii", new SRPMobConfig(SRPConfigMobs.herdEnabled, Float.valueOf(SRPConfigMobs.herdDamageMultiplier), Float.valueOf(SRPConfigMobs.herdArmorMultiplier), Float.valueOf(SRPConfigMobs.herdHealthMultiplier), Float.valueOf(SRPConfigMobs.herdKDResistanceMultiplier), SRPConfigMobs.herdSpawnRate));
        srpMobConfig.put("hi_blaze", new SRPMobConfig(SRPConfigMobs.hiblazeEnabled, Float.valueOf(SRPConfigMobs.hiblazeDamageMultiplier), Float.valueOf(SRPConfigMobs.hiblazeArmorMultiplier), Float.valueOf(SRPConfigMobs.hiblazeHealthMultiplier), Float.valueOf(SRPConfigMobs.hiblazeKDResistanceMultiplier), SRPConfigMobs.hiblazeSpawnRate));
        srpMobConfig.put("hi_golem", new SRPMobConfig(SRPConfigMobs.higolemEnabled, Float.valueOf(SRPConfigMobs.higolemDamageMultiplier), Float.valueOf(SRPConfigMobs.higolemArmorMultiplier), Float.valueOf(SRPConfigMobs.higolemHealthMultiplier), Float.valueOf(SRPConfigMobs.higolemKDResistanceMultiplier), SRPConfigMobs.higolemSpawnRate));
        srpMobConfig.put("hi_skeleton", new SRPMobConfig(SRPConfigMobs.hiskeletonEnabled, Float.valueOf(SRPConfigMobs.hiskeletonDamageMultiplier), Float.valueOf(SRPConfigMobs.hiskeletonArmorMultiplier), Float.valueOf(SRPConfigMobs.hiskeletonHealthMultiplier), Float.valueOf(SRPConfigMobs.hiskeletonKDResistanceMultiplier), SRPConfigMobs.hiskeletonSpawnRate));
        srpMobConfig.put("host", new SRPMobConfig(SRPConfigMobs.hostEnabled, Float.valueOf(SRPConfigMobs.hostDamageMultiplier), Float.valueOf(SRPConfigMobs.hostArmorMultiplier), Float.valueOf(SRPConfigMobs.hostHealthMultiplier), Float.valueOf(SRPConfigMobs.hostKDResistanceMultiplier), SRPConfigMobs.hostSpawnRate));
        srpMobConfig.put("incompleteform_medium", new SRPMobConfig(SRPConfigMobs.inhooMEnabled, Float.valueOf(SRPConfigMobs.inhooMDamageMultiplier), Float.valueOf(SRPConfigMobs.inhooMArmorMultiplier), Float.valueOf(SRPConfigMobs.inhooMHealthMultiplier), Float.valueOf(SRPConfigMobs.inhooMKDResistanceMultiplier), SRPConfigMobs.inhooMSpawnRate));
        srpMobConfig.put("incompleteform_small", new SRPMobConfig(SRPConfigMobs.inhooSEnabled, Float.valueOf(SRPConfigMobs.inhooSDamageMultiplier), Float.valueOf(SRPConfigMobs.inhooSArmorMultiplier), Float.valueOf(SRPConfigMobs.inhooSHealthMultiplier), Float.valueOf(SRPConfigMobs.inhooSKDResistanceMultiplier), SRPConfigMobs.inhooSSpawnRate));
        srpMobConfig.put("kyphosis", new SRPMobConfig(SRPConfigMobs.tonroEnabled, Float.valueOf(SRPConfigMobs.tonroDamageMultiplier), Float.valueOf(SRPConfigMobs.tonroArmorMultiplier), Float.valueOf(SRPConfigMobs.tonroHealthMultiplier), null, null));
        srpMobConfig.put("mangler", new SRPMobConfig(SRPConfigMobs.nuuhEnabled, Float.valueOf(SRPConfigMobs.nuuhDamageMultiplier), Float.valueOf(SRPConfigMobs.nuuhArmorMultiplier), Float.valueOf(SRPConfigMobs.nuuhHealthMultiplier), Float.valueOf(SRPConfigMobs.nuuhKDResistanceMultiplier), SRPConfigMobs.nuuhSpawnRate));
        srpMobConfig.put("marauder", new SRPMobConfig(SRPConfigMobs.esorEnabled, Float.valueOf(SRPConfigMobs.esorDamageMultiplier), Float.valueOf(SRPConfigMobs.esorArmorMultiplier), Float.valueOf(SRPConfigMobs.esorHealthMultiplier), Float.valueOf(SRPConfigMobs.esorKDResistanceMultiplier), SRPConfigMobs.esorSpawnRate));
        srpMobConfig.put("monarch", new SRPMobConfig(SRPConfigMobs.orchEnabled, Float.valueOf(SRPConfigMobs.orchDamageMultiplier), Float.valueOf(SRPConfigMobs.orchArmorMultiplier), Float.valueOf(SRPConfigMobs.orchHealthMultiplier), Float.valueOf(SRPConfigMobs.orchKDResistanceMultiplier), SRPConfigMobs.orchSpawnRate));
        srpMobConfig.put("overseer", new SRPMobConfig(SRPConfigMobs.alafhaEnabled, Float.valueOf(SRPConfigMobs.alafhaDamageMultiplier), Float.valueOf(SRPConfigMobs.alafhaArmorMultiplier), Float.valueOf(SRPConfigMobs.alafhaHealthMultiplier), Float.valueOf(SRPConfigMobs.alafhaKDResistanceMultiplier), SRPConfigMobs.alafhaSpawnRate));
        srpMobConfig.put("pri_bolster", new SRPMobConfig(SRPConfigMobs.zetmoEnabled, Float.valueOf(SRPConfigMobs.zetmoDamageMultiplier), Float.valueOf(SRPConfigMobs.zetmoArmorMultiplier), Float.valueOf(SRPConfigMobs.zetmoHealthMultiplier), Float.valueOf(SRPConfigMobs.zetmoKDResistanceMultiplier), SRPConfigMobs.zetmoSpawnRate));
        srpMobConfig.put("pri_devourer", new SRPMobConfig(SRPConfigMobs.lumEnabled, Float.valueOf(SRPConfigMobs.lumDamageMultiplier), Float.valueOf(SRPConfigMobs.lumArmorMultiplier), Float.valueOf(SRPConfigMobs.lumHealthMultiplier), Float.valueOf(SRPConfigMobs.lumKDResistanceMultiplier), SRPConfigMobs.lumSpawnRate));
        srpMobConfig.put("pri_longarms", new SRPMobConfig(SRPConfigMobs.shycoEnabled, Float.valueOf(SRPConfigMobs.shycoDamageMultiplier), Float.valueOf(SRPConfigMobs.shycoArmorMultiplier), Float.valueOf(SRPConfigMobs.shycoHealthMultiplier), Float.valueOf(SRPConfigMobs.shycoKDResistanceMultiplier), SRPConfigMobs.shycoSpawnRate));
        srpMobConfig.put("pri_manducater", new SRPMobConfig(SRPConfigMobs.hullEnabled, Float.valueOf(SRPConfigMobs.hullDamageMultiplier), Float.valueOf(SRPConfigMobs.hullArmorMultiplier), Float.valueOf(SRPConfigMobs.hullHealthMultiplier), Float.valueOf(SRPConfigMobs.hullKDResistanceMultiplier), SRPConfigMobs.hullSpawnRate));
        srpMobConfig.put("pri_reeker", new SRPMobConfig(SRPConfigMobs.noglaEnabled, Float.valueOf(SRPConfigMobs.noglaDamageMultiplier), Float.valueOf(SRPConfigMobs.noglaArmorMultiplier), Float.valueOf(SRPConfigMobs.noglaHealthMultiplier), Float.valueOf(SRPConfigMobs.noglaKDResistanceMultiplier), SRPConfigMobs.noglaSpawnRate));
        srpMobConfig.put("pri_summoner", new SRPMobConfig(SRPConfigMobs.canraEnabled, Float.valueOf(SRPConfigMobs.canraDamageMultiplier), Float.valueOf(SRPConfigMobs.canraArmorMultiplier), Float.valueOf(SRPConfigMobs.canraHealthMultiplier), Float.valueOf(SRPConfigMobs.canraKDResistanceMultiplier), SRPConfigMobs.canraSpawnRate));
        srpMobConfig.put("pri_tozoon", new SRPMobConfig(SRPConfigMobs.wymoEnabled, Float.valueOf(SRPConfigMobs.wymoDamageMultiplier), Float.valueOf(SRPConfigMobs.wymoArmorMultiplier), Float.valueOf(SRPConfigMobs.wymoHealthMultiplier), Float.valueOf(SRPConfigMobs.wymoKDResistanceMultiplier), SRPConfigMobs.wymoSpawnRate));
        srpMobConfig.put("pri_vermin", new SRPMobConfig(SRPConfigMobs.ikiEnabled, Float.valueOf(SRPConfigMobs.ikiDamageMultiplier), Float.valueOf(SRPConfigMobs.ikiArmorMultiplier), Float.valueOf(SRPConfigMobs.ikiHealthMultiplier), Float.valueOf(SRPConfigMobs.ikiKDResistanceMultiplier), SRPConfigMobs.ikiSpawnRate));
        srpMobConfig.put("pri_yelloweye", new SRPMobConfig(SRPConfigMobs.emanaEnabled, Float.valueOf(SRPConfigMobs.emanaDamageMultiplier), Float.valueOf(SRPConfigMobs.emanaArmorMultiplier), Float.valueOf(SRPConfigMobs.emanaHealthMultiplier), Float.valueOf(SRPConfigMobs.emanaKDResistanceMultiplier), SRPConfigMobs.emanaSpawnRate));
        srpMobConfig.put("rupter", new SRPMobConfig(SRPConfigMobs.mudoEnabled, Float.valueOf(SRPConfigMobs.mudoDamageMultiplier), Float.valueOf(SRPConfigMobs.mudoArmorMultiplier), Float.valueOf(SRPConfigMobs.mudoHealthMultiplier), Float.valueOf(SRPConfigMobs.mudoKDResistanceMultiplier), SRPConfigMobs.mudoSpawnRate));
        srpMobConfig.put("seizer", new SRPMobConfig(SRPConfigMobs.nakEnabled, Float.valueOf(SRPConfigMobs.nakDamageMultiplier), Float.valueOf(SRPConfigMobs.nakArmorMultiplier), Float.valueOf(SRPConfigMobs.nakHealthMultiplier), null, SRPConfigMobs.nakSpawnRate));
        srpMobConfig.put("sentry", new SRPMobConfig(SRPConfigMobs.unvoEnabled, Float.valueOf(SRPConfigMobs.unvoDamageMultiplier), Float.valueOf(SRPConfigMobs.unvoArmorMultiplier), Float.valueOf(SRPConfigMobs.unvoHealthMultiplier), null, null));
        srpMobConfig.put("sim_adventurer", new SRPMobConfig(SRPConfigMobs.infadventurerEnabled, Float.valueOf(SRPConfigMobs.infadventurerDamageMultiplier), Float.valueOf(SRPConfigMobs.infadventurerArmorMultiplier), Float.valueOf(SRPConfigMobs.infadventurerHealthMultiplier), Float.valueOf(SRPConfigMobs.infadventurerKDResistanceMultiplier), SRPConfigMobs.infadventurerSpawnRate));
        srpMobConfig.put("sim_bear", new SRPMobConfig(SRPConfigMobs.infbearEnabled, Float.valueOf(SRPConfigMobs.infbearDamageMultiplier), Float.valueOf(SRPConfigMobs.infbearArmorMultiplier), Float.valueOf(SRPConfigMobs.infbearHealthMultiplier), Float.valueOf(SRPConfigMobs.infbearKDResistanceMultiplier), SRPConfigMobs.infbearSpawnRate));
        srpMobConfig.put("sim_bigspider", new SRPMobConfig(SRPConfigMobs.dorpaEnabled, Float.valueOf(SRPConfigMobs.dorpaDamageMultiplier), Float.valueOf(SRPConfigMobs.dorpaArmorMultiplier), Float.valueOf(SRPConfigMobs.dorpaHealthMultiplier), Float.valueOf(SRPConfigMobs.dorpaKDResistanceMultiplier), SRPConfigMobs.dorpaSpawnRate));
        srpMobConfig.put("sim_cow", new SRPMobConfig(SRPConfigMobs.infcowEnabled, Float.valueOf(SRPConfigMobs.infcowDamageMultiplier), Float.valueOf(SRPConfigMobs.infcowArmorMultiplier), Float.valueOf(SRPConfigMobs.infcowHealthMultiplier), Float.valueOf(SRPConfigMobs.infcowKDResistanceMultiplier), SRPConfigMobs.infcowSpawnRate));
        srpMobConfig.put("sim_dragone", new SRPMobConfig(SRPConfigMobs.infdragoneEnabled, Float.valueOf(SRPConfigMobs.infdragoneDamageMultiplier), Float.valueOf(SRPConfigMobs.infdragoneArmorMultiplier), Float.valueOf(SRPConfigMobs.infdragoneHealthMultiplier), Float.valueOf(SRPConfigMobs.infdragoneKDResistanceMultiplier), SRPConfigMobs.infdragoneSpawnRate));
        srpMobConfig.put("sim_enderman", new SRPMobConfig(SRPConfigMobs.infendermanEnabled, Float.valueOf(SRPConfigMobs.infendermanDamageMultiplier), Float.valueOf(SRPConfigMobs.infendermanArmorMultiplier), Float.valueOf(SRPConfigMobs.infendermanHealthMultiplier), Float.valueOf(SRPConfigMobs.infendermanKDResistanceMultiplier), SRPConfigMobs.infendermanSpawnRate));
        srpMobConfig.put("sim_horse", new SRPMobConfig(SRPConfigMobs.infhorseEnabled, Float.valueOf(SRPConfigMobs.infhorseDamageMultiplier), Float.valueOf(SRPConfigMobs.infhorseArmorMultiplier), Float.valueOf(SRPConfigMobs.infhorseHealthMultiplier), Float.valueOf(SRPConfigMobs.infhorseKDResistanceMultiplier), SRPConfigMobs.infhorseSpawnRate));
        srpMobConfig.put("sim_human", new SRPMobConfig(SRPConfigMobs.infhumanEnabled, Float.valueOf(SRPConfigMobs.infhumanDamageMultiplier), Float.valueOf(SRPConfigMobs.infhumanArmorMultiplier), Float.valueOf(SRPConfigMobs.infhumanHealthMultiplier), Float.valueOf(SRPConfigMobs.infhumanKDResistanceMultiplier), SRPConfigMobs.infhumanSpawnRate));
        srpMobConfig.put("sim_pig", new SRPMobConfig(SRPConfigMobs.infpigEnabled, Float.valueOf(SRPConfigMobs.infpigDamageMultiplier), Float.valueOf(SRPConfigMobs.infpigArmorMultiplier), Float.valueOf(SRPConfigMobs.infpigHealthMultiplier), Float.valueOf(SRPConfigMobs.infpigKDResistanceMultiplier), SRPConfigMobs.infpigSpawnRate));
        srpMobConfig.put("sim_sheep", new SRPMobConfig(SRPConfigMobs.infsheepEnabled, Float.valueOf(SRPConfigMobs.infsheepDamageMultiplier), Float.valueOf(SRPConfigMobs.infsheepArmorMultiplier), Float.valueOf(SRPConfigMobs.infsheepHealthMultiplier), Float.valueOf(SRPConfigMobs.infsheepKDResistanceMultiplier), SRPConfigMobs.infsheepSpawnRate));
        srpMobConfig.put("sim_squid", new SRPMobConfig(SRPConfigMobs.infsquidEnabled, Float.valueOf(SRPConfigMobs.infsquidDamageMultiplier), Float.valueOf(SRPConfigMobs.infsquidArmorMultiplier), Float.valueOf(SRPConfigMobs.infsquidHealthMultiplier), Float.valueOf(SRPConfigMobs.infsquidKDResistanceMultiplier), SRPConfigMobs.infsquidSpawnRate));
        srpMobConfig.put("sim_villager", new SRPMobConfig(SRPConfigMobs.infvillagerEnabled, Float.valueOf(SRPConfigMobs.infvillagerDamageMultiplier), Float.valueOf(SRPConfigMobs.infvillagerArmorMultiplier), Float.valueOf(SRPConfigMobs.infvillagerHealthMultiplier), Float.valueOf(SRPConfigMobs.infvillagerKDResistanceMultiplier), SRPConfigMobs.infvillagerSpawnRate));
        srpMobConfig.put("sim_wolf", new SRPMobConfig(SRPConfigMobs.infwolfEnabled, Float.valueOf(SRPConfigMobs.infwolfDamageMultiplier), Float.valueOf(SRPConfigMobs.infwolfArmorMultiplier), Float.valueOf(SRPConfigMobs.infwolfHealthMultiplier), Float.valueOf(SRPConfigMobs.infwolfKDResistanceMultiplier), SRPConfigMobs.infwolfSpawnRate));
        srpMobConfig.put("succor", new SRPMobConfig(SRPConfigMobs.flamEnabled, null, Float.valueOf(SRPConfigMobs.flamArmorMultiplier), Float.valueOf(SRPConfigMobs.flamHealthMultiplier), Float.valueOf(SRPConfigMobs.flamKDResistanceMultiplier), null));
        srpMobConfig.put("thrall", new SRPMobConfig(SRPConfigMobs.thrallEnabled, Float.valueOf(SRPConfigMobs.thrallDamageMultiplier), Float.valueOf(SRPConfigMobs.thrallArmorMultiplier), Float.valueOf(SRPConfigMobs.thrallHealthMultiplier), Float.valueOf(SRPConfigMobs.thrallKDResistanceMultiplier), SRPConfigMobs.thrallSpawnRate));
        srpMobConfig.put("vigilante", new SRPMobConfig(SRPConfigMobs.angedEnabled, Float.valueOf(SRPConfigMobs.angedDamageMultiplier), Float.valueOf(SRPConfigMobs.angedArmorMultiplier), Float.valueOf(SRPConfigMobs.angedHealthMultiplier), Float.valueOf(SRPConfigMobs.angedKDResistanceMultiplier), SRPConfigMobs.angedSpawnRate));
        srpMobConfig.put("warden", new SRPMobConfig(SRPConfigMobs.ganroEnabled, Float.valueOf(SRPConfigMobs.ganroDamageMultiplier), Float.valueOf(SRPConfigMobs.ganroArmorMultiplier), Float.valueOf(SRPConfigMobs.ganroHealthMultiplier), Float.valueOf(SRPConfigMobs.ganroKDResistanceMultiplier), SRPConfigMobs.ganroSpawnRate));
        srpMobConfig.put("worker", new SRPMobConfig(SRPConfigMobs.kolEnabled, Float.valueOf(SRPConfigMobs.kolDamageMultiplier), Float.valueOf(SRPConfigMobs.kolArmorMultiplier), Float.valueOf(SRPConfigMobs.kolHealthMultiplier), Float.valueOf(SRPConfigMobs.kolKDResistanceMultiplier), SRPConfigMobs.kolSpawnRate));
        srpMobConfig.put("wraith", new SRPMobConfig(SRPConfigMobs.elviaEnabled, Float.valueOf(SRPConfigMobs.elviaDamageMultiplier), Float.valueOf(SRPConfigMobs.elviaArmorMultiplier), Float.valueOf(SRPConfigMobs.elviaHealthMultiplier), Float.valueOf(SRPConfigMobs.elviaKDResistanceMultiplier), SRPConfigMobs.elviaSpawnRate));
        String unused = "---";
        ArrayList<String> configList = new ArrayList<String>();
        for (Map.Entry entry : srpMobConfig.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList())) {
            configList.add((((SRPMobConfig)entry.getValue()).enabled == null ? unused : ((SRPMobConfig)entry.getValue()).enabled) + "\t" + (((SRPMobConfig)entry.getValue()).healthMulti == null ? unused : ((SRPMobConfig)entry.getValue()).healthMulti) + "\t" + (((SRPMobConfig)entry.getValue()).dmgMulti == null ? unused : ((SRPMobConfig)entry.getValue()).dmgMulti) + "\t" + (((SRPMobConfig)entry.getValue()).armorMulti == null ? unused : ((SRPMobConfig)entry.getValue()).armorMulti) + "\t" + (((SRPMobConfig)entry.getValue()).kbresMulti == null ? unused : ((SRPMobConfig)entry.getValue()).kbresMulti) + "\t" + (((SRPMobConfig)entry.getValue()).spawnWeight == null ? unused : ((SRPMobConfig)entry.getValue()).spawnWeight) + "\t" + (String)entry.getKey());
        }
        String[] configArray = configList.toArray(configList.toArray(new String[0]));
        SRPMixins.CONFIG.get("general.SRP Mob Config", "SRP Mob Config", SRPMixinsConfigHandler.mobConfig.mobConfig).set(configArray);
        SRPMixinsConfigHandler.mobConfig.mobConfig = configArray;
        SRPMixins.CONFIG.save();
    }

    public static float getMobConfigDamage(String paraName) {
        return SRPMobConfigProvider.srpMobConfig.get((Object)paraName).dmgMulti.floatValue();
    }

    public static float getMobConfigArmor(String paraName) {
        return SRPMobConfigProvider.srpMobConfig.get((Object)paraName).armorMulti.floatValue();
    }

    public static float getMobConfigHealth(String paraName) {
        return SRPMobConfigProvider.srpMobConfig.get((Object)paraName).healthMulti.floatValue();
    }

    public static float getMobConfigKBRes(String paraName) {
        return SRPMobConfigProvider.srpMobConfig.get((Object)paraName).kbresMulti.floatValue();
    }

    public static int getMobConfigSpawnWeight(String paraName) {
        return SRPMobConfigProvider.srpMobConfig.get((Object)paraName).spawnWeight;
    }

    public static boolean getMobConfigEnabled(String paraName) {
        return SRPMobConfigProvider.srpMobConfig.get((Object)paraName).enabled;
    }

    public static String getParaGroup(int paraId) {
        for (Map.Entry<String, List<Integer>> entry : mobGroupToParaIdMap.entrySet()) {
            if (!entry.getValue().contains(paraId)) continue;
            return entry.getKey();
        }
        return "";
    }

    public static void registerParasite(String name, int paraId) {
        SRPMobConfigProvider.registerParasite(name, paraId, null, null, null);
    }

    public static void registerParasite(String name, int paraId, @Nullable String group) {
        SRPMobConfigProvider.registerParasite(name, paraId, group, null, null);
    }

    public static void registerParasite(String name, int paraId, @Nullable String group, @Nullable Byte typeId) {
        SRPMobConfigProvider.registerParasite(name, paraId, group, typeId, null);
    }

    public static void registerParasite(String name, int paraId, @Nullable String group, @Nullable Byte typeId, @Nullable List<VariantDisableRule.EnumVariant> variants) {
        mobNameToParaIdMap.put(name, paraId);
        paraIdToMobName.put(paraId, name);
        if (group != null) {
            mobGroupToParaIdMap.computeIfAbsent(group, newGroup -> new ArrayList()).add(paraId);
        }
        if (typeId != null) {
            mobNameToParaTypeMap.put(name, typeId);
        }
        if (variants != null) {
            mobNameToVariantsMap.put(name, variants);
        }
    }

    public static void registerMobs() {
        SRPMobConfigProvider.registerParasite("pri_longarms", 1, "PRIMITIVE", (byte)31, Arrays.asList(VariantDisableRule.EnumVariant.VIRULENT, VariantDisableRule.EnumVariant.BERSERKER, VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("sim_bigspider", 2, "ASSIMILATED", (byte)14);
        SRPMobConfigProvider.registerParasite("carrier_heavy", 3, "INBORN", (byte)41, Collections.singletonList(VariantDisableRule.EnumVariant.SPECIAL));
        SRPMobConfigProvider.registerParasite("pri_yelloweye", 4, "PRIMITIVE", (byte)31, Collections.singletonList(VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("buglin", 5, "INBORN", (byte)1);
        SRPMobConfigProvider.registerParasite("sim_human", 6, "ASSIMILATED", (byte)11);
        SRPMobConfigProvider.registerParasite("hi_blaze", 9960, "HIJACKED", (byte)11);
        SRPMobConfigProvider.registerParasite("hi_skeleton", 9961, "HIJACKED", (byte)11);
        SRPMobConfigProvider.registerParasite("pri_manducater", 7, "PRIMITIVE", (byte)31, Collections.singletonList(VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("pri_summoner", 8, "PRIMITIVE", (byte)31, Arrays.asList(VariantDisableRule.EnumVariant.VIRULENT, VariantDisableRule.EnumVariant.BERSERKER, VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("overseer", 9, "PURE", (byte)51, Collections.singletonList(VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("pri_reeker", 10, "PRIMITIVE", (byte)31, Arrays.asList(VariantDisableRule.EnumVariant.SPECIAL, VariantDisableRule.EnumVariant.VIRULENT, VariantDisableRule.EnumVariant.BERSERKER, VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("carrier_flying", 11, "INBORN", (byte)31, Collections.singletonList(VariantDisableRule.EnumVariant.SPECIAL));
        SRPMobConfigProvider.registerParasite("rupter", 12, "INBORN", (byte)5, Arrays.asList(VariantDisableRule.EnumVariant.VIRULENT, VariantDisableRule.EnumVariant.BERSERKER));
        SRPMobConfigProvider.registerParasite("sim_cow", 13, "ASSIMILATED", (byte)11);
        SRPMobConfigProvider.registerParasite("sim_sheep", 14, "ASSIMILATED", (byte)12);
        SRPMobConfigProvider.registerParasite("sim_wolf", 15, "ASSIMILATED", (byte)13);
        SRPMobConfigProvider.registerParasite("beckon_si", 16, "NEXUS", (byte)0);
        SRPMobConfigProvider.registerParasite("pri_bolster", 17, "PRIMITIVE", (byte)31, Arrays.asList(VariantDisableRule.EnumVariant.VIRULENT, VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("beckon_sii", 18, "NEXUS", (byte)0);
        SRPMobConfigProvider.registerParasite("beckon_siii", 19, "NEXUS", (byte)0);
        SRPMobConfigProvider.registerParasite("anc_overlord", 20, "ANCIENT", (byte)63);
        SRPMobConfigProvider.registerParasite("sim_wolfhead", 21, "ASSIMILATED", (byte)0);
        SRPMobConfigProvider.registerParasite("sim_sheephead", 22, "ASSIMILATED", (byte)0);
        SRPMobConfigProvider.registerParasite("movingflesh", 23, "CRUDE", (byte)100);
        SRPMobConfigProvider.registerParasite("anc_dreadnaut", 24, "ANCIENT", (byte)62);
        SRPMobConfigProvider.registerParasite("vigilante", 25, "PURE", (byte)51, Collections.singletonList(VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("sim_pig", 26, "ASSIMILATED", (byte)15);
        SRPMobConfigProvider.registerParasite("sim_villager", 27, "ASSIMILATED", (byte)11);
        SRPMobConfigProvider.registerParasite("sim_cowhead", 28, "ASSIMILATED", (byte)0);
        SRPMobConfigProvider.registerParasite("kyphosis", 29, "DETERRENT", (byte)40);
        SRPMobConfigProvider.registerParasite("sentry", 30, "DETERRENT", (byte)40);
        SRPMobConfigProvider.registerParasite("sim_pighead", 31, "ASSIMILATED", (byte)0);
        SRPMobConfigProvider.registerParasite("sim_villagerhead", 32, "ASSIMILATED", (byte)0);
        SRPMobConfigProvider.registerParasite("warden", 33, "PURE", (byte)51, Collections.singletonList(VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("anc_pod", 34, null, (byte)61);
        SRPMobConfigProvider.registerParasite("anc_dreadnaut_ten", 35, "ANCIENT", (byte)62);
        SRPMobConfigProvider.registerParasite("worker", 36, "INBORN", (byte)7);
        SRPMobConfigProvider.registerParasite("pri_tozoon", 37, "PRIMITIVE", (byte)31);
        SRPMobConfigProvider.registerParasite("pri_arachnida", 38, "PRIMITIVE", (byte)31, Arrays.asList(VariantDisableRule.EnumVariant.VIRULENT, VariantDisableRule.EnumVariant.BERSERKER, VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("incompleteform_small", 39, "CRUDE", (byte)11);
        SRPMobConfigProvider.registerParasite("sim_adventurer", 40, "ASSIMILATED", (byte)11);
        SRPMobConfigProvider.registerParasite("beckon_siv", 41, "NEXUS", (byte)0);
        SRPMobConfigProvider.registerParasite("incompleteform_medium", 43, "CRUDE", (byte)11);
        SRPMobConfigProvider.registerParasite("sim_horse", 44, "ASSIMILATED", (byte)11);
        SRPMobConfigProvider.registerParasite("sim_horsehead", 45, "ASSIMILATED", (byte)0);
        SRPMobConfigProvider.registerParasite("sim_humanhead", 46, "ASSIMILATED", (byte)0);
        SRPMobConfigProvider.registerParasite("bomber_light", 47, "PURE", (byte)51, Collections.singletonList(VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("host", 48, "CRUDE", (byte)11);
        SRPMobConfigProvider.registerParasite("sim_bear", 49, "ASSIMILATED", (byte)11);
        SRPMobConfigProvider.registerParasite("marauder", 50, "PURE", (byte)51, Collections.singletonList(VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("ada_longarms", 51, "ADAPTED", (byte)41, Arrays.asList(VariantDisableRule.EnumVariant.SPECIAL, VariantDisableRule.EnumVariant.VIRULENT, VariantDisableRule.EnumVariant.BERSERKER, VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("ada_manducater", 52, "ADAPTED", (byte)41, Collections.singletonList(VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("ada_summoner", 53, "ADAPTED", (byte)41, Arrays.asList(VariantDisableRule.EnumVariant.VIRULENT, VariantDisableRule.EnumVariant.BERSERKER, VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("ada_reeker", 54, "ADAPTED", (byte)41, Arrays.asList(VariantDisableRule.EnumVariant.VIRULENT, VariantDisableRule.EnumVariant.BERSERKER, VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("ada_yelloweye", 55, "ADAPTED", (byte)41, Collections.singletonList(VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("ada_bolster", 56, "ADAPTED", (byte)41, Arrays.asList(VariantDisableRule.EnumVariant.VIRULENT, VariantDisableRule.EnumVariant.BERSERKER, VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("ada_arachnida", 58, "ADAPTED", (byte)41, Arrays.asList(VariantDisableRule.EnumVariant.VIRULENT, VariantDisableRule.EnumVariant.BERSERKER, VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("sim_enderman", 59, "ASSIMILATED", (byte)14, Collections.singletonList(VariantDisableRule.EnumVariant.SPECIAL));
        SRPMobConfigProvider.registerParasite("grunt", 60, "PURE", (byte)51, Arrays.asList(VariantDisableRule.EnumVariant.VIRULENT, VariantDisableRule.EnumVariant.BERSERKER, VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("crux", 62, "CRUDE", (byte)41);
        SRPMobConfigProvider.registerParasite("heed", 63, "CRUDE", (byte)31);
        SRPMobConfigProvider.registerParasite("sim_dragone", 64, "ASSIMILATED", (byte)14);
        SRPMobConfigProvider.registerParasite("bomber_heavy", 65, "PREEMINENT", (byte)61);
        SRPMobConfigProvider.registerParasite("pri_devourer", 66, "PRIMITIVE", (byte)31, Collections.singletonList(VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("sim_endermanhead", 69, "ASSIMILATED", (byte)0);
        SRPMobConfigProvider.registerParasite("sim_dragonehead", 70, "ASSIMILATED", (byte)0);
        SRPMobConfigProvider.registerParasite("sim_adventurerhead", 71, "ASSIMILATED", (byte)0);
        SRPMobConfigProvider.registerParasite("seizer", 72, "DETERRENT", (byte)40);
        SRPMobConfigProvider.registerParasite("dispatcher_si", 73, "NEXUS", (byte)0);
        SRPMobConfigProvider.registerParasite("dispatcherten", 74, "DETERRENT", (byte)40);
        SRPMobConfigProvider.registerParasite("hostii", 75, "CRUDE", (byte)41);
        SRPMobConfigProvider.registerParasite("mangler", 76, "INBORN", (byte)51, Arrays.asList(VariantDisableRule.EnumVariant.VIRULENT, VariantDisableRule.EnumVariant.BERSERKER));
        SRPMobConfigProvider.registerParasite("dispatcher_sii", 77, "NEXUS", (byte)0);
        SRPMobConfigProvider.registerParasite("dispatcher_siii", 78, "NEXUS", (byte)0);
        SRPMobConfigProvider.registerParasite("dispatcher_siv", 79, "NEXUS", (byte)0);
        SRPMobConfigProvider.registerParasite("thrall", 80, "CRUDE", (byte)31, Collections.singletonList(VariantDisableRule.EnumVariant.SPECIAL));
        SRPMobConfigProvider.registerParasite("seeker", 82, null, (byte)51);
        SRPMobConfigProvider.registerParasite("monarch", 84, "PURE", (byte)51, Arrays.asList(VariantDisableRule.EnumVariant.SPECIAL, VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("wraith", 85, "PREEMINENT", (byte)61);
        SRPMobConfigProvider.registerParasite("bogle", 86, "PREEMINENT", (byte)61);
        SRPMobConfigProvider.registerParasite("haunter", 87, "PREEMINENT", (byte)63, Collections.singletonList(VariantDisableRule.EnumVariant.SPECIAL));
        SRPMobConfigProvider.registerParasite("carrier_colony", 88, "PREEMINENT", SRPMixinsConfigHandler.spawns.fixColonyCarrierTypeId ? (byte)63 : 31, Collections.singletonList(VariantDisableRule.EnumVariant.SPECIAL));
        SRPMobConfigProvider.registerParasite("succor", 89, "PREEMINENT", (byte)61);
        SRPMobConfigProvider.registerParasite("architect", 90, "PREEMINENT", (byte)51);
        SRPMobConfigProvider.registerParasite("gnat", 91, "INBORN", (byte)5);
        SRPMobConfigProvider.registerParasite("pri_vermin", 92, "PRIMITIVE", (byte)31);
        SRPMobConfigProvider.registerParasite("fer_cow", 93, "FERAL", (byte)11);
        SRPMobConfigProvider.registerParasite("fer_enderman", 94, "FERAL", (byte)11);
        SRPMobConfigProvider.registerParasite("fer_horse", 95, "FERAL", (byte)11);
        SRPMobConfigProvider.registerParasite("fer_human", 96, "FERAL", (byte)11);
        SRPMobConfigProvider.registerParasite("fer_pig", 97, "FERAL", (byte)11);
        SRPMobConfigProvider.registerParasite("fer_sheep", 98, "FERAL", (byte)11);
        SRPMobConfigProvider.registerParasite("fer_villager", 99, "FERAL", (byte)11);
        SRPMobConfigProvider.registerParasite("tendril", 202, null, (byte)0);
        SRPMobConfigProvider.registerParasite("biomass", 205, null, (byte)100);
        SRPMobConfigProvider.registerParasite("wave", 211, null, (byte)0);
        SRPMobConfigProvider.registerParasite("waveshock", 213, null, (byte)0);
        SRPMobConfigProvider.registerParasite("fer_wolf", 300, "FERAL", (byte)11);
        SRPMobConfigProvider.registerParasite("hi_golem", 301, "HIJACKED", (byte)11);
        SRPMobConfigProvider.registerParasite("carrier_light", 304, "INBORN", (byte)41, Collections.singletonList(VariantDisableRule.EnumVariant.SPECIAL));
        SRPMobConfigProvider.registerParasite("fer_bear", 306, "FERAL", (byte)11);
        SRPMobConfigProvider.registerParasite("sim_squid", 307, "ASSIMILATED", (byte)15, Collections.singletonList(VariantDisableRule.EnumVariant.BREACHER));
        SRPMobConfigProvider.registerParasite("worm", 308, "DETERRENT", (byte)40);
        SRPMobConfigProvider.registerParasite("draconite", 309, "COSMICAL", (byte)14);
        if (Loader.isModLoaded((String)"srpextra")) {
            SRPMobConfigProvider.registerSRPExtraMobs();
        }
        if (Loader.isModLoaded((String)"srpdeepseadanger")) {
            SRPMobConfigProvider.registerSRPDeepSeaDangerMobs();
        }
        if (Loader.isModLoaded((String)"srpquark")) {
            SRPMobConfigProvider.registerSRPQuarkMobs();
        }
        if (Loader.isModLoaded((String)"srpmutantbeasts")) {
            SRPMobConfigProvider.registerSRPMutantBeastsMobs();
        }
    }

    public static void registerSRPExtraMobs() {
        SRPMobConfigProvider.registerParasite("hi_creeper", -1, "HIJACKED");
        SRPMobConfigProvider.registerParasite("hi_creeperhead", -257, "HIJACKED");
        SRPMobConfigProvider.registerParasite("hi_skeleton_srpe", -2, "HIJACKED");
        SRPMobConfigProvider.registerParasite("hi_skeletonhead", -258, "HIJACKED");
        SRPMobConfigProvider.registerParasite("hi_stray", -3, "HIJACKED");
        SRPMobConfigProvider.registerParasite("sim_witch", -4, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("sim_witchhead", -260, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("sim_vindicator", -5, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("sim_vindicatorhead", -261, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("sim_evoker", -6, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("sim_ocelot", -7, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("sim_ocelothead", -263, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("fer_ocelot", -519, "FERAL");
        SRPMobConfigProvider.registerParasite("wendigo", -8, "CRUDE");
        SRPMobConfigProvider.registerParasite("pri_stalker", -129, "PRIMITIVE");
        SRPMobConfigProvider.registerParasite("ada_stalker", -130, "ADAPTED");
        SRPMobConfigProvider.registerParasite("tendril_stalker", -1130);
        SRPMobConfigProvider.registerParasite("ada_vermin", -131, "ADAPTED");
        SRPMobConfigProvider.registerParasite("ada_tozoon", -132, "ADAPTED");
        SRPMobConfigProvider.registerParasite("tendril_tozoon", -1132);
        SRPMobConfigProvider.registerParasite("fer_wolf_srpe", -133, "FERAL");
        SRPMobConfigProvider.registerParasite("swimming_flesh", -134, "CRUDE");
        SRPMobConfigProvider.registerParasite("flying_flesh", -135, "CRUDE");
        SRPMobConfigProvider.registerParasite("burnt_flesh", -136, "CRUDE");
        SRPMobConfigProvider.registerParasite("fer_adventurer", -137, "FERAL");
    }

    public static void registerSRPDeepSeaDangerMobs() {
        SRPMobConfigProvider.registerParasite("sim_drowned", -21, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("sim_dolphin", -22, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("sim_dolphin_head", -278, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("fer_dolphin", -534, "FERAL");
        SRPMobConfigProvider.registerParasite("sim_fish", -23, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("fer_fish", -279, "FERAL");
        SRPMobConfigProvider.registerParasite("hi_guardian", -24, "HIJACKED");
        SRPMobConfigProvider.registerParasite("hi_elder_guardian", -25, "HIJACKED");
        SRPMobConfigProvider.registerParasite("swimmer", -151, "INBORN");
        SRPMobConfigProvider.registerParasite("leecher", -152, "INBORN");
        SRPMobConfigProvider.registerParasite("pri_hammerhead", -153, "PRIMITIVE");
        SRPMobConfigProvider.registerParasite("ada_hammerhead", -154, "ADAPTED");
        SRPMobConfigProvider.registerParasite("tendril_hammerhead", -1154);
        SRPMobConfigProvider.registerParasite("ada_devourer", -155, "ADAPTED");
        SRPMobConfigProvider.registerParasite("sprouter_si", -156, "NEXUS");
        SRPMobConfigProvider.registerParasite("sprouter_sii", -157, "NEXUS");
        SRPMobConfigProvider.registerParasite("sprouter_siii", -158, "NEXUS");
        SRPMobConfigProvider.registerParasite("sprouter_siv", -159, "NEXUS");
        SRPMobConfigProvider.registerParasite("plankton", -160, "INBORN");
        SRPMobConfigProvider.registerParasite("carrier_sea", -161, "INBORN");
        SRPMobConfigProvider.registerParasite("bomber_mini", -162, "INBORN");
        SRPMobConfigProvider.registerParasite("supporter", -163, "PURE");
        SRPMobConfigProvider.registerParasite("pri_stinger", -164, "PRIMITIVE");
        SRPMobConfigProvider.registerParasite("ada_stinger", -165, "ADAPTED");
    }

    public static void registerSRPQuarkMobs() {
        SRPMobConfigProvider.registerParasite("hijacked_skeleton_pirate", -51, "HIJACKED");
        SRPMobConfigProvider.registerParasite("hijacked_skeleton_ashen", -52, "HIJACKED");
        SRPMobConfigProvider.registerParasite("sim_dweller", -53, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("sim_archaeologist", -54, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("sim_stoneling", -55, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("sim_crab", -56, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("sim_frog", -57, "ASSIMILATED");
    }

    public static void registerSRPMutantBeastsMobs() {
        SRPMobConfigProvider.registerParasite("assimilated_mutant_zombie", -71, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("assimilated_mutant_enderman", -72, "ASSIMILATED");
        SRPMobConfigProvider.registerParasite("hijacked_mutant_skeleton", -73, "HIJACKED");
    }

    private static class SRPMobConfig {
        public final Boolean enabled;
        public final Float dmgMulti;
        public final Float armorMulti;
        public final Float healthMulti;
        public final Float kbresMulti;
        public final Integer spawnWeight;

        public SRPMobConfig(Boolean enabled, Float dmgMulti, Float armorMulti, Float healthMulti, Float kbresMulti, Integer spawnWeight) {
            this.enabled = enabled;
            this.dmgMulti = dmgMulti;
            this.armorMulti = armorMulti;
            this.healthMulti = healthMulti;
            this.kbresMulti = kbresMulti;
            this.spawnWeight = spawnWeight;
        }
    }
}

