/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config.providers;

import com.dhanantry.scapeandrunparasites.util.config.SRPConfigMobs;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import srpmixins.SRPMixins;
import srpmixins.config.providers.SRPMobConfigProvider;

@Mod.EventBusSubscriber
public class LootPoolProvider {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).setPrettyPrinting().create();
    public static final Map<Integer, ResourceLocation> lootTableLocations = new HashMap<Integer, ResourceLocation>();
    public static final Map<ResourceLocation, LootTable> lootTables = new HashMap<ResourceLocation, LootTable>();
    private static File lootTablesFolder;
    public static final ThreadLocal<Boolean> readingFromSRPMixinsConfig;
    private static final LootCondition[] noConditions;

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (!event.getName().func_110624_b().equals("srparasites")) {
            return;
        }
        event.setTable(lootTables.get(event.getName()));
    }

    public static void setupLootPoolFolders(File modConfig) {
        File modFolder = new File(modConfig, "srpmixins");
        if (!(modFolder.exists() && modFolder.isDirectory() || modFolder.mkdir())) {
            SRPMixins.LOGGER.error("SRPMixins: Could not create general configuration folder");
            return;
        }
        lootTablesFolder = new File(modFolder, "loot_tables");
        if (!(lootTablesFolder.exists() && lootTablesFolder.isDirectory() || lootTablesFolder.mkdir())) {
            SRPMixins.LOGGER.error("SRPMixins: Could not create loot table configuration folder");
        }
    }

    private static void registerLootTable(String paraName, LootTable table) {
        ResourceLocation lootTableLoc = new ResourceLocation("srparasites", "entities/" + paraName);
        int paraId = SRPMobConfigProvider.mobNameToParaIdMap.getOrDefault(paraName, Integer.MIN_VALUE);
        if (paraId != Integer.MIN_VALUE) {
            lootTableLocations.put(paraId, lootTableLoc);
            lootTables.put(lootTableLoc, table);
            LootTableList.func_186375_a((ResourceLocation)lootTableLoc);
        } else {
            SRPMixins.LOGGER.warn("SRPMixins unable to register parasite loot table, no parasite id registered for {}", (Object)paraName);
        }
    }

    public static void getLootPoolsFromConfigOrFile() {
        List<String> readParaNames = LootPoolProvider.readLootPoolsFromFile();
        LootPoolProvider.getLootPoolsFromConfigAndWriteToFile(readParaNames);
    }

    private static List<String> readLootPoolsFromFile() {
        ArrayList<String> readNames = new ArrayList<String>();
        File[] files = lootTablesFolder.listFiles();
        if (files == null) {
            SRPMixins.LOGGER.error("Failed to load loot table, folder is invalid");
            SRPMixins.LOGGER.info("=== Finishing SRPMixins loot table Data Loading ===");
            return readNames;
        }
        for (File file : files) {
            if (file.isDirectory()) continue;
            JsonElement elem = LootPoolProvider.getJson(file);
            if (elem == null) {
                SRPMixins.LOGGER.warn("Failed to parse loot table file: {}", (Object)file.getName());
                continue;
            }
            try {
                readingFromSRPMixinsConfig.set(true);
                LootTable lootTable = (LootTable)gson.fromJson(elem, LootTable.class);
                readingFromSRPMixinsConfig.set(false);
                if (lootTable == null) {
                    SRPMixins.LOGGER.warn("Failed to load loot table file, invalid file: {}", (Object)file.getName());
                    continue;
                }
                String paraName = file.getName().split("\\.json")[0];
                LootPoolProvider.registerLootTable(paraName, lootTable);
                readNames.add(paraName);
            }
            catch (Exception e) {
                SRPMixins.LOGGER.warn("Failed to load loot table file: {}, {}", (Object)file.getName(), (Object)e);
                e.printStackTrace(System.out);
            }
        }
        return readNames;
    }

    @Nullable
    private static JsonElement getJson(File file) {
        if (file == null || !file.exists()) {
            SRPMixins.LOGGER.warn("Failed to load SRPMixins config file, file does not exist");
            return null;
        }
        try {
            if (!file.setReadable(true)) {
                SRPMixins.LOGGER.warn("Failed to load SRPMixins config file, no permission to read the file: {}", (Object)file.getName());
                return null;
            }
            String fileString = Files.toString((File)file, (Charset)Charset.defaultCharset());
            return new JsonParser().parse(fileString);
        }
        catch (Exception e) {
            SRPMixins.LOGGER.warn("Failed to load SRPMixins config file: {}, {}", (Object)file.getName(), (Object)e);
            return null;
        }
    }

    private static void getLootPoolsFromConfigAndWriteToFile(List<String> readParaNames) {
        HashMap<String, String[]> lootTableConfigs = new HashMap<String, String[]>(){
            {
                this.put("pri_longarms", SRPConfigMobs.shycoLoot);
                this.put("sim_bigspider", SRPConfigMobs.dorpaLoot);
                this.put("carrier_heavy", SRPConfigMobs.ratholLoot);
                this.put("pri_yelloweye", SRPConfigMobs.emanaLoot);
                this.put("buglin", SRPConfigMobs.LodoLoot);
                this.put("sim_human", SRPConfigMobs.infhumanLoot);
                this.put("pri_manducater", SRPConfigMobs.hullLoot);
                this.put("pri_summoner", SRPConfigMobs.canraLoot);
                this.put("overseer", SRPConfigMobs.alafhaLoot);
                this.put("pri_reeker", SRPConfigMobs.noglaLoot);
                this.put("carrier_flying", SRPConfigMobs.butholLoot);
                this.put("rupter", SRPConfigMobs.mudoLoot);
                this.put("sim_cow", SRPConfigMobs.infcowLoot);
                this.put("sim_sheep", SRPConfigMobs.infsheepLoot);
                this.put("sim_wolf", SRPConfigMobs.infwolfLoot);
                this.put("beckon_si", SRPConfigMobs.venkrolLoot);
                this.put("pri_bolster", SRPConfigMobs.zetmoLoot);
                this.put("beckon_sii", SRPConfigMobs.venkrolsiiLoot);
                this.put("beckon_siii", SRPConfigMobs.venkrolsiiiLoot);
                this.put("anc_overlord", SRPConfigMobs.terlaLoot);
                this.put("sim_wolfhead", SRPConfigMobs.infwolfheadLoot);
                this.put("sim_sheephead", SRPConfigMobs.infsheepheadLoot);
                this.put("movingflesh", SRPConfigMobs.kolLoot);
                this.put("anc_dreadnaut", SRPConfigMobs.oroncoLoot);
                this.put("vigilante", SRPConfigMobs.angedLoot);
                this.put("sim_pig", SRPConfigMobs.infpigLoot);
                this.put("sim_villager", SRPConfigMobs.infvillagerLoot);
                this.put("sim_cowhead", SRPConfigMobs.infcowheadLoot);
                this.put("kyphosis", SRPConfigMobs.tonroLoot);
                this.put("sentry", SRPConfigMobs.unvoLoot);
                this.put("sim_pighead", SRPConfigMobs.infpigheadLoot);
                this.put("sim_villagerhead", SRPConfigMobs.infvillagerheadLoot);
                this.put("warden", SRPConfigMobs.ganroLoot);
                this.put("anc_pod", SRPConfigMobs.pod1Loot);
                this.put("worker", SRPConfigMobs.kolLoot);
                this.put("pri_tozoon", SRPConfigMobs.wymoLoot);
                this.put("pri_arachnida", SRPConfigMobs.arachnidaLoot);
                this.put("incompleteform_small", SRPConfigMobs.inhooSLoot);
                this.put("sim_adventurer", SRPConfigMobs.infadventurerLoot);
                this.put("beckon_siv", SRPConfigMobs.venkrolsivLoot);
                this.put("incompleteform_medium", SRPConfigMobs.inhooMLoot);
                this.put("sim_horse", SRPConfigMobs.infhorseLoot);
                this.put("sim_horsehead", SRPConfigMobs.infhorseheadLoot);
                this.put("sim_humanhead", SRPConfigMobs.infhumanheadLoot);
                this.put("bomber_light", SRPConfigMobs.ombooLoot);
                this.put("host", SRPConfigMobs.hostLoot);
                this.put("sim_bear", SRPConfigMobs.infbearLoot);
                this.put("marauder", SRPConfigMobs.esorLoot);
                this.put("ada_longarms", SRPConfigMobs.shycoadaptedloot);
                this.put("ada_manducater", SRPConfigMobs.hulladaptedloot);
                this.put("ada_summoner", SRPConfigMobs.canraadaptedloot);
                this.put("ada_reeker", SRPConfigMobs.noglaadaptedloot);
                this.put("ada_yelloweye", SRPConfigMobs.emanaadaptedloot);
                this.put("ada_bolster", SRPConfigMobs.zetmoadaptedloot);
                this.put("ada_arachnida", SRPConfigMobs.arachnidaadaptedloot);
                this.put("sim_enderman", SRPConfigMobs.infendermanLoot);
                this.put("grunt", SRPConfigMobs.flogLoot);
                this.put("crux", SRPConfigMobs.cruxaLoot);
                this.put("heed", SRPConfigMobs.heedLoot);
                this.put("sim_dragone", SRPConfigMobs.infdragoneLoot);
                this.put("bomber_heavy", SRPConfigMobs.jinjoLoot);
                this.put("pri_devourer", SRPConfigMobs.lumLoot);
                this.put("sim_endermanhead", SRPConfigMobs.infendermanheadLoot);
                this.put("sim_dragonehead", SRPConfigMobs.infdragoneheadLoot);
                this.put("sim_adventurerhead", SRPConfigMobs.infadventurerheadLoot);
                this.put("seizer", SRPConfigMobs.nakLoot);
                this.put("dispatcher_si", SRPConfigMobs.dodsiLoot);
                this.put("dispatcherten", SRPConfigMobs.ratholLoot);
                this.put("hostii", SRPConfigMobs.herdLoot);
                this.put("mangler", SRPConfigMobs.nuuhLoot);
                this.put("dispatcher_sii", SRPConfigMobs.dodsiiLoot);
                this.put("dispatcher_siii", SRPConfigMobs.dodsiiiLoot);
                this.put("dispatcher_siv", SRPConfigMobs.dodsivLoot);
                this.put("thrall", SRPConfigMobs.thrallLoot);
                this.put("seeker", SRPConfigMobs.ombooLoot);
                this.put("monarch", SRPConfigMobs.orchLoot);
                this.put("wraith", SRPConfigMobs.elviaLoot);
                this.put("bogle", SRPConfigMobs.lenciaLoot);
                this.put("haunter", SRPConfigMobs.pheonLoot);
                this.put("carrier_colony", SRPConfigMobs.vestaLoot);
                this.put("succor", SRPConfigMobs.flamLoot);
                this.put("gnat", SRPConfigMobs.ataLoot);
                this.put("pri_vermin", SRPConfigMobs.ikiLoot);
                this.put("fer_cow", SRPConfigMobs.fercowLoot);
                this.put("fer_enderman", SRPConfigMobs.ferendermanLoot);
                this.put("fer_horse", SRPConfigMobs.ferhorseLoot);
                this.put("fer_human", SRPConfigMobs.ferhumanLoot);
                this.put("fer_pig", SRPConfigMobs.ferpigLoot);
                this.put("fer_sheep", SRPConfigMobs.fersheepLoot);
                this.put("fer_villager", SRPConfigMobs.fervillagerLoot);
                this.put("fer_wolf", SRPConfigMobs.ferwolfLoot);
                this.put("hi_golem", SRPConfigMobs.higolemLoot);
                this.put("carrier_light", SRPConfigMobs.gotholLoot);
                this.put("fer_bear", SRPConfigMobs.ferbearLoot);
                this.put("sim_squid", SRPConfigMobs.infsquidLoot);
                this.put("draconite", SRPConfigMobs.hebluLoot);
            }
        };
        for (Map.Entry entry : lootTableConfigs.entrySet()) {
            if (readParaNames.contains(entry.getKey())) continue;
            LootTable mobLoot = new LootTable(new LootPool[0]);
            LootPool pool_dropOnlyOne = LootPoolProvider.createLootPool(null, "drop only one of these");
            int dropOnlyOneCounter = 0;
            String lastDropOnlyOneNormalName = null;
            LootEntryItem lastDropOnlyOneEntry = null;
            String paraName = (String)entry.getKey();
            if (paraName == null) {
                SRPMixins.LOGGER.error("SRPMixins unable to find parasite {}", entry.getKey());
                continue;
            }
            for (String s : (String[])entry.getValue()) {
                String[] split = s.split(";");
                if (split.length < 4) {
                    SRPMixins.LOGGER.warn("SRPMixins: Unable to parse SRP Loot Pool line for {}, too few entries (Expected pattern: modid:itemname;oddsIn100;maxQuantity;alwaysDrop): {}", (Object)paraName, (Object)s);
                    continue;
                }
                Item item = Item.func_111206_d((String)split[0].trim());
                if (item == null) {
                    SRPMixins.LOGGER.warn("SRPMixins: Unable to parse SRP Loot Pool line for {}, item {} doesn't exist: {}", (Object)paraName, (Object)split[0], (Object)s);
                    continue;
                }
                try {
                    int chance = Integer.parseInt(split[1].trim());
                    int maxQuantity = Integer.parseInt(split[2].trim());
                    boolean independentDrop = Boolean.parseBoolean(split[3].trim());
                    String normalName = "pool for " + item.getRegistryName().toString();
                    if (independentDrop) {
                        mobLoot.addPool(LootPoolProvider.createLootPool((LootEntry)LootPoolProvider.createLootEntry(item, maxQuantity, chance), normalName));
                        continue;
                    }
                    lastDropOnlyOneEntry = LootPoolProvider.createLootEntry(item, maxQuantity, chance);
                    ++dropOnlyOneCounter;
                    lastDropOnlyOneNormalName = normalName;
                    pool_dropOnlyOne.addEntry((LootEntry)lastDropOnlyOneEntry);
                }
                catch (Exception e) {
                    SRPMixins.LOGGER.warn("SRPMixins: Unable to parse SRP Loot Pool line for {}, expected String; int; int; boolean: {}", (Object)paraName, (Object)s);
                }
            }
            if (dropOnlyOneCounter > 1) {
                mobLoot.addPool(pool_dropOnlyOne);
            } else if (dropOnlyOneCounter == 1) {
                mobLoot.addPool(LootPoolProvider.createLootPool(lastDropOnlyOneEntry, lastDropOnlyOneNormalName));
            }
            LootPoolProvider.registerLootTable(paraName, mobLoot);
            try {
                File file = new File(lootTablesFolder, String.format("%s.json", paraName));
                if (file.exists()) continue;
                if (!file.createNewFile()) {
                    SRPMixins.LOGGER.error("SRPMixins: Failed to create new loot table file, {}", (Object)paraName);
                    continue;
                }
                if (!file.setWritable(true)) {
                    SRPMixins.LOGGER.error("SRPMixins: Failed to set new loot table file writeable, {}", (Object)paraName);
                    continue;
                }
                JsonObject elem = LootPoolProvider.cleanUpJson(gson.toJsonTree((Object)mobLoot).getAsJsonObject());
                String entryString = gson.toJson((JsonElement)elem);
                PrintWriter writer = new PrintWriter(file);
                writer.write(entryString);
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                SRPMixins.LOGGER.error("SRPMixins: Failed to generate default loot table file, {}, {}", (Object)paraName, (Object)e);
            }
        }
    }

    private static JsonObject cleanUpJson(JsonObject elem) {
        elem.remove("isFrozen");
        JsonArray pools = elem.getAsJsonArray("pools");
        for (JsonElement poolElem : pools) {
            JsonObject poolObj = poolElem.getAsJsonObject();
            for (JsonElement entryElem : poolObj.getAsJsonArray("entries")) {
                JsonObject entryObj = entryElem.getAsJsonObject();
                entryObj.remove("entryName");
                entryObj.remove("weight");
                entryObj.remove("quality");
            }
        }
        return elem;
    }

    private static LootPool createLootPool(LootEntry entry, String name) {
        if (entry == null) {
            return new LootPool(new LootEntry[0], noConditions, new RandomValueRange(1.0f), new RandomValueRange(0.0f), name);
        }
        return new LootPool(new LootEntry[]{entry}, noConditions, new RandomValueRange(1.0f), new RandomValueRange(0.0f), name);
    }

    private static LootEntryItem createLootEntry(Item item, int maxCount, int chanceInHundred) {
        return new LootEntryItem(item, 1, 0, new LootFunction[]{new SetCount(noConditions, new RandomValueRange(1.0f, (float)maxCount)), new LootingEnchantBonus(noConditions, new RandomValueRange(0.0f), 0)}, new LootCondition[]{new RandomChanceWithLooting((float)chanceInHundred / 100.0f, 0.0f)}, "entry for 1 to " + maxCount + " of " + item.getRegistryName().toString() + ", chance " + chanceInHundred + "%");
    }

    static {
        readingFromSRPMixinsConfig = ThreadLocal.withInitial(() -> false);
        noConditions = new LootCondition[0];
    }
}

