/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config.providers;

import java.util.HashMap;
import java.util.Map;
import srpmixins.SRPMixins;
import srpmixins.config.SRPMixinsConfigHandler;
import srpmixins.config.SRPMixinsConfigProvider;

public class DimensionMultiConfigProvider {
    public static final Map<Integer, Float> dimensionDropMultipliers = new HashMap<Integer, Float>();
    public static final Map<Integer, Float> dimensionMobCapMultipliers = new HashMap<Integer, Float>();

    public static Map<Integer, Float> getDmgMap() {
        return SRPMixinsConfigProvider.dimensionDmgMultipliers;
    }

    public static Map<Integer, Float> getHPMap() {
        return SRPMixinsConfigProvider.dimensionHealthMultipliers;
    }

    public static Map<Integer, Float> getArmorMap() {
        return SRPMixinsConfigProvider.dimensionArmorMultipliers;
    }

    public static Map<Integer, Float> getKBResMap() {
        return SRPMixinsConfigProvider.dimensionKBResMultipliers;
    }

    public static void init() {
        DimensionMultiConfigProvider.setupDimensionMultiplierMap(DimensionMultiConfigProvider.getHPMap(), SRPMixinsConfigHandler.dimension.dimensionHealthMultipliers);
        DimensionMultiConfigProvider.setupDimensionMultiplierMap(DimensionMultiConfigProvider.getDmgMap(), SRPMixinsConfigHandler.dimension.dimensionDmgMultipliers);
        DimensionMultiConfigProvider.setupDimensionMultiplierMap(DimensionMultiConfigProvider.getArmorMap(), SRPMixinsConfigHandler.dimension.dimensionArmorMultipliers);
        DimensionMultiConfigProvider.setupDimensionMultiplierMap(DimensionMultiConfigProvider.getKBResMap(), SRPMixinsConfigHandler.dimension.dimensionKBResMultipliers);
        DimensionMultiConfigProvider.setupDimensionMultiplierMap(dimensionDropMultipliers, SRPMixinsConfigHandler.dimension.dimensionDropMultipliers);
        DimensionMultiConfigProvider.setupDimensionMultiplierMap(dimensionMobCapMultipliers, SRPMixinsConfigHandler.dimension.dimensionMobCapMultipliers);
    }

    public static void reset() {
        DimensionMultiConfigProvider.getDmgMap().clear();
        DimensionMultiConfigProvider.getHPMap().clear();
        DimensionMultiConfigProvider.getArmorMap().clear();
        DimensionMultiConfigProvider.getKBResMap().clear();
        dimensionDropMultipliers.clear();
        dimensionMobCapMultipliers.clear();
        DimensionMultiConfigProvider.init();
    }

    public static void setupDimensionMultiplierMap(Map<Integer, Float> map, String[] config) {
        for (String line : config) {
            String[] split = line.split(",");
            if (split.length < 2) continue;
            try {
                int dim = Integer.parseInt(split[0].trim());
                float multi = Float.parseFloat(split[1].trim());
                if (map.containsKey(dim)) continue;
                map.put(dim, Float.valueOf(multi));
            }
            catch (NumberFormatException e) {
                SRPMixins.LOGGER.warn("SRPMixins config could not parse dimension multiplier line {}", (Object)line);
            }
        }
    }
}

