/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import srpmixins.SRPMixins;
import srpmixins.config.SRPMixinsConfigHandler;

public class ChunkPhaseConfigProvider {
    public static final Map<String, Byte> biomeStartPhases = new HashMap<String, Byte>();
    public static final List<Integer> chunkPhasesDimensionBlacklist = new ArrayList<Integer>();
    public static int chunkPhasesSpacing = SRPMixinsConfigHandler.chunkphases.chunkSpacing;
    public static int chunkPhasesHalfSpacing = chunkPhasesSpacing >> 1;
    public static boolean chunkPhasesSpacingIsOdd = (chunkPhasesSpacing & 1) == 1;

    public static void reset() {
        biomeStartPhases.clear();
        chunkPhasesDimensionBlacklist.clear();
        ChunkPhaseConfigProvider.init();
    }

    public static void init() {
        for (String s : SRPMixinsConfigHandler.chunkphases.biomeStartPhases) {
            String[] split = s.split(",");
            if (split.length < 2) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse biome start phase entry, expected pattern: modid:biomename; startPhase, provided was: {}", (Object)s);
                continue;
            }
            try {
                String biomeId = split[0].trim();
                byte startPhase = Byte.parseByte(split[1].trim());
                biomeStartPhases.put(biomeId, startPhase);
            }
            catch (Exception e) {
                SRPMixins.LOGGER.warn("SRPMixins unable to parse biome start phase entry, expected number after semicolon, provided was: {}", (Object)s);
            }
        }
        for (int dimId : SRPMixinsConfigHandler.chunkphases.dimensionBlacklist) {
            chunkPhasesDimensionBlacklist.add(dimId);
        }
    }
}

