/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.config.folders;

import fermiumbooter.annotations.MixinConfig;
import net.minecraftforge.common.config.Config;

@MixinConfig(name="srpmixins")
public class VariousConfig {
    @Config.Comment(value={"Disables the automatic debug log spam for Scent Entities"})
    @Config.Name(value="Disable Scent Debug")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.disablescentdebug.json", defaultValue=true)
    public boolean disableScentDebug = true;
    @Config.Comment(value={"Make SRP Blacklists/Whitelists use wildcards to dis/enable whole mods (*). WARNING: this forces you to change all current SRP config lists that use full mod names without wildcards"})
    @Config.Name(value="SRP Blacklists are Wildcard-able")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.wildcardablelists.json", defaultValue=false)
    public boolean blacklistsWildcardable = false;
    @Config.Comment(value={"SRP parses its config list every single time instead of caching the result. For performance this stores the results instead."})
    @Config.Name(value="Fix Config List Parsing")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.configlistfix.json", defaultValue=true)
    public boolean fixConfigListParse = true;
    @Config.Comment(value={"SRP has a bunch of configs that are not used. This toggle makes them all do what they are supposed to do. List of affected configs:\n- Default Phase, Points, CanGain, Can(t)Lose\n- Most Phase 9+10 configs (cooldown, killcount plus, scent bonus+reaction, beckon grow penalties, crop grow stunned, mobs spawning with COTH, beckon spawn from residue\n- Spawning Rates of certain mobs making them not spawn at all with phases disabled (Monarch, Feral Bear, Light Carrier, Thrall)\n- Merging flesh not spawning primitives with reduced health defined via merge config\n- Mob Health/Dmg/Armor/KBres multipliers (Gnat, Hijacked Golem, Light Carrier, Worker, Prim Vermin, Feral Bear)\n- XP value of sentries and kyphosis not using the deterrent XP value\n- Preeminents incorrectly using the Pure value for remain value\n- Points over time dimension blacklist\n- Min phase for Beckons ignoring summoning cooldown"})
    @Config.Name(value="Use Forgotten Configs")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.forgottenconfigs.json", defaultValue=true)
    public boolean useForgottenConfigs = true;
    @Config.Comment(value={"Adaptable mobs can steal food from the players inventory via attacks or scary orbs. Use this blacklist to disable them from stealing certain foods. Pattern: modid:itemname, optional metadata"})
    @Config.Name(value="Food Steal Item Blacklist")
    public String[] foodBlacklist = new String[0];
    @Config.Comment(value={"Set to true to make the food steal item blacklist a whitelist instead"})
    @Config.Name(value="Food Steal Item Blacklist is Whitelist")
    public boolean foodBlacklistIsWhitelist = false;
    @Config.Comment(value={"Parasites regularly break blocks. Use this list to blacklist some blocks for certain parasites or parasite groups.\nSpecial group names: PRIMITIVE, ADAPTED, PURE, PREEMINENT, ANCIENT, NEXUS, DETERRENT, ASSIMILATED, FERAL, INBORN, HIJACKED, CRUDE\nFor specific parasites use their ingame mobid so for example ada_longarms\nExpected pattern: modid:blockname, list of parasite mobids and parasite groups separated by comma"})
    @Config.Name(value="Block Break Blacklist")
    public String[] blockBreakBlacklist = new String[0];
    @Config.Comment(value={"All crafting ingredient parasite drops stack to 16 except for strange bones. This makes them also stack to 16. Reintroduced after moving it to RLMixins"})
    @Config.Name(value="Make Strange Bones stack to 16")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.strangebonestacking.json", defaultValue=true)
    public boolean strangeBoneStacking = true;
    @Config.Comment(value={"SRP Commands don't have proper autocompletion. This fixes it. Also fixes the /help command for them."})
    @Config.Name(value="Fix SRP Command Autocompletion")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.commandfix.json", defaultValue=true)
    public boolean fixCommandOverrides = true;
    @Config.Comment(value={"SRP always uses the same method to treat its various config blacklists. In the case of an empty whitelist (list empty & treatAsWhitelist = true) the list is incorrectly treated as an empty BLACKlist, so instead of \"deny all\" its treated as \"allow all\". This fixes it."})
    @Config.Name(value="Fix Empty Whitelists read as Blacklists")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.emptywhitelistfix.json", defaultValue=true)
    public boolean fixEmptyWhitelist = true;
    @Config.Comment(value={"Some parasites have broken right click handling. When looking at them, all right click actions such as raising shields and drinking potions will get cancelled. This fixes it."})
    @Config.Name(value="Fix Right Clicking Parasite Entities")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.parasiterightclickfix.json", defaultValue=true)
    public boolean fixParasiteMobRightClick = true;
    @Config.Comment(value={"Waves and Shockwaves are normal Parasite Entities and thus get lots of normal parasite behavior, for example the ability to target any mob once the phase is above phase total slaughter. This makes the wave instantly die though. This fixes it."})
    @Config.Name(value="Fix Wave Entities Early Death")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.wavefix.json", defaultValue=true)
    public boolean fixWaveRetargeting = true;
    @Config.Comment(value={"Disables non-SRP armor models from rendering in SRPLayerBipedArmor to avoid crashes"})
    @Config.Name(value="SRPModelBiped Render Crash Fix")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.armorcrash.json", defaultValue=true)
    public boolean srpModelBipedRenderCrashFix = true;
    @Config.Comment(value={"Will make scent entities unable to push players and other entities."})
    @Config.Name(value="Scents NoClip")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.scentsnoclip.json", defaultValue=true)
    public boolean scentsDontClip = true;
    @Config.Comment(value={"Max distance to a node of stage 1,2,3 to be found by the node compass. Will be disabled if its not exactly three entries. Clear the list if you want to disable it."})
    @Config.Name(value="Node Compass max distance")
    public int[] nodeCompassMaxDist = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
    @Config.Comment(value={"Fixes SRP playing multiple phase increase warning sounds at the same time if there is multiple players in the dimension it happens in."})
    @Config.Name(value="Fix Multiple Phase Warnings")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.movingsoundfix.json", defaultValue=true)
    public boolean fixMovingSound = true;
    @Config.Comment(value={"Fixes Parasites with Tendrils regaining them on chunk reload. Also fixes Assimilated Enderdragon regaining its head the same way."})
    @Config.Name(value="Fix Paras Regaining Tendrils")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.tendrilfix.json", defaultValue=true)
    public boolean fixTendrilRegain = true;
    @Config.Comment(value={"Using RenderLib makes the head entity of Stage 4 Dispatchers not render. This fixes it."})
    @Config.Name(value="Fix Dispatcher Stage IV Head")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.renderdispatcherhead.json", defaultValue=true)
    public boolean fixDispatcher4Head = true;
    @Config.Comment(value={"Parasites can't break blocks with zero hardness (slime, tnt etc). This fixes it."})
    @Config.Name(value="Fix Zero Hardness Break")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.zerohardnessbreak.json", defaultValue=true)
    public boolean fixZeroHardness = true;
    @Config.Comment(value={"Replaces all SRP loot configs with vanilla loot table jsons that will be written into /config/srpmixins/loot_tables/some_parasite.json and can be modified there.\nDelete files there to make them regenerate from SRPs config system.\nFor people wanting to add looting modifiers to SRP drops, the relevant LootingEnchantBonus/RandomChanceWithLooting modifiers are already setup with default values of \"no looting effect\"You can optionally use the loot condition srp_phase (member: \"phase_range\" (value: min & max or just an integer)) to vary the loot tables over evolution phase"})
    @Config.Name(value="Use Vanilla Loot Tables")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.srpmixins.vanilla.lootpoolparser.json", lateMixin="mixins.srpmixins.srp.loottables.json", defaultValue=true)
    public boolean useLootTables = true;
    @Config.Comment(value={"Restores the behavior where rupters in low phases will not just ignore players but actively avoid them just like they avoid other mobs."})
    @Config.Name(value="Rupters Avoid Players")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.srpmixins.srp.ruptersavoidplayers.json", defaultValue=true)
    public boolean ruptersAvoidPlayers = true;
}

